package org.lsst.ccs.subsystem.rafts.data;

import java.io.Serializable;

/**
 *******************************************
 *
 *  Contains a set of REB register values
 *
 *  @author Owen Saxton
 *
 *******************************************
 */
public class RegisterData implements Serializable 
{
    private final int address;        // Starting address of the data
    private final int count;          // Number of values in the array
    private final int [] values;      // Array of register values

    public RegisterData(int address, int count, int[] values) {
        this.address = address;
        this.count   = count;
        this.values  = values;
    }
    
    public int getAddress() {
        return address;
    }

    public int getCount() {
        return count;
    }

    public int[] getValues() {
        return values;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int j = 0; j < count; j++) {
            if ((j & 3) == 0) {
                if (j != 0) str.append("\n");
                str.append(String.format("%06x:", address + j));
            }
            str.append(String.format(" %08x", values[j]));
        }
        return str.toString();
    }

    private static final long serialVersionUID = 2776380143133420866L;
}
