/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.powermanage;

import java.util.Properties;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.subsystems.powermanage.PMTest;

public class PMTestSim
extends PMTest {
    private static final long UPDATE_PERIOD = 1000L;
    private int chanState = 0;
    private int lastChanState;
    private ChanSim[] simData;
    private long baseTime = System.currentTimeMillis();
    Random RN = new Random();
    private double simAngle;
    private double simAngleStartVal = 0.0;
    private double simAngleStep = 0.035;

    @Override
    void addStructure(Properties struct) {
        this.simData = new ChanSim[this.nChan];
        int k = 0;
        while (k < this.nChan) {
            this.simData[k] = new ChanSim();
            ++k;
        }
    }

    @Override
    void addDefaultConfiguration(Properties dfltConfig) {
    }

    @Override
    void addConfiguration() {
    }

    @Override
    void openHdw() {
        this.baseTime = System.currentTimeMillis();
        this.simAngle = this.simAngleStartVal;
    }

    @Override
    void initHdw() {
        int j = 0;
        while (j < this.nChan) {
            PMTest.Channel chan = this.chanData[j];
            ChanSim sim = this.simData[j];
            sim.baseVal = chan.type == 2 ? 1.2 * chan.oWarnLimit - 0.2 * chan.oFaultLimit : 0.5 * (chan.uFaultLimit + chan.oFaultLimit);
            ++j;
        }
        new Timer().schedule((TimerTask)new UpdateState(), 0L, 1000L);
    }

    void simParmValues() {
        int j = 0;
        while (j < this.nChan) {
            double rn = this.RN.nextDouble();
            PMTest.Channel chan = this.chanData[j];
            ChanSim sim = this.simData[j];
            switch (chan.type) {
                case 0: {
                    double s = Math.sin(this.simAngle);
                    double d = s * (chan.uFaultLimit - sim.baseVal) * 1.05;
                    chan.value = d + sim.baseVal + 0.05 * sim.baseVal * (0.5 - rn);
                    break;
                }
                case 1: {
                    double c = Math.cos(this.simAngle);
                    double d = c * (chan.uFaultLimit - sim.baseVal) * 1.05;
                    chan.value = d + sim.baseVal + 0.05 * sim.baseVal * (0.5 - rn);
                    break;
                }
                case 2: {
                    chan.value = sim.baseVal + 0.5 * (0.5 - rn);
                    break;
                }
            }
            this.setChanStateBit(j);
            double intvl = (double)(System.currentTimeMillis() - this.baseTime) / 1000.0;
            this.simAngle = this.simAngleStartVal + this.simAngleStep * intvl;
            ++j;
        }
    }

    @Override
    void getParmValues() {
    }

    @Override
    void setParmLimits(int id) {
    }

    @Override
    void getParmLimits(int id, double[] limits) {
        PMTest.Channel chan = this.chanData[id];
        switch (chan.type) {
            case 0: {
                limits[0] = 0.8;
                limits[1] = 0.9;
                limits[2] = 1.1;
                limits[3] = 1.2;
                break;
            }
            case 1: {
                limits[0] = 8.0;
                limits[1] = 0.0;
                limits[2] = 11.0;
                limits[3] = 12.0;
                break;
            }
            case 2: {
                limits[0] = 0.0;
                limits[1] = 0.0;
                limits[2] = 40.0;
                limits[3] = 50.0;
                break;
            }
        }
    }

    @Override
    int getChanStateBit(int id) {
        return this.chanState >> id & 1;
    }

    @Override
    int getChanState() {
        return this.chanState;
    }

    private void setChanStateBit(int id) {
        PMTest.Channel chan = this.chanData[id];
        boolean value = true;
        if (chan.value < chan.uFaultLimit || chan.value > chan.oFaultLimit) {
            value = false;
        }
        this.chanState = value ? (this.chanState |= 1 << id) : (this.chanState &= ~(1 << id));
    }

    private static class ChanSim {
        double baseVal;
    }

    private class UpdateState
    extends TimerTask {
        private UpdateState() {
        }

        @Override
        public void run() {
            if (!PMTestSim.this.running) {
                return;
            }
            PMTestSim.this.simParmValues();
            if (PMTestSim.this.chanState != PMTestSim.this.lastChanState) {
                PMTestSim.this.lastChanState = PMTestSim.this.chanState;
                PMTestSim.this.tick();
                PMTestSim.this.publishState();
            }
        }
    }
}

