/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.powermanage;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.lsst.ccs.bus.Status;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.powermanage.data.PMChannel;
import org.lsst.ccs.subsystems.powermanage.data.PMFullState;
import org.lsst.ccs.subsystems.powermanage.data.PMState;
import org.lsst.ccs.subsystems.powermanage.status.PMStateStatus;

public abstract class PMTest
extends Module {
    static final int MAX_CHANS = 3;
    static final int CHAN_TYPE_VOLT = 0;
    static final int CHAN_TYPE_CURR = 1;
    static final int CHAN_TYPE_TEMP = 2;
    static final String PREFIX = "org.lsst.ccs.powermanage.";
    String structFile = "structure.properties";
    String configFile = "config.properties";
    Properties config;
    Channel[] chanData;
    int nChan;
    int uFLimitChange;
    int oFLimitChange;
    int uWLimitChange = 0;
    int oWLimitChange = 0;
    boolean running = false;

    public void initModule() {
        this.initStructure();
        this.openHdw();
        this.initConfiguration();
        this.initHdw();
    }

    public void tick() {
        if (!this.running) {
            System.out.println("PowerManage test system started");
            this.publishState();
            this.publishLimits();
            this.running = true;
        }
        this.getParmValues();
        ArrayList<ValueNotification> trendingValues = new ArrayList<ValueNotification>();
        int j = 0;
        while (j < this.nChan) {
            Channel chan = this.chanData[j];
            long ts = System.currentTimeMillis();
            trendingValues.add(new ValueNotification(chan.name, (Object)chan.value, ts));
            ++j;
        }
        trendingValues.add(new ValueNotification("state", (Object)this.getState()));
        this.publishData(trendingValues);
    }

    public void setStructFile(String name) {
        this.structFile = name;
    }

    public void setConfigFile(String name) {
        this.configFile = name;
    }

    public void setTickMillis(int value) {
        super.setTickMillis(value);
        if (this.running) {
            this.publishState();
        }
    }

    public void setUFaultLimit(int id, double limit) {
        Channel chan = this.chanData[id];
        if (chan.type == 2) {
            // empty if block
        }
        if (limit == chan.uFaultLimit) {
            return;
        }
        chan.uFaultLimit = limit;
        String sLimit = String.valueOf(limit);
        this.config.setProperty(chan.uFaultLimitName, sLimit);
        this.setParmLimits(id);
        this.uFLimitChange |= 1 << id;
        this.publishState();
        this.getSubsystem().publishMetaData(chan.name, "UnderFault", sLimit);
    }

    public void setOFaultLimit(int id, double limit) {
        Channel chan = this.chanData[id];
        if (limit == chan.oFaultLimit) {
            return;
        }
        chan.oFaultLimit = limit;
        String sLimit = String.valueOf(limit);
        this.config.setProperty(chan.oFaultLimitName, sLimit);
        this.setParmLimits(id);
        this.oFLimitChange |= 1 << id;
        this.publishState();
        this.getSubsystem().publishMetaData(chan.name, "OverFault", sLimit);
    }

    public void setUWarnLimit(int id, double limit) {
        Channel chan = this.chanData[id];
        if (chan.type != 0) {
            return;
        }
        if (limit == chan.uWarnLimit) {
            return;
        }
        chan.uWarnLimit = limit;
        String sLimit = String.valueOf(limit);
        this.config.setProperty(chan.uWarnLimitName, sLimit);
        this.setParmLimits(id);
        this.uWLimitChange |= 1 << id;
        this.publishState();
        this.getSubsystem().publishMetaData(chan.name, "UnderWarn", sLimit);
    }

    public void setOWarnLimit(int id, double limit) {
        Channel chan = this.chanData[id];
        if (limit == chan.oWarnLimit) {
            return;
        }
        chan.oWarnLimit = limit;
        String sLimit = String.valueOf(limit);
        this.config.setProperty(chan.oWarnLimitName, sLimit);
        this.setParmLimits(id);
        this.oFLimitChange |= 1 << id;
        this.publishState();
        this.getSubsystem().publishMetaData(chan.name, "OverWarn", sLimit);
    }

    public void saveConfiguration() {
        FileWriter writer = null;
        try {
            writer = new FileWriter(this.configFile);
        }
        catch (IOException e) {
            log.error((Object)("Error opening configuration file: " + e), new String[0]);
        }
        if (writer != null) {
            try {
                this.config.store(writer, "PM test configuration");
                this.oWLimitChange = 0;
                this.uWLimitChange = 0;
                this.oFLimitChange = 0;
                this.uFLimitChange = 0;
                this.publishState();
            }
            catch (IOException e) {
                log.error((Object)("Error writing configuration: " + e), new String[0]);
            }
            try {
                writer.close();
            }
            catch (IOException e) {
                log.error((Object)("Error closing configuration file: " + e), new String[0]);
            }
        }
    }

    public int getState() {
        int value = this.getChanState();
        return value;
    }

    public PMFullState getFullState() {
        PMFullState status = new PMFullState();
        int i = 0;
        while (i < this.nChan) {
            Channel c = this.chanData[i];
            status.addChannel(new PMChannel(c.name, c.description, c.units, c.uFaultLimit, c.oFaultLimit, c.uWarnLimit, c.oWarnLimit, c.value));
            ++i;
        }
        status.setPMState(new PMState(this.getState(), this.uFLimitChange, this.oFLimitChange, this.uWLimitChange, this.oWLimitChange, this.getTickMillis()));
        return status;
    }

    public void publishState() {
        PMState pmState = new PMState(this.getState(), this.uFLimitChange, this.oFLimitChange, this.uWLimitChange, this.oWLimitChange, this.getTickMillis());
        this.sendToStatus((Status)new PMStateStatus(pmState));
    }

    public void publishLimits() {
        int i = 0;
        while (i < this.nChan) {
            Channel c = this.chanData[i];
            this.getSubsystem().publishMetaData(c.name, "UnderFault", String.valueOf(c.uFaultLimit));
            this.getSubsystem().publishMetaData(c.name, "OverFault", String.valueOf(c.oFaultLimit));
            this.getSubsystem().publishMetaData(c.name, "UnderWarn", String.valueOf(c.uWarnLimit));
            this.getSubsystem().publishMetaData(c.name, "OverWarn", String.valueOf(c.oWarnLimit));
            ++i;
        }
    }

    private void initStructure() {
        Properties struct = this.loadProperties(this.structFile, null);
        try {
            this.nChan = Integer.decode(struct.getProperty("org.lsst.ccs.powermanage.nchan"));
            if (this.nChan <= 0 || this.nChan > 3) {
                throw new NumberFormatException();
            }
        }
        catch (NullPointerException nullPointerException) {
            log.error((Object)"General structure is missing nchan property", new String[0]);
            this.nChan = 0;
            return;
        }
        catch (NumberFormatException numberFormatException) {
            log.error((Object)"Invalid number of channels specified", new String[0]);
            this.nChan = 0;
            return;
        }
        String[] names = new String[]{"names", "descs", "types"};
        this.chanData = new Channel[this.nChan];
        String[][] pValues = new String[names.length][];
        int j = 0;
        while (j < names.length) {
            String pValue = struct.getProperty(PREFIX + names[j]);
            if (pValue != null) {
                pValues[j] = pValue.split(",");
            } else {
                log.error((Object)("General structure is missing " + names[j] + " property"), new String[0]);
                pValues[j] = new String[this.nChan];
                int k = 0;
                while (k < this.nChan) {
                    pValues[j][k] = j == 2 ? "0" : "";
                    ++k;
                }
            }
            ++j;
        }
        String[] values = new String[names.length];
        int k = 0;
        while (k < this.nChan) {
            int type = 0;
            int j2 = 0;
            while (j2 < names.length) {
                if (k < pValues[j2].length) {
                    values[j2] = pValues[j2][k];
                    if (j2 == 2) {
                        String cType = values[j2];
                        int n = cType.equals("VOLT") ? 0 : (cType.equals("CURR") ? 1 : (type = cType.equals("TEMP") ? 2 : -1));
                        if (type < 0) {
                            log.error((Object)("General structure contains invalid " + names[j2] + " value for channel " + k), new String[0]);
                            type = 0;
                        }
                    }
                } else {
                    log.error((Object)("General structure is missing " + names[j2] + " value for channel " + k), new String[0]);
                    values[j2] = "";
                }
                ++j2;
            }
            this.chanData[k] = new Channel(values[0], values[1], type);
            ++k;
        }
        this.addStructure(struct);
    }

    private void initConfiguration() {
        Channel chan;
        Properties dfltConfig = new Properties();
        int j = 0;
        while (j < this.nChan) {
            chan = this.chanData[j];
            double[] limits = new double[]{0.0, 0.0, 0.0, 0.0};
            this.getParmLimits(j, limits);
            dfltConfig.setProperty(chan.uFaultLimitName, String.valueOf(limits[0]));
            dfltConfig.setProperty(chan.oFaultLimitName, String.valueOf(limits[3]));
            dfltConfig.setProperty(chan.uWarnLimitName, String.valueOf(limits[1]));
            dfltConfig.setProperty(chan.oWarnLimitName, String.valueOf(limits[2]));
            ++j;
        }
        this.config = this.loadProperties(this.configFile, dfltConfig);
        j = 0;
        while (j < this.nChan) {
            chan = this.chanData[j];
            chan.uFaultLimit = Double.valueOf(this.config.getProperty(chan.uFaultLimitName));
            chan.oFaultLimit = Double.valueOf(this.config.getProperty(chan.oFaultLimitName));
            chan.uWarnLimit = Double.valueOf(this.config.getProperty(chan.uWarnLimitName));
            chan.oWarnLimit = Double.valueOf(this.config.getProperty(chan.oWarnLimitName));
            ++j;
        }
        this.addConfiguration();
    }

    private Properties loadProperties(String file, Properties dflt) {
        Properties propList = dflt == null ? new Properties() : new Properties(dflt);
        FileReader reader = null;
        try {
            reader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"Error opening properties file: ", (Throwable)e, new String[0]);
        }
        try {
            propList.load(reader);
        }
        catch (IOException e) {
            log.error((Object)"Error reading properties file: ", (Throwable)e, new String[0]);
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            log.error((Object)"Error closing properties file: ", (Throwable)e, new String[0]);
        }
        return propList;
    }

    abstract void addStructure(Properties var1);

    abstract void addDefaultConfiguration(Properties var1);

    abstract void addConfiguration();

    abstract void openHdw();

    abstract void initHdw();

    abstract void getParmValues();

    abstract void setParmLimits(int var1);

    abstract void getParmLimits(int var1, double[] var2);

    abstract int getChanStateBit(int var1);

    abstract int getChanState();

    static class Channel {
        String name;
        String description;
        String units;
        int type;
        double uFaultLimit;
        double oFaultLimit;
        double uWarnLimit;
        double oWarnLimit;
        String uFaultLimitName;
        String oFaultLimitName;
        String uWarnLimitName;
        String oWarnLimitName;
        double value;

        public Channel(String name, String desc, int type) {
            this.name = name;
            this.description = desc;
            this.type = type;
            this.uFaultLimitName = String.valueOf(name) + "UFaultLim";
            this.oFaultLimitName = String.valueOf(name) + "OFaultLim";
            this.uWarnLimitName = String.valueOf(name) + "UWarnLim";
            this.oWarnLimitName = String.valueOf(name) + "OWarnLim";
            this.units = this.type == 0 ? "V" : (this.type == 1 ? "A" : "C");
        }
    }
}

