/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.powermanage;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.drivers.pmcard.PMCardException;
import org.lsst.ccs.drivers.pmcard.TIUCD90xxx;
import org.lsst.ccs.subsystems.powermanage.PMTest;

public class PMTestHdw
extends PMTest {
    private static final int DEV_PORT = 0;
    private static final int DEV_ADDR = 101;
    private static final int N_DEV_RAILS = 16;
    private static final int UPDATE_PERIOD = 1000;
    private TIUCD90xxx ucd90xxx;
    private int chanState;
    private int lastChanState;
    private double power;
    private boolean ucd90xxxOpened;
    private boolean ucd90xxxInited;
    private ChanHdw[] hdwData;

    @Override
    void addStructure(Properties struct) {
        String[] names = new String[]{"rails"};
        this.hdwData = new ChanHdw[this.nChan];
        String[][] pValues = new String[names.length][];
        int j = 0;
        while (j < names.length) {
            String pValue = struct.getProperty("org.lsst.ccs.powermanage." + names[j]);
            if (pValue != null) {
                pValues[j] = pValue.split(",");
            } else {
                log.error((Object)("Hardware structure is missing " + names[j] + " property"), new String[0]);
                pValues[j] = new String[this.nChan];
                int k = 0;
                while (k < this.nChan) {
                    pValues[j][k] = "-1";
                    ++k;
                }
            }
            ++j;
        }
        int[] values = new int[names.length];
        int k = 0;
        while (k < this.nChan) {
            PMTest.Channel cfr_ignored_0 = this.chanData[k];
            int j2 = 0;
            while (j2 < names.length) {
                try {
                    int value = Integer.decode(pValues[j2][k]);
                    if (j2 == 0 && (value < 0 || value >= 16)) {
                        throw new NumberFormatException();
                    }
                    values[j2] = value;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    log.error((Object)("Hardware structure is missing " + names[j2] + " value for " + this.chanData[k].name), new String[0]);
                    values[j2] = -1;
                }
                catch (NumberFormatException numberFormatException) {
                    log.error((Object)("Hardware structure contains invalid " + names[j2] + " value for " + this.chanData[k].name), new String[0]);
                    values[j2] = -1;
                }
                ++j2;
            }
            this.hdwData[k] = new ChanHdw(values[0]);
            ++k;
        }
    }

    @Override
    void addDefaultConfiguration(Properties dfltConfig) {
    }

    @Override
    void addConfiguration() {
    }

    @Override
    void openHdw() {
        try {
            this.ucd90xxx = new TIUCD90xxx();
            this.ucd90xxx.open(0, 101);
            this.ucd90xxxOpened = true;
        }
        catch (Exception e) {
            log.error((Object)"Error opening TI UCD90xxx device", (Throwable)e, new String[0]);
        }
    }

    @Override
    void initHdw() {
        try {
            int j = 0;
            while (j < this.nChan) {
                ++j;
            }
            this.ucd90xxxInited = true;
        }
        catch (Exception e) {
            log.error((Object)"Error initializing TI UCD90xxx device", (Throwable)e, new String[0]);
        }
        new Timer().schedule((TimerTask)new UpdateState(), 0L, 1000L);
    }

    @Override
    void getParmValues() {
        int j = 0;
        while (j < this.nChan) {
            PMTest.Channel ch = this.chanData[j];
            ChanHdw hw = this.hdwData[j];
            try {
                ch.value = this.ucd90xxx.getParmValue(hw.rail, ch.type);
            }
            catch (PMCardException e) {
                if (this.ucd90xxxInited) {
                    log.error((Object)("Error getting value for channel " + String.valueOf(j)), (Throwable)e, new String[0]);
                }
                ch.value = 0.0;
            }
            ++j;
        }
    }

    @Override
    void setParmLimits(int id) {
        log.error((Object)"setParmLimits not working yet. No corresponding method in PMCard.c", new String[0]);
    }

    @Override
    void getParmLimits(int id, double[] limits) {
        block2: {
            PMTest.Channel chan = this.chanData[id];
            ChanHdw hw = this.hdwData[id];
            try {
                this.ucd90xxx.getParmLimits(hw.rail, chan.type, limits);
            }
            catch (PMCardException e) {
                if (!this.ucd90xxxOpened) break block2;
                log.error((Object)("Error getting limits for channel " + String.valueOf(id)), (Throwable)e, new String[0]);
            }
        }
    }

    @Override
    int getChanStateBit(int id) {
        return this.chanState >> id & 1;
    }

    @Override
    int getChanState() {
        return this.chanState;
    }

    private static class ChanHdw {
        int rail;

        public ChanHdw(int rail) {
            this.rail = rail;
        }
    }

    private class UpdateState
    extends TimerTask {
        private UpdateState() {
        }

        @Override
        public void run() {
            if (!PMTestHdw.this.running) {
                return;
            }
            PMTestHdw.this.chanState = 0;
            int j = 0;
            while (j < PMTestHdw.this.nChan) {
                boolean ok;
                PMTest.Channel ch;
                double value;
                block6: {
                    value = 0.0;
                    ch = PMTestHdw.this.chanData[j];
                    ChanHdw hw = PMTestHdw.this.hdwData[j];
                    try {
                        value = PMTestHdw.this.ucd90xxx.getParmValue(hw.rail, ch.type);
                    }
                    catch (PMCardException e) {
                        if (!PMTestHdw.this.ucd90xxxInited) break block6;
                        log.error((Object)("Error getting value for channel " + String.valueOf(j)), (Throwable)e, new String[0]);
                    }
                }
                boolean bl = ok = value >= ch.uFaultLimit && value <= ch.oFaultLimit;
                if (ok) {
                    PMTestHdw pMTestHdw = PMTestHdw.this;
                    pMTestHdw.chanState = pMTestHdw.chanState | 1 << j;
                }
                ++j;
            }
            if (PMTestHdw.this.chanState != PMTestHdw.this.lastChanState) {
                PMTestHdw.this.lastChanState = PMTestHdw.this.chanState;
                PMTestHdw.this.tick();
                PMTestHdw.this.publishState();
            }
        }
    }
}

