/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.powermanage.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.subsystems.powermanage.data.PMChannel;
import org.lsst.ccs.subsystems.powermanage.data.PMFullState;
import org.lsst.ccs.subsystems.powermanage.data.PMState;
import org.lsst.ccs.subsystems.powermanage.ui.PMGUISubsystem;

public class PMTrendingTable
extends JPanel {
    static final String[] colNames = new String[]{"Description", "Value", "Units", "Under Fault Limit", "Over Fault Limit", "Under Warn Limit", "Over Warn Limit", "Name"};
    static final Class[] colTypes = new Class[]{String.class, TrendingValue.class, String.class, Double.class, Double.class, Double.class, Double.class, String.class};
    static final boolean[] colCanEdit;
    static final Color myRed;
    static final Color myGreen;
    static final Font myFont;
    static final Font changeFont;
    static final int DESCRIPTION_IND = 0;
    static final int VALUE_IND = 1;
    static final int UNITS_IND = 2;
    static final int U_FAULT_LIMIT_IND = 3;
    static final int O_FAULT_LIMIT_IND = 4;
    static final int U_WARN_LIMIT_IND = 5;
    static final int O_WARN_LIMIT_IND = 6;
    static final int NAME_IND = 7;
    PMGUISubsystem pmGui;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    static {
        boolean[] blArray = new boolean[8];
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        blArray[6] = true;
        colCanEdit = blArray;
        myRed = new Color(255, 160, 160);
        myGreen = new Color(160, 255, 160);
        myFont = new Font("Helvetica", 0, 12);
        changeFont = new Font("Helvetica", 1, 12);
    }

    public PMTrendingTable(PMGUISubsystem pmGui) {
        this.initComponents();
        JTableHeader hdr = this.jTable1.getTableHeader();
        hdr.setReorderingAllowed(false);
        hdr.setSize(hdr.getWidth(), hdr.getHeight() + 2);
        this.jTable1.setDefaultRenderer(TrendingValue.class, new TrendingTableCellRenderer());
        this.jTable1.setDefaultRenderer(Double.class, new LimitsCellRenderer());
        this.jTable1.setDefaultRenderer(String.class, new TextCellRenderer());
        this.jTable1.setAutoResizeMode(3);
        this.jTable1.setRowSelectionAllowed(false);
        this.jTable1.setColumnSelectionAllowed(false);
        this.jTable1.setFont(myFont);
        this.jTable1.setRowHeight(this.jTable1.getRowHeight() + 2);
        this.pmGui = pmGui;
    }

    PMGUISubsystem getPMGui() {
        return this.pmGui;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setLayout(new BoxLayout(this, 2));
        this.jTable1.setModel(new TrendingTableModel());
        this.jScrollPane1.setViewportView(this.jTable1);
        this.add(this.jScrollPane1);
    }

    public void updateTableModel(PMFullState status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableModel(status));
    }

    public void updateTableValue(TrendingStatus status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableValues(status));
    }

    public void updateTableValue(MetadataStatus status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableLimits(status));
    }

    public void updateTableValue(PMState status) {
        SwingUtilities.invokeLater(new UpdateTrendingTableState(status));
    }

    private static String fmt(double val) {
        return String.format("%.2f  ", val);
    }

    class LimitsCellRenderer
    extends DefaultTableCellRenderer {
        LimitsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, PMTrendingTable.fmt((Double)value), isSelected, hasFocus, row, column);
            TrendingTableModel cfr_ignored_0 = (TrendingTableModel)table.getModel();
            c.setForeground(Color.black);
            return c;
        }
    }

    class TextCellRenderer
    extends DefaultTableCellRenderer {
        TextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, "  " + (String)value, isSelected, hasFocus, row, column);
        }
    }

    class TrendingTableCellRenderer
    extends DefaultTableCellRenderer {
        TrendingTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, PMTrendingTable.fmt((Double)value), isSelected, hasFocus, row, column);
            TrendingTableModel model = (TrendingTableModel)table.getModel();
            if (column == 1) {
                c.setBackground(model.isValueWithinLimits(row) ? myGreen : myRed);
            } else {
                c.setBackground(Color.white);
            }
            ((JLabel)c).setHorizontalAlignment(4);
            return c;
        }
    }

    class TrendingTableModel
    extends DefaultTableModel
    implements TableModelListener {
        ArrayList<Double> uFaultLimits;
        ArrayList<Double> oFaultLimits;
        ArrayList<Double> uWarnLimits;
        ArrayList<Double> oWarnLimits;
        int systemState;
        int uFLimitChange;
        int oFLimitChange;
        int uWLimitChange;
        int oWLimitChange;

        public TrendingTableModel() {
            super(colNames, 0);
            this.uFaultLimits = new ArrayList();
            this.oFaultLimits = new ArrayList();
            this.uWarnLimits = new ArrayList();
            this.oWarnLimits = new ArrayList();
            this.addTableModelListener(this);
        }

        public Class getColumnClass(int columnIndex) {
            return colTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return colCanEdit[columnIndex];
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            double oldValue;
            int column = e.getColumn();
            if (column != 3 && column != 4 && column != 5 && column != 6) {
                return;
            }
            int row = e.getFirstRow();
            boolean isFLimit = column == 3 || column == 4;
            boolean isULimit = column == 3 || column == 5;
            double newValue = (Double)this.getValueAt(row, column);
            double d = isFLimit ? (isULimit ? this.getUFaultLimit(row) : this.getOFaultLimit(row)) : (oldValue = isULimit ? this.getUWarnLimit(row) : this.getOWarnLimit(row));
            if (newValue != oldValue) {
                PMTrendingTable.this.pmGui.submitLimit(row, newValue, isFLimit, isULimit);
            }
        }

        void addTrendingRow(PMChannel chan) {
            this.uFaultLimits.add(chan.getUFaultLimit());
            this.oFaultLimits.add(chan.getOFaultLimit());
            this.uWarnLimits.add(chan.getUWarnLimit());
            this.oWarnLimits.add(chan.getOWarnLimit());
            this.addRow(new Object[]{chan.getDescription(), chan.getValue(), chan.getUnits(), chan.getUFaultLimit(), chan.getOFaultLimit(), chan.getUWarnLimit(), chan.getOWarnLimit(), chan.getName()});
        }

        void updateTrendingRow(int row, PMChannel chan) {
            this.setValueAt(chan.getDescription(), row, 0);
            this.setValueAt(chan.getValue(), row, 1);
            this.setUFaultLimit(row, chan.getUFaultLimit());
            this.setOFaultLimit(row, chan.getOFaultLimit());
            this.setUWarnLimit(row, chan.getUWarnLimit());
            this.setOWarnLimit(row, chan.getOWarnLimit());
            this.setValueAt(chan.getUnits(), row, 2);
            this.setValueAt(chan.getName(), row, 7);
        }

        void updateValues(TrendingStatus s) {
            List vnl = (List)s.getValue();
            this.systemState = (Integer)((ValueNotification)vnl.get(vnl.size() - 1)).getData();
            int row = 0;
            while (row < this.getRowCount()) {
                this.setValueAt(((ValueNotification)vnl.get(row)).getData(), row, 1);
                ++row;
            }
        }

        void updateLimits(MetadataStatus s) {
            String name = s.getDataName();
            boolean fault = s.getMetadataName().contains("Fault");
            boolean under = s.getMetadataName().contains("Under");
            double limit = Double.valueOf(s.getMetadataValue());
            int i = 0;
            while (i < this.getRowCount()) {
                if (name.equals((String)this.getValueAt(i, 7))) {
                    if (fault) {
                        if (under) {
                            this.setUFaultLimit(i, limit);
                            break;
                        }
                        this.setOFaultLimit(i, limit);
                        break;
                    }
                    if (under) {
                        this.setUWarnLimit(i, limit);
                        break;
                    }
                    this.setOWarnLimit(i, limit);
                    break;
                }
                ++i;
            }
        }

        void updateState(PMState s) {
            this.systemState = s.getSystemState();
        }

        boolean isValueWithinLimits(int row) {
            return (this.systemState & 1 << row) != 0;
        }

        void setUFaultLimit(int row, double value) {
            this.uFaultLimits.set(row, value);
            this.setValueAt(value, row, 3);
        }

        void setOFaultLimit(int row, double value) {
            this.oFaultLimits.set(row, value);
            this.setValueAt(value, row, 4);
        }

        void setUWarnLimit(int row, double value) {
            this.uWarnLimits.set(row, value);
            this.setValueAt(value, row, 5);
        }

        void setOWarnLimit(int row, double value) {
            this.oWarnLimits.set(row, value);
            this.setValueAt(value, row, 6);
        }

        double getUFaultLimit(int row) {
            return this.uFaultLimits.get(row);
        }

        double getOFaultLimit(int row) {
            return this.oFaultLimits.get(row);
        }

        double getUWarnLimit(int row) {
            return this.uWarnLimits.get(row);
        }

        double getOWarnLimit(int row) {
            return this.oWarnLimits.get(row);
        }

        boolean hasUFLimitChanged(int row) {
            return (this.uFLimitChange & 1 << row) != 0;
        }

        boolean hasOFLimitChanged(int row) {
            return (this.oFLimitChange & 1 << row) != 0;
        }

        boolean hasUWLimitChanged(int row) {
            return (this.uWLimitChange & 1 << row) != 0;
        }

        boolean hasOWLimitChanged(int row) {
            return (this.oWLimitChange & 1 << row) != 0;
        }
    }

    class TrendingValue {
        TrendingValue() {
        }
    }

    class UpdateTrendingTableLimits
    implements Runnable {
        MetadataStatus s;

        UpdateTrendingTableLimits(MetadataStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)PMTrendingTable.this.jTable1.getModel()).updateLimits(this.s);
        }
    }

    class UpdateTrendingTableModel
    implements Runnable {
        PMFullState s;

        UpdateTrendingTableModel(PMFullState s) {
            this.s = s;
        }

        @Override
        public void run() {
            ArrayList channelsArray = this.s.getChannelArray();
            TrendingTableModel model = (TrendingTableModel)PMTrendingTable.this.jTable1.getModel();
            int nRows = model.getRowCount();
            if (nRows != 0 && channelsArray.size() != nRows) {
                model = new TrendingTableModel();
                PMTrendingTable.this.jTable1.setModel(model);
                nRows = 0;
            }
            model.updateState(this.s.getPMState());
            if (nRows != 0) {
                int r = 0;
                while (r < nRows) {
                    model.updateTrendingRow(r, (PMChannel)channelsArray.get(r));
                    ++r;
                }
                return;
            }
            for (PMChannel chan : channelsArray) {
                model.addTrendingRow(chan);
            }
            int c = 0;
            while (c < PMTrendingTable.this.jTable1.getColumnCount()) {
                TableColumnModel colModel = PMTrendingTable.this.jTable1.getColumnModel();
                TableColumn col = colModel.getColumn(c);
                TableCellRenderer rndr = PMTrendingTable.this.jTable1.getTableHeader().getDefaultRenderer();
                Component comp = rndr.getTableCellRendererComponent(PMTrendingTable.this.jTable1, col.getHeaderValue(), false, false, 0, 0);
                int width = comp.getPreferredSize().width;
                rndr = PMTrendingTable.this.jTable1.getCellRenderer(0, c);
                Class<?> colClass = PMTrendingTable.this.jTable1.getColumnClass(c);
                if (!colClass.equals(String.class)) {
                    comp = colClass.equals(Double.class) ? rndr.getTableCellRendererComponent(PMTrendingTable.this.jTable1, -999.99, false, false, 0, c) : rndr.getTableCellRendererComponent(PMTrendingTable.this.jTable1, -999.99, false, false, 0, c);
                    width = Math.max(width, comp.getPreferredSize().width);
                } else {
                    int r = 0;
                    while (r < PMTrendingTable.this.jTable1.getRowCount()) {
                        Object value = PMTrendingTable.this.jTable1.getValueAt(r, c);
                        comp = rndr.getTableCellRendererComponent(PMTrendingTable.this.jTable1, value, false, false, r, c);
                        width = Math.max(width, comp.getPreferredSize().width);
                        ++r;
                    }
                }
                col.setPreferredWidth(width + 4);
                ++c;
            }
        }
    }

    class UpdateTrendingTableState
    implements Runnable {
        PMState s;

        UpdateTrendingTableState(PMState s) {
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)PMTrendingTable.this.jTable1.getModel()).updateState(this.s);
        }
    }

    class UpdateTrendingTableValues
    implements Runnable {
        TrendingStatus s;

        UpdateTrendingTableValues(TrendingStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)PMTrendingTable.this.jTable1.getModel()).updateValues(this.s);
        }
    }
}

