package org.lsst.ccs.subsystems.powermanage.ui.jas;

import org.freehep.application.studio.Studio;
import org.freehep.util.FreeHEPLookup;
import org.lsst.ccs.plugin.jas3.LsstSubsystemPlugin;
import org.lsst.ccs.subsystems.powermanage.ui.PMGUISubsystem;

/**
 *
 * @author tonyj
 */
public class PMJasPlugin extends LsstSubsystemPlugin {

    PMGUISubsystem pmGuiSubsystem;
    FreeHEPLookup lookup;

    @Override
    protected void postInit() {
        super.postInit();
        pmGuiSubsystem = new PMGUISubsystem();
        this.getApplication().getPageManager().openPage(pmGuiSubsystem.getGuiLayout(), "PowerManage GUI", null);
        Studio studio = (Studio) Studio.getApplication();
        lookup = studio.getLookup();
        lookup.add(this);
    }

    @Override
    public void disconnectFromMessagingFactory() {
//        closeTracerConsole("PM Tracer");
        pmGuiSubsystem.resetGui();
    }

    @Override
    public void initializeRestServices() {
        registerChannelsForSubsystem("ccs-powermanage");
    }

    @Override
    public void resetRestServices() {
        removeChannelsForSubsystem("ccs-powermanage");
    }

    @Override
    public void connectToMessagingFactory() {
        
        pmGuiSubsystem.initGui();        
//        Console c = createTracerConsole("PM Tracer", null);
//        if ( c != null ) {
//                PrintWriter pw = new PrintWriter(c.getOutputStream(null), true);
//                pmGuiSubsystem.setPrintWriter(pw);            
//        }

        
    }
    
    
}
