/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * PMTrendingTable.java
 *
 * Created on Jan 25, 2012, 8:58:09 AM
 */
package org.lsst.ccs.subsystems.powermanage.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.bus.ValueNotification;
import org.lsst.ccs.subsystems.powermanage.data.PMChannel;
import org.lsst.ccs.subsystems.powermanage.data.PMFullState;
import org.lsst.ccs.subsystems.powermanage.data.PMState;

/**
 *
 * @author xiaowen
 */
public class PMTrendingTable extends javax.swing.JPanel {

    final static String[] colNames
      = {"Description", "Value", "Units", "Under Fault Limit", "Over Fault Limit", "Under Warn Limit", "Over Warn Limit", "Name"};
    final static Class[] colTypes = {String.class, TrendingValue.class,
                                     String.class, Double.class, Double.class, Double.class, Double.class,
                                     String.class};
    final static boolean[] colCanEdit = {false, false, false, true, true, true, true, false};
    final static Color myRed = new Color(255, 160, 160),
                       myGreen = new Color(160, 255, 160);
    final static Font myFont = new Font("Helvetica", Font.PLAIN, 12);
    final static Font changeFont = new Font("Helvetica", Font.BOLD, 12);

    final static int DESCRIPTION_IND = 0;
    final static int VALUE_IND = 1;
    final static int UNITS_IND = 2;
    final static int U_FAULT_LIMIT_IND = 3;
    final static int O_FAULT_LIMIT_IND = 4;
    final static int U_WARN_LIMIT_IND = 5;
    final static int O_WARN_LIMIT_IND = 6;
    final static int NAME_IND = 7;

    PMGUISubsystem pmGui;

    /** Creates new form PMTrendingTable */
    public PMTrendingTable(PMGUISubsystem pmGui) {
        initComponents();
        JTableHeader hdr = jTable1.getTableHeader();
        hdr.setReorderingAllowed(false);
        hdr.setSize(hdr.getWidth(), hdr.getHeight() + 2);
        jTable1.setDefaultRenderer(TrendingValue.class,
                                   new TrendingTableCellRenderer());
        jTable1.setDefaultRenderer(Double.class, new LimitsCellRenderer());
        jTable1.setDefaultRenderer(String.class, new TextCellRenderer());
        jTable1.setAutoResizeMode(JTable.AUTO_RESIZE_LAST_COLUMN);
        jTable1.setRowSelectionAllowed(false);
        jTable1.setColumnSelectionAllowed(false);
        jTable1.setFont(myFont);
        jTable1.setRowHeight(jTable1.getRowHeight() + 2);

        this.pmGui = pmGui;
    }

    PMGUISubsystem getPMGui()
    {
        return pmGui;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();

        setLayout(new javax.swing.BoxLayout(this, javax.swing.BoxLayout.LINE_AXIS));

        jTable1.setModel(new TrendingTableModel());
        jScrollPane1.setViewportView(jTable1);

        add(jScrollPane1);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    // End of variables declaration//GEN-END:variables

    public void updateTableModel(PMFullState status)
    {
        SwingUtilities.invokeLater(new UpdateTrendingTableModel(status));
    }

    public void updateTableValue(TrendingStatus status)
    {
        SwingUtilities.invokeLater(new UpdateTrendingTableValues(status));
    }

    public void updateTableValue(MetadataStatus status)
    {
        SwingUtilities.invokeLater(new UpdateTrendingTableLimits(status));
    }

    public void updateTableValue(PMState status)
    {
        SwingUtilities.invokeLater(new UpdateTrendingTableState(status));
    }

    private static String fmt(double val) {
        return String.format("%.2f  ", val);
    }

    class TrendingTableModel extends DefaultTableModel
                             implements TableModelListener {

        ArrayList<Double> uFaultLimits = new ArrayList<Double>(),
                          oFaultLimits = new ArrayList<Double>(),
                          uWarnLimits  = new ArrayList<Double>(),
                          oWarnLimits  = new ArrayList<Double>();
        int systemState, uFLimitChange, oFLimitChange, uWLimitChange, oWLimitChange;

        public TrendingTableModel() {
            super(colNames, 0);
            addTableModelListener(this);
        }

        @Override
        public Class getColumnClass(int columnIndex) {
            return colTypes[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return colCanEdit[columnIndex];
        }

        @Override
        public void tableChanged(TableModelEvent e)
        {
            int column = e.getColumn();
            if (column != U_FAULT_LIMIT_IND && column != O_FAULT_LIMIT_IND
                && column != U_WARN_LIMIT_IND && column != O_WARN_LIMIT_IND) return;
            int row = e.getFirstRow();
            boolean isFLimit = (column == U_FAULT_LIMIT_IND || column == O_FAULT_LIMIT_IND);
            boolean isULimit = (column == U_FAULT_LIMIT_IND || column == U_WARN_LIMIT_IND);

            double newValue = (Double)getValueAt(row, column);
            double oldValue = isFLimit ? ( isULimit ? getUFaultLimit(row) : getOFaultLimit(row) ) : ( isULimit ? getUWarnLimit(row) : getOWarnLimit(row) );

            if (newValue != oldValue) {
                pmGui.submitLimit(row, newValue, isFLimit, isULimit);
            }
        }

        void addTrendingRow(PMChannel chan) {
            uFaultLimits.add(chan.getUFaultLimit());
            oFaultLimits.add(chan.getOFaultLimit());
            uWarnLimits.add(chan.getUWarnLimit());
            oWarnLimits.add(chan.getOWarnLimit());
            addRow(new Object[]{chan.getDescription(), chan.getValue(),
                                chan.getUnits(), chan.getUFaultLimit(),
                                chan.getOFaultLimit(), chan.getUWarnLimit(),
                                chan.getOWarnLimit(), chan.getName()});
        }

        void updateTrendingRow(int row, PMChannel chan) {
            setValueAt(chan.getDescription(), row, DESCRIPTION_IND);
            setValueAt(chan.getValue(), row, VALUE_IND);
            setUFaultLimit(row, chan.getUFaultLimit());
            setOFaultLimit(row, chan.getOFaultLimit());
            setUWarnLimit(row, chan.getUWarnLimit());
            setOWarnLimit(row, chan.getOWarnLimit());
            setValueAt(chan.getUnits(), row, UNITS_IND);
            setValueAt(chan.getName(), row, NAME_IND);
        }

        void updateValues(TrendingStatus s) {
            List<ValueNotification> vnl = (List<ValueNotification>)s.getValue();
            systemState = (Integer)vnl.get(vnl.size() - 1).getData();
            for (int row = 0; row < getRowCount(); row++) {
                setValueAt(vnl.get(row).getData(), row, VALUE_IND);
            }
        }

        void updateLimits(MetadataStatus s) {
            String name = s.getDataName();
            boolean fault = s.getMetadataName().contains("Fault");
            boolean under = s.getMetadataName().contains("Under");
            double limit = Double.valueOf(s.getMetadataValue());
            for (int i = 0; i < getRowCount(); i++) {
                if (name.equals((String)getValueAt(i, NAME_IND))) {
                    if (fault) {
                        if (under)
                            setUFaultLimit(i, limit);
                        else
                            setOFaultLimit(i, limit);
                        }
                    else {
                        if (under)
                            setUWarnLimit(i, limit);
                        else
                            setOWarnLimit(i, limit);
                        }
                    break;
                }
            }
        }

        void updateState(PMState s) {
            systemState = s.getSystemState();
// xiaowen: this doesn't make any sense to me (for our system)
//  1. no reset of *LimitChange?
//  2. didn't actually update the limits, if changes are from elsewhere
//    -- notice that if this happens, the cell color is changed (in LimitsCellRenderer::getTableCellRendererComponent
// commented out this. The limits are updated in updateLimits anyway
// (notice that in PMTest.java, publishMetaData is always preceded by a publishState)
// (maybe there is no use to have the *LimitChange fields in the PMState class)
//  -- also commented out the relevant lines in LimitsCellRenderer::getTableCellRendererComponent
//            int nRows = getRowCount();
//            int update = uFLimitChange ^ s.getUFLimitChange();
//            uFLimitChange ^= update;
//            for (int row = 0; update != 0 && row < nRows; row++, update >>= 1) {
//                if ((update & 1) != 0)
//                    setValueAt(getUFaultLimit(row), row, U_FAULT_LIMIT_IND);
//            }
//            update = oFLimitChange ^ s.getOFLimitChange();
//            oFLimitChange ^= update;
//            for (int row = 0; update != 0 && row < nRows; row++, update >>= 1) {
//                if ((update & 1) != 0)
//                    setValueAt(getOFaultLimit(row), row, O_FAULT_LIMIT_IND);
//            }
//            uWLimitChange ^= update;
//            for (int row = 0; update != 0 && row < nRows; row++, update >>= 1) {
//                if ((update & 1) != 0)
//                    setValueAt(getUWarnLimit(row), row, U_WARN_LIMIT_IND);
//            }
//            update = oWLimitChange ^ s.getOWLimitChange();
//            oWLimitChange ^= update;
//            for (int row = 0; update != 0 && row < nRows; row++, update >>= 1) {
//                if ((update & 1) != 0)
//                    setValueAt(getOWarnLimit(row), row, O_WARN_LIMIT_IND);
//            }
        }

        boolean isValueWithinLimits(int row) {
            return (systemState & (1 << row)) != 0;
        }

        void setUFaultLimit(int row, double value) {
            uFaultLimits.set(row, value);
            setValueAt(value, row, U_FAULT_LIMIT_IND);
        }

        void setOFaultLimit(int row, double value) {
            oFaultLimits.set(row, value);
            setValueAt(value, row, O_FAULT_LIMIT_IND);
        }

        void setUWarnLimit(int row, double value) {
            uWarnLimits.set(row, value);
            setValueAt(value, row, U_WARN_LIMIT_IND);
        }

        void setOWarnLimit(int row, double value) {
            oWarnLimits.set(row, value);
            setValueAt(value, row, O_WARN_LIMIT_IND);
        }

        double getUFaultLimit(int row) {
            return uFaultLimits.get(row);
        }

        double getOFaultLimit(int row) {
            return oFaultLimits.get(row);
        }

        double getUWarnLimit(int row) {
            return uWarnLimits.get(row);
        }

        double getOWarnLimit(int row) {
            return oWarnLimits.get(row);
        }

        boolean hasUFLimitChanged(int row) {
            return (uFLimitChange & (1 << row)) != 0;
        }
        
        boolean hasOFLimitChanged(int row) {
            return (oFLimitChange & (1 << row)) != 0;
        }

        boolean hasUWLimitChanged(int row) {
            return (uWLimitChange & (1 << row)) != 0;
        }
        
        boolean hasOWLimitChanged(int row) {
            return (oWLimitChange & (1 << row)) != 0;
        }

    }

    class TrendingValue {
    }

    class UpdateTrendingTableValues implements Runnable {

        TrendingStatus s;

        UpdateTrendingTableValues(TrendingStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)jTable1.getModel()).updateValues(s);
        }
    }

    class UpdateTrendingTableLimits implements Runnable {

        MetadataStatus s;

        UpdateTrendingTableLimits(MetadataStatus s) {
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)jTable1.getModel()).updateLimits(s);
        }

    }

    class UpdateTrendingTableState implements Runnable {

        PMState s;

        UpdateTrendingTableState(PMState s) {
            this.s = s;
        }

        @Override
        public void run() {
            ((TrendingTableModel)jTable1.getModel()).updateState(s);
        }

    }

    class UpdateTrendingTableModel implements Runnable {

        PMFullState s;

        UpdateTrendingTableModel(PMFullState s) {
            this.s = s;
        }

        @Override
        public void run() {

            ArrayList<PMChannel> channelsArray = s.getChannelArray();
            TrendingTableModel model = (TrendingTableModel)jTable1.getModel();
            int nRows = model.getRowCount();

            if (nRows != 0 && channelsArray.size() != nRows) {
                model = new TrendingTableModel();
                jTable1.setModel(model);
                nRows = 0;
            }

            model.updateState(s.getPMState());

            if (nRows != 0) {
                for (int r = 0; r < nRows; r++) {
                    model.updateTrendingRow(r, channelsArray.get(r));
                }
                return;
            }

            for (PMChannel chan : channelsArray) {
                model.addTrendingRow(chan);
            }

            for (int c = 0; c < jTable1.getColumnCount(); c++) {
                TableColumnModel colModel = jTable1.getColumnModel();
                TableColumn col = colModel.getColumn(c);
                TableCellRenderer rndr;
                Component comp;

                rndr = jTable1.getTableHeader().getDefaultRenderer();
                comp = rndr.getTableCellRendererComponent(jTable1,
                                                          col.getHeaderValue(),
                                                          false, false, 0, 0);
                int width = comp.getPreferredSize().width;

                rndr = jTable1.getCellRenderer(0, c);
                Class colClass = jTable1.getColumnClass(c);
                if (!colClass.equals(String.class)) {
                    if (colClass.equals(Double.class))
                        comp = rndr.getTableCellRendererComponent(jTable1,
                                                                  -999.99,
                                                                  false, false,
                                                                  0, c);
                    else
                        comp = rndr.getTableCellRendererComponent(jTable1,
                                                                  -999.99,
                                                                  false, false,
                                                                  0, c);
                    width = Math.max(width, comp.getPreferredSize().width);
                }
                else {
                    for (int r = 0; r < jTable1.getRowCount(); r++) {
                        Object value = jTable1.getValueAt(r, c);
                        comp = rndr.getTableCellRendererComponent(jTable1, value,
                                                                  false, false,
                                                                  r, c);
                        width = Math.max(width, comp.getPreferredSize().width);
                    }
                }
                col.setPreferredWidth(width + 4);
            }
        }

    }

    class LimitsCellRenderer extends DefaultTableCellRenderer {

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected,
                                                       boolean hasFocus,
                                                       int row, int column)
        {
            Component c = super.getTableCellRendererComponent(table,
                                                              fmt((Double)value),
                                                              isSelected,
                                                              hasFocus,
                                                              row, column);
            TrendingTableModel model = (TrendingTableModel) table.getModel();
//            if (column == U_FAULT_LIMIT_IND && model.hasUFLimitChanged(row)
//                  || column == O_FAULT_LIMIT_IND && model.hasOFLimitChanged(row)
//                  || column == U_WARN_LIMIT_IND && model.hasUWLimitChanged(row)
//                  || column == O_WARN_LIMIT_IND && model.hasOWLimitChanged(row)) {
//                c.setFont(changeFont);
//                c.setForeground(Color.blue);
//            }
//            else {
                c.setForeground(Color.black);
//            }
//            ((JLabel)c).setHorizontalAlignment(SwingConstants.RIGHT);

            return c;
        }

    }

    class TrendingTableCellRenderer extends DefaultTableCellRenderer {

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected,
                                                       boolean hasFocus,
                                                       int row, int column)
        {
            Component c = super.getTableCellRendererComponent(table,
                                                              fmt((Double)value),
                                                              isSelected,
                                                              hasFocus,
                                                              row, column);
            TrendingTableModel model = (TrendingTableModel)table.getModel();
            if (column == VALUE_IND) {
                c.setBackground(model.isValueWithinLimits(row) ? myGreen : myRed);
            }
            else {
                c.setBackground(Color.white);
            }
            ((JLabel)c).setHorizontalAlignment(SwingConstants.RIGHT);

            return c;
        }

    }

    class TextCellRenderer extends DefaultTableCellRenderer {

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value,
                                                       boolean isSelected,
                                                       boolean hasFocus,
                                                       int row, int column)
        {
            return super.getTableCellRendererComponent(table,
                                                       "  " + (String)value,
                                                       isSelected, hasFocus,
                                                       row, column);
        }

    }

}
