/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.powermanage.ui;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.Command;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.subsystems.powermanage.data.PMFullState;
import org.lsst.ccs.subsystems.powermanage.status.PMStateStatus;
import org.lsst.ccs.subsystems.powermanage.ui.PMAssembly;
import org.lsst.ccs.subsystems.powermanage.ui.PMControlPanel;
import org.lsst.ccs.subsystems.powermanage.ui.PMTrendingTable;

public class PMGUISubsystem
extends Subsystem {
    private static final String powermanage_dest = "ccs-powermanage";
    private PrintWriter out = new PrintWriter(System.out, true);
    private PMAssembly assembly = new PMAssembly(this);
    private PMTrendingTable table = this.assembly.getTrendingTable();
    private PMControlPanel controls = this.assembly.getControlPanel();
    private long lastHeartBeat = 0L;
    private long lastStateRequest = 0L;
    private boolean initialized = false;
    String stateCorrelId;

    public void initGui() {
        this.setName("PMGUIModule");
        this.setListenToStatus(true);
        this.setStatusBroadcastPeriod(0);
        this.start();
        Timer t = new Timer();
        t.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                long delta = (System.currentTimeMillis() - PMGUISubsystem.this.lastHeartBeat) / 1000L;
                if (PMGUISubsystem.this.initialized && delta > 10L) {
                    PMGUISubsystem.this.controls.disableSystem();
                }
            }
        }, new Date(), 5000L);
    }

    public JComponent getGuiLayout() {
        return this.assembly;
    }

    public void resetGui() {
    }

    public static void main(String[] args) {
        System.setProperty("java.naming.factory.initial", "com.sun.enterprise.naming.SerialInitContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "com.sun.enterprise.naming");
        System.setProperty("java.naming.factory.state", "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        System.setProperty("org.omg.CORBA.ORBInitialHost", "localhost");
        System.setProperty("org.omg.CORBA.ORBInitialPort", "3700");
        PMGUISubsystem t = new PMGUISubsystem();
        JFrame frame = new JFrame("PowerManage Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(3);
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    public void onReply(CommandReply s) {
        if (s.getCorrelId().equals(this.stateCorrelId)) {
            PMFullState r = (PMFullState)s.getReply();
            log.debug((Object)"PMGui received PMFullState reply", new String[0]);
            this.table.updateTableModel(r);
            this.controls.updateControlPanel(r.getPMState());
            this.initialized = true;
        }
    }

    public void onStatus(BusMessage s) {
        long currentTime;
        if (!s.getOrigin().equals(powermanage_dest)) {
            return;
        }
        this.lastHeartBeat = s.getTimeStamp();
        if (s instanceof TrendingStatus) {
            log.debug((Object)"PMGui received TrendingStatus message", new String[0]);
            this.table.updateTableValue((TrendingStatus)s);
        } else if (s instanceof MetadataStatus) {
            log.debug((Object)"PMGui received MetadataStatus message", new String[0]);
            this.table.updateTableValue((MetadataStatus)s);
        } else if (s instanceof PMStateStatus) {
            log.debug((Object)"PMGui received PMStateStatus message", new String[0]);
            this.table.updateTableValue(((PMStateStatus)s).getPMState());
            this.controls.updateControlPanel(((PMStateStatus)s).getPMState());
        }
        if (!this.initialized && (currentTime = System.currentTimeMillis()) - this.lastStateRequest > 2000L) {
            this.lastStateRequest = currentTime;
            ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState", new Object[0]);
            this.sendCommand(cmd);
            this.stateCorrelId = cmd.getCorrelId();
        }
    }

    public void submitLimit(int index, double value, boolean isFLimit, boolean isULimit) {
        Integer arg1 = index;
        Double arg2 = value;
        String command = isFLimit ? (isULimit ? "setUFaultLimit" : "setOFaultLimit") : (isULimit ? "setUWarnLimit" : "setOWarnLimit");
        this.sendCommand(new ModuleInvokerCommand(command, new Object[]{arg1, arg2}));
    }

    public void setTickMillis(int value) {
        this.sendCommand(new ModuleInvokerCommand("setTickMillis", new Object[]{value}));
    }

    public void saveConfiguration() {
        this.sendCommand(new ModuleInvokerCommand("saveConfiguration", new Object[0]));
    }

    private void sendCommand(ModuleInvokerCommand cmd) {
        cmd.setDestination(powermanage_dest);
        this.updateCurrentSubsystem();
        this.fac.sendCommand((Command)cmd);
    }
}

