/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.powermanage.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.powermanage.data.PMState;
import org.lsst.ccs.subsystems.powermanage.ui.PMGUISubsystem;

public class PMControlPanel
extends JPanel {
    static final Font f = new Font("Tahoma", 1, 12);
    static final Color myRed = new Color(150, 0, 0);
    static final Color myGreen = new Color(0, 150, 0);
    PMGUISubsystem pmGui;
    double currentPeriod = 5.0;
    private JButton limitsButton;
    private JLabel periodLabel;
    private JTextField periodTextField;
    private JLabel periodUnitsLabel;
    private JLabel stateLabel;
    private JLabel stateStatus;

    public PMControlPanel(PMGUISubsystem pmGui) {
        this.pmGui = pmGui;
        this.initComponents();
        new UpdatePMStatus(new PMState(0, 0, 0, 0, 0, 0)).run();
        new DisableSystem().run();
    }

    private void initComponents() {
        this.stateLabel = new JLabel();
        this.stateStatus = new JLabel();
        this.periodLabel = new JLabel();
        this.periodTextField = new JTextField();
        this.periodUnitsLabel = new JLabel();
        this.limitsButton = new JButton();
        this.stateLabel.setText("System State:");
        this.stateLabel.setHorizontalTextPosition(10);
        this.stateStatus.setText("....");
        this.periodLabel.setText("Update Period:");
        this.periodTextField.setText("...");
        this.periodTextField.setMinimumSize(new Dimension(50, 19));
        this.periodTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMControlPanel.this.periodTextFieldActionPerformed(evt);
            }
        });
        this.periodUnitsLabel.setText("sec");
        this.limitsButton.setText("Save Limits");
        this.limitsButton.setEnabled(false);
        this.limitsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PMControlPanel.this.limitsButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.stateLabel).addGap(6, 6, 6).addComponent(this.stateStatus)).addGroup(layout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.periodLabel).addGap(12, 12, 12).addComponent(this.periodTextField, -2, 50, -2).addGap(4, 4, 4).addComponent(this.periodUnitsLabel).addGap(135, 135, 135).addComponent(this.limitsButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.stateLabel).addComponent(this.stateStatus)).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.periodLabel)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.periodTextField, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.periodUnitsLabel)).addComponent(this.limitsButton))));
    }

    private void periodTextFieldActionPerformed(ActionEvent evt) {
        try {
            double value = Double.valueOf(this.periodTextField.getText());
            this.pmGui.setTickMillis((int)(1000.0 * value));
            this.periodTextField.setEnabled(false);
        }
        catch (NumberFormatException numberFormatException) {
            this.periodTextField.setText(String.valueOf(this.currentPeriod));
        }
    }

    private void limitsButtonActionPerformed(ActionEvent evt) {
        this.pmGui.saveConfiguration();
        this.limitsButton.setEnabled(false);
    }

    public void updateControlPanel(PMState s) {
        SwingUtilities.invokeLater(new UpdatePMStatus(s));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    JButton getLimitsButton() {
        return this.limitsButton;
    }

    class DisableSystem
    implements Runnable {
        DisableSystem() {
        }

        @Override
        public void run() {
            PMControlPanel.this.stateStatus.setText("STOPPED");
            PMControlPanel.this.stateStatus.setForeground(myRed);
            PMControlPanel.this.periodTextField.setEnabled(false);
            PMControlPanel.this.limitsButton.setEnabled(false);
        }
    }

    class UpdatePMStatus
    implements Runnable {
        PMState s;

        UpdatePMStatus(PMState s) {
            this.s = s;
        }

        @Override
        public void run() {
            this.s.getSystemState();
            PMControlPanel.this.stateStatus.setText("RUNNING");
            PMControlPanel.this.stateStatus.setForeground(myGreen);
            PMControlPanel.this.periodTextField.setEnabled(true);
            PMControlPanel.this.currentPeriod = (double)this.s.getTickMillis() / 1000.0;
            PMControlPanel.this.periodTextField.setText(String.valueOf(PMControlPanel.this.currentPeriod));
            int change = this.s.getUFLimitChange() | this.s.getOFLimitChange() | this.s.getUWLimitChange() | this.s.getOWLimitChange();
            PMControlPanel.this.limitsButton.setEnabled(change != 0);
            PMControlPanel.this.repaint();
        }
    }
}

