package org.lsst.ccs.subsystems.powermanage.ui;

import java.io.PrintWriter;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.BusMessage;
import org.lsst.ccs.bus.CommandReply;
import org.lsst.ccs.bus.MetadataStatus;
import org.lsst.ccs.bus.ModuleInvokerCommand;
import org.lsst.ccs.bus.TrendingStatus;
import org.lsst.ccs.subsystems.powermanage.data.PMFullState;
import org.lsst.ccs.subsystems.powermanage.status.PMStateStatus;

/**
 *
 * @author Xiaowen Lei
 */
public class PMGUISubsystem extends Subsystem {

    private static final String powermanage_dest = "ccs-powermanage";
    private PrintWriter out = new PrintWriter(System.out, true);
    private PMAssembly assembly;
    private PMTrendingTable table;
    private PMControlPanel controls;
    private long lastHeartBeat = 0, lastStateRequest = 0;
    private boolean initialized = false;
    String stateCorrelId;

    public PMGUISubsystem() {
        assembly = new PMAssembly(this);
        table = assembly.getTrendingTable();
        //plots  = assembly.getTrendingTable();
        controls = assembly.getControlPanel();
    }

    public void initGui() {
        setName("PMGUIModule");
        setListenToStatus(true);
        setStatusBroadcastPeriod(0);
        start();

        Timer t = new Timer();
        t.scheduleAtFixedRate(new TimerTask() {

            @Override
            public void run() {
                long delta = (System.currentTimeMillis() - lastHeartBeat) / 1000;
                if (initialized && delta > 10) {
                    controls.disableSystem();
                }
            }
        }, new Date(), 5000);
    }

    public JComponent getGuiLayout() {
        return assembly;
    }

    public void resetGui() {
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        System.setProperty("java.naming.factory.initial",
                           "com.sun.enterprise.naming.SerialInitContextFactory");
        System.setProperty("java.naming.factory.url.pkgs",
                           "com.sun.enterprise.naming");
        System.setProperty("java.naming.factory.state",
                           "com.sun.corba.ee.impl.presentation.rmi.JNDIStateFactoryImpl");
        System.setProperty("org.omg.CORBA.ORBInitialHost", "localhost");
        System.setProperty("org.omg.CORBA.ORBInitialPort", "3700");

//        Properties props = FrameworkUtils.loadProperties(FrameworkUtils.getDefaultJndiProperties(),PMGUISubsystem.class.getClass(),"jndi.properties");

        PMGUISubsystem t = new PMGUISubsystem();

        JFrame frame = new JFrame("PowerManage Subsystem");
        frame.setContentPane(t.getGuiLayout());
        frame.pack();
        frame.setVisible(true);
        t.initGui();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    }

    public void setPrintWriter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void onReply(CommandReply s) {
        //FIXME temporary fix to prevent multiple GUIs from interfering with each other.
        //See https://jira.slac.stanford.edu/browse/LSSTCCS-9
        if (s.getCorrelId().equals(stateCorrelId)) {
            PMFullState r = (PMFullState)s.getReply();
            log.debug("PMGui received PMFullState reply");
            table.updateTableModel(r);
            controls.updateControlPanel(r.getPMState());
            initialized = true;
        }
    }

    @Override
    public void onStatus(BusMessage s) {
        if (!s.getOrigin().equals(powermanage_dest)) return;

        lastHeartBeat = s.getTimeStamp();

        if (s instanceof TrendingStatus) {
            log.debug("PMGui received TrendingStatus message");
            table.updateTableValue((TrendingStatus)s);
        }
        else if (s instanceof MetadataStatus) {
            log.debug("PMGui received MetadataStatus message");
            table.updateTableValue((MetadataStatus)s);
        }
        else if (s instanceof PMStateStatus) {
            log.debug("PMGui received PMStateStatus message");
            table.updateTableValue(((PMStateStatus)s).getPMState());
            controls.updateControlPanel(((PMStateStatus)s).getPMState());
        }
        if (!initialized) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastStateRequest > 2000) {
                lastStateRequest = currentTime;
                ModuleInvokerCommand cmd = new ModuleInvokerCommand("getFullState");
                sendCommand(cmd);
                stateCorrelId = cmd.getCorrelId();
            }
        }
    }

    public void submitLimit(int index, double value, boolean isFLimit, boolean isULimit) {
        Integer arg1 = index;
        Double arg2 = value;
        String command = isFLimit ? (isULimit ? "setUFaultLimit" : "setOFaultLimit") : (isULimit ? "setUWarnLimit" : "setOWarnLimit");
        sendCommand(new ModuleInvokerCommand(command, arg1, arg2));
    }

// xiaowen: will delete together with the GUI objects bound to these methods
//    public void setPowerStatus(boolean enablePower) {
//        Integer arg = enablePower ? 1 : 0;
//        sendCommand(new ModuleInvokerCommand("setPowerEnable", arg));
//    }
//
//    public void setLoadTripStatus(boolean enableLoadTrip) {
//        Integer arg = enableLoadTrip ? 1 : 0;
//        sendCommand(new ModuleInvokerCommand("setLoadTripEnable", arg));
//    }

    public void setTickMillis(int value) {
        sendCommand(new ModuleInvokerCommand("setTickMillis", value));
    }

    public void saveConfiguration() {
        sendCommand(new ModuleInvokerCommand("saveConfiguration"));
    }

    private void sendCommand(ModuleInvokerCommand cmd) {
        cmd.setDestination(powermanage_dest);
        updateCurrentSubsystem();
        fac.sendCommand(cmd);
    }

}
