/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * PMControlPanel.java
 *
 * Created on Jan 25, 2012, 8:40:10 AM
 */
package org.lsst.ccs.subsystems.powermanage.ui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystems.powermanage.data.PMState;

/**
 *
 * @author xiaowen
 */
public class PMControlPanel extends javax.swing.JPanel {

    final static Font f = new java.awt.Font("Tahoma", 1, 12);
    final static Color myRed = new Color(150, 0, 0), myGreen = new Color(0, 150, 0);
    PMGUISubsystem pmGui;
    double currentPeriod = 5;

    /** Creates new form PMControlPanel */
    public PMControlPanel(PMGUISubsystem pmGui) {
        this.pmGui = pmGui;
        initComponents();
        (new UpdatePMStatus(new PMState(0, 0, 0, 0, 0, 0))).run();
        (new DisableSystem()).run();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        stateLabel = new javax.swing.JLabel();
        stateStatus = new javax.swing.JLabel();
        periodLabel = new javax.swing.JLabel();
        periodTextField = new javax.swing.JTextField();
        periodUnitsLabel = new javax.swing.JLabel();
        limitsButton = new javax.swing.JButton();

        stateLabel.setText("System State:");
        stateLabel.setHorizontalTextPosition(javax.swing.SwingConstants.LEADING);

        stateStatus.setText("....");

        periodLabel.setText("Update Period:");

        periodTextField.setText("...");
        periodTextField.setMinimumSize(new java.awt.Dimension(50, 19));
        periodTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                periodTextFieldActionPerformed(evt);
            }
        });

        periodUnitsLabel.setText("sec");

        limitsButton.setText("Save Limits");
        limitsButton.setEnabled(false);
        limitsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                limitsButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addComponent(stateLabel)
                .addGap(6, 6, 6)
                .addComponent(stateStatus))
            .addGroup(layout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addComponent(periodLabel)
                .addGap(12, 12, 12)
                .addComponent(periodTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(4, 4, 4)
                .addComponent(periodUnitsLabel)
                .addGap(135, 135, 135)
                .addComponent(limitsButton))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(12, 12, 12)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(stateLabel)
                    .addComponent(stateStatus))
                .addGap(6, 6, 6)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(6, 6, 6)
                        .addComponent(periodLabel))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(1, 1, 1)
                        .addComponent(periodTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(6, 6, 6)
                        .addComponent(periodUnitsLabel))
                    .addComponent(limitsButton)))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void periodTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_periodTextFieldActionPerformed
        try {
            double value = Double.valueOf(periodTextField.getText());
            pmGui.setTickMillis((int)(1000 * value));
            periodTextField.setEnabled(false);
        }
        catch(NumberFormatException nfe) {
            periodTextField.setText(String.valueOf(currentPeriod));
        }
    }//GEN-LAST:event_periodTextFieldActionPerformed

    private void limitsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_limitsButtonActionPerformed
        pmGui.saveConfiguration();
        limitsButton.setEnabled(false);
    }//GEN-LAST:event_limitsButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton limitsButton;
    private javax.swing.JLabel periodLabel;
    private javax.swing.JTextField periodTextField;
    private javax.swing.JLabel periodUnitsLabel;
    private javax.swing.JLabel stateLabel;
    private javax.swing.JLabel stateStatus;
    // End of variables declaration//GEN-END:variables

    public void updateControlPanel(PMState s) {
        SwingUtilities.invokeLater(new UpdatePMStatus(s));
    }

    public void disableSystem() {
        SwingUtilities.invokeLater(new DisableSystem());
    }

    javax.swing.JButton getLimitsButton() {
        return limitsButton;
    }
    
    class UpdatePMStatus implements Runnable {

        PMState s;

        UpdatePMStatus(PMState s) {
            this.s = s;
        }

        @Override
        public void run() {
            int state = s.getSystemState();

            stateStatus.setText("RUNNING");
            stateStatus.setForeground(myGreen);

            periodTextField.setEnabled(true);
            currentPeriod = s.getTickMillis() / 1000.0;
            periodTextField.setText(String.valueOf(currentPeriod));

            int change = s.getUFLimitChange() | s.getOFLimitChange() | s.getUWLimitChange() | s.getOWLimitChange();
            limitsButton.setEnabled(change != 0);

            repaint();
        }

    }

    class DisableSystem implements Runnable {

        @Override
        public void run() {
            stateStatus.setText("STOPPED");
            stateStatus.setForeground(myRed);
            periodTextField.setEnabled(false);
            limitsButton.setEnabled(false);
        }
 
    }

}
