package org.lsst.ccs.subsystems.powermanage.status;

import org.lsst.ccs.bus.Status;
import org.lsst.ccs.subsystems.powermanage.data.PMState;

/**
 ***************************************************************************
 **
 **  Contains the state of the powermanage system
 **
 **  <p>
 **  Sent on the status bus whenever the state changes
 **
 **  @author Xiaowen Lei
 **
 ***************************************************************************
 */
public class PMStateStatus extends Status {
    
    private PMState pmState;

    public PMStateStatus(PMState pmState)
    {
        super();
        this.pmState = pmState;
    }
    
    public PMState getPMState()
    {
        return pmState;
    }

    @Override
    public String toString()
    {
        return "PMStateStatus(" + origin + ") @" + timeStamp + " : ["
                 + state + "] " + summary + " (" + pmState + ")";
    }

}
