package org.lsst.ccs.subsystems.powermanage.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Contains the state of the powermanage system
 **
 **  @author Xiaowen Lei
 **
 ***************************************************************************
 */
public class PMState implements Serializable 
{
    
    public final static int
        CHANNEL_STATE_MASK   = 0xffff;

    int systemState,        // Mask of good channels
        uFLimitChange,      // Mask of channels with under fault limit changes
        oFLimitChange,      // Mask of channels with over fault limit changes
        uWLimitChange,      // Mask of channels with under fault limit changes
        oWLimitChange,      // Mask of channels with over fault limit changes
        tickMillis;         // Data status update period (ms)
 
    public PMState(int systemState, int uFLimitChange, int oFLimitChange,
                       int uWLimitChange, int oWLimitChange, int tickMillis)
    {
        this.systemState   = systemState;
        this.uFLimitChange = uFLimitChange;
        this.oFLimitChange = oFLimitChange;
        this.uWLimitChange = uWLimitChange;
        this.oWLimitChange = oWLimitChange;
        this.tickMillis    = tickMillis;
    }
    
    public int getSystemState()
    {
        return systemState;
    }

    public int getUFLimitChange()
    {
        return uFLimitChange;
    }

    public int getOFLimitChange()
    {
        return oFLimitChange;
    }

    public int getUWLimitChange()
    {
        return uWLimitChange;
    }

    public int getOWLimitChange()
    {
        return oWLimitChange;
    }

    public int getTickMillis()
    {
        return tickMillis;
    }

    @Override
    public String toString()
    {
        return "systemState=" + toHex(systemState)
                + ", uFLimitChange=" + toHex(uFLimitChange)
                + ", oFLimitChange=" + toHex(oFLimitChange)
                + ", uWLimitChange=" + toHex(uWLimitChange)
                + ", oWLimitChange=" + toHex(oWLimitChange)
                + ", tickMillis=" + tickMillis;
    }

    private String toHex(int value)
    {
        return String.format("0x%x", value);
    }

}
