package org.lsst.ccs.subsystems.powermanage.data;

import java.io.Serializable;
import java.util.ArrayList;

/**
 ***************************************************************************
 **
 **  Contains information describing the full powermanage state
 **
 **  <p>
 **  Sent on the status bus upon startup or upon request.
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class PMFullState implements Serializable {
    
    private ArrayList<PMChannel> channels = new ArrayList<PMChannel>();
    private PMState pmState;

    public void addChannel(PMChannel chan) {
        channels.add(chan);
    }
    
    public ArrayList<PMChannel> getChannelArray() {
        return channels;
    }
    
    public void setPMState(PMState state) {
        pmState = state;
    }

    public PMState getPMState() {
        return pmState;
    }

}
