package org.lsst.ccs.subsystems.powermanage.data;

import java.io.Serializable;

/**
 ***************************************************************************
 **
 **  Contains the description of a powermanage data channel
 **
 **  @author Xiaowen Lei
 **
 ***************************************************************************
 */
public class PMChannel implements Serializable {
    
    private String name, description, units;
    private double uFaultLimit, oFaultLimit, uWarnLimit, oWarnLimit;
    private double value;


    public PMChannel(String name, String description, String units,
                         double uFaultLimit, double oFaultLimit, double uWarnLimit, double oWarnLimit, double value) {
        this.name = name;
        this.description = description;
        this.units = units;
        this.uFaultLimit = uFaultLimit;
        this.oFaultLimit = oFaultLimit;
        this.uWarnLimit = uWarnLimit;
        this.oWarnLimit = oWarnLimit;
        this.value = value;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }

    public void setUFaultLimit(double uFaultLimit) {
        this.uFaultLimit = uFaultLimit;
    }

    public void setOFaultLimit(double oFaultLimit) {
        this.oFaultLimit = oFaultLimit;
    }

    public void setUWarnLimit(double uWarnLimit) {
        this.uWarnLimit = uWarnLimit;
    }

    public void setOWarnLimit(double oWarnLimit) {
        this.oWarnLimit = oWarnLimit;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getDescription() {
        return description;
    }

    public double getUFaultLimit() {
        return uFaultLimit;
    }

    public double getOFaultLimit() {
        return oFaultLimit;
    }

    public double getUWarnLimit() {
        return uWarnLimit;
    }

    public double getOWarnLimit() {
        return oWarnLimit;
    }

    public String getName() {
        return name;
    }

    public String getUnits() {
        return units;
    }

    public double getValue() {
        return value;
    }
    
}
