/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.asn1.util;

import java.io.IOException;
import java.util.Enumeration;
import org.python.bouncycastle.asn1.ASN1ApplicationSpecific;
import org.python.bouncycastle.asn1.ASN1Boolean;
import org.python.bouncycastle.asn1.ASN1Encodable;
import org.python.bouncycastle.asn1.ASN1Enumerated;
import org.python.bouncycastle.asn1.ASN1External;
import org.python.bouncycastle.asn1.ASN1GeneralizedTime;
import org.python.bouncycastle.asn1.ASN1Integer;
import org.python.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.python.bouncycastle.asn1.ASN1OctetString;
import org.python.bouncycastle.asn1.ASN1Primitive;
import org.python.bouncycastle.asn1.ASN1Sequence;
import org.python.bouncycastle.asn1.ASN1Set;
import org.python.bouncycastle.asn1.ASN1TaggedObject;
import org.python.bouncycastle.asn1.ASN1UTCTime;
import org.python.bouncycastle.asn1.BERApplicationSpecific;
import org.python.bouncycastle.asn1.BEROctetString;
import org.python.bouncycastle.asn1.BERSequence;
import org.python.bouncycastle.asn1.BERSet;
import org.python.bouncycastle.asn1.BERTaggedObject;
import org.python.bouncycastle.asn1.DERApplicationSpecific;
import org.python.bouncycastle.asn1.DERBMPString;
import org.python.bouncycastle.asn1.DERBitString;
import org.python.bouncycastle.asn1.DERGraphicString;
import org.python.bouncycastle.asn1.DERIA5String;
import org.python.bouncycastle.asn1.DERNull;
import org.python.bouncycastle.asn1.DERPrintableString;
import org.python.bouncycastle.asn1.DERSequence;
import org.python.bouncycastle.asn1.DERSet;
import org.python.bouncycastle.asn1.DERT61String;
import org.python.bouncycastle.asn1.DERUTF8String;
import org.python.bouncycastle.asn1.DERVideotexString;
import org.python.bouncycastle.asn1.DERVisibleString;
import org.python.bouncycastle.asn1.DLApplicationSpecific;
import org.python.bouncycastle.util.Strings;
import org.python.bouncycastle.util.encoders.Hex;

public class ASN1Dump {
    private static final String TAB = "    ";
    private static final int SAMPLE_SIZE = 32;

    static void _dumpAsString(String string2, boolean bl, ASN1Primitive aSN1Primitive, StringBuffer stringBuffer) {
        String string3 = Strings.lineSeparator();
        if (aSN1Primitive instanceof ASN1Sequence) {
            Enumeration enumeration = ((ASN1Sequence)aSN1Primitive).getObjects();
            String string4 = string2 + TAB;
            stringBuffer.append(string2);
            if (aSN1Primitive instanceof BERSequence) {
                stringBuffer.append("BER Sequence");
            } else if (aSN1Primitive instanceof DERSequence) {
                stringBuffer.append("DER Sequence");
            } else {
                stringBuffer.append("Sequence");
            }
            stringBuffer.append(string3);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null || e.equals(DERNull.INSTANCE)) {
                    stringBuffer.append(string4);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string3);
                    continue;
                }
                if (e instanceof ASN1Primitive) {
                    ASN1Dump._dumpAsString(string4, bl, (ASN1Primitive)e, stringBuffer);
                    continue;
                }
                ASN1Dump._dumpAsString(string4, bl, ((ASN1Encodable)e).toASN1Primitive(), stringBuffer);
            }
        } else if (aSN1Primitive instanceof ASN1TaggedObject) {
            String string5 = string2 + TAB;
            stringBuffer.append(string2);
            if (aSN1Primitive instanceof BERTaggedObject) {
                stringBuffer.append("BER Tagged [");
            } else {
                stringBuffer.append("Tagged [");
            }
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
            stringBuffer.append(Integer.toString(aSN1TaggedObject.getTagNo()));
            stringBuffer.append(']');
            if (!aSN1TaggedObject.isExplicit()) {
                stringBuffer.append(" IMPLICIT ");
            }
            stringBuffer.append(string3);
            if (aSN1TaggedObject.isEmpty()) {
                stringBuffer.append(string5);
                stringBuffer.append("EMPTY");
                stringBuffer.append(string3);
            } else {
                ASN1Dump._dumpAsString(string5, bl, aSN1TaggedObject.getObject(), stringBuffer);
            }
        } else if (aSN1Primitive instanceof ASN1Set) {
            Enumeration enumeration = ((ASN1Set)aSN1Primitive).getObjects();
            String string6 = string2 + TAB;
            stringBuffer.append(string2);
            if (aSN1Primitive instanceof BERSet) {
                stringBuffer.append("BER Set");
            } else if (aSN1Primitive instanceof DERSet) {
                stringBuffer.append("DER Set");
            } else {
                stringBuffer.append("Set");
            }
            stringBuffer.append(string3);
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e == null) {
                    stringBuffer.append(string6);
                    stringBuffer.append("NULL");
                    stringBuffer.append(string3);
                    continue;
                }
                if (e instanceof ASN1Primitive) {
                    ASN1Dump._dumpAsString(string6, bl, (ASN1Primitive)e, stringBuffer);
                    continue;
                }
                ASN1Dump._dumpAsString(string6, bl, ((ASN1Encodable)e).toASN1Primitive(), stringBuffer);
            }
        } else if (aSN1Primitive instanceof ASN1OctetString) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Primitive;
            if (aSN1Primitive instanceof BEROctetString) {
                stringBuffer.append(string2 + "BER Constructed Octet String[" + aSN1OctetString.getOctets().length + "] ");
            } else {
                stringBuffer.append(string2 + "DER Octet String[" + aSN1OctetString.getOctets().length + "] ");
            }
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string2, aSN1OctetString.getOctets()));
            } else {
                stringBuffer.append(string3);
            }
        } else if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
            stringBuffer.append(string2 + "ObjectIdentifier(" + ((ASN1ObjectIdentifier)aSN1Primitive).getId() + ")" + string3);
        } else if (aSN1Primitive instanceof ASN1Boolean) {
            stringBuffer.append(string2 + "Boolean(" + ((ASN1Boolean)aSN1Primitive).isTrue() + ")" + string3);
        } else if (aSN1Primitive instanceof ASN1Integer) {
            stringBuffer.append(string2 + "Integer(" + ((ASN1Integer)aSN1Primitive).getValue() + ")" + string3);
        } else if (aSN1Primitive instanceof DERBitString) {
            DERBitString dERBitString = (DERBitString)aSN1Primitive;
            stringBuffer.append(string2 + "DER Bit String[" + dERBitString.getBytes().length + ", " + dERBitString.getPadBits() + "] ");
            if (bl) {
                stringBuffer.append(ASN1Dump.dumpBinaryDataAsString(string2, dERBitString.getBytes()));
            } else {
                stringBuffer.append(string3);
            }
        } else if (aSN1Primitive instanceof DERIA5String) {
            stringBuffer.append(string2 + "IA5String(" + ((DERIA5String)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERUTF8String) {
            stringBuffer.append(string2 + "UTF8String(" + ((DERUTF8String)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERPrintableString) {
            stringBuffer.append(string2 + "PrintableString(" + ((DERPrintableString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERVisibleString) {
            stringBuffer.append(string2 + "VisibleString(" + ((DERVisibleString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERBMPString) {
            stringBuffer.append(string2 + "BMPString(" + ((DERBMPString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERT61String) {
            stringBuffer.append(string2 + "T61String(" + ((DERT61String)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERGraphicString) {
            stringBuffer.append(string2 + "GraphicString(" + ((DERGraphicString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof DERVideotexString) {
            stringBuffer.append(string2 + "VideotexString(" + ((DERVideotexString)aSN1Primitive).getString() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1UTCTime) {
            stringBuffer.append(string2 + "UTCTime(" + ((ASN1UTCTime)aSN1Primitive).getTime() + ") " + string3);
        } else if (aSN1Primitive instanceof ASN1GeneralizedTime) {
            stringBuffer.append(string2 + "GeneralizedTime(" + ((ASN1GeneralizedTime)aSN1Primitive).getTime() + ") " + string3);
        } else if (aSN1Primitive instanceof BERApplicationSpecific) {
            stringBuffer.append(ASN1Dump.outputApplicationSpecific("BER", string2, bl, aSN1Primitive, string3));
        } else if (aSN1Primitive instanceof DERApplicationSpecific) {
            stringBuffer.append(ASN1Dump.outputApplicationSpecific("DER", string2, bl, aSN1Primitive, string3));
        } else if (aSN1Primitive instanceof DLApplicationSpecific) {
            stringBuffer.append(ASN1Dump.outputApplicationSpecific("", string2, bl, aSN1Primitive, string3));
        } else if (aSN1Primitive instanceof ASN1Enumerated) {
            ASN1Enumerated aSN1Enumerated = (ASN1Enumerated)aSN1Primitive;
            stringBuffer.append(string2 + "DER Enumerated(" + aSN1Enumerated.getValue() + ")" + string3);
        } else if (aSN1Primitive instanceof ASN1External) {
            ASN1External aSN1External = (ASN1External)aSN1Primitive;
            stringBuffer.append(string2 + "External " + string3);
            String string7 = string2 + TAB;
            if (aSN1External.getDirectReference() != null) {
                stringBuffer.append(string7 + "Direct Reference: " + aSN1External.getDirectReference().getId() + string3);
            }
            if (aSN1External.getIndirectReference() != null) {
                stringBuffer.append(string7 + "Indirect Reference: " + aSN1External.getIndirectReference().toString() + string3);
            }
            if (aSN1External.getDataValueDescriptor() != null) {
                ASN1Dump._dumpAsString(string7, bl, aSN1External.getDataValueDescriptor(), stringBuffer);
            }
            stringBuffer.append(string7 + "Encoding: " + aSN1External.getEncoding() + string3);
            ASN1Dump._dumpAsString(string7, bl, aSN1External.getExternalContent(), stringBuffer);
        } else {
            stringBuffer.append(string2 + aSN1Primitive.toString() + string3);
        }
    }

    private static String outputApplicationSpecific(String string2, String string3, boolean bl, ASN1Primitive aSN1Primitive, String string4) {
        ASN1ApplicationSpecific aSN1ApplicationSpecific = ASN1ApplicationSpecific.getInstance(aSN1Primitive);
        StringBuffer stringBuffer = new StringBuffer();
        if (aSN1ApplicationSpecific.isConstructed()) {
            try {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1ApplicationSpecific.getObject(16));
                stringBuffer.append(string3 + string2 + " ApplicationSpecific[" + aSN1ApplicationSpecific.getApplicationTag() + "]" + string4);
                Enumeration enumeration = aSN1Sequence.getObjects();
                while (enumeration.hasMoreElements()) {
                    ASN1Dump._dumpAsString(string3 + TAB, bl, (ASN1Primitive)enumeration.nextElement(), stringBuffer);
                }
            }
            catch (IOException iOException) {
                stringBuffer.append(iOException);
            }
            return stringBuffer.toString();
        }
        return string3 + string2 + " ApplicationSpecific[" + aSN1ApplicationSpecific.getApplicationTag() + "] (" + Strings.fromByteArray(Hex.encode(aSN1ApplicationSpecific.getContents())) + ")" + string4;
    }

    public static String dumpAsString(Object object) {
        return ASN1Dump.dumpAsString(object, false);
    }

    public static String dumpAsString(Object object, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof ASN1Primitive) {
            ASN1Dump._dumpAsString("", bl, (ASN1Primitive)object, stringBuffer);
        } else if (object instanceof ASN1Encodable) {
            ASN1Dump._dumpAsString("", bl, ((ASN1Encodable)object).toASN1Primitive(), stringBuffer);
        } else {
            return "unknown object type " + object.toString();
        }
        return stringBuffer.toString();
    }

    private static String dumpBinaryDataAsString(String string2, byte[] byArray) {
        String string3 = Strings.lineSeparator();
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string2 + TAB;
        stringBuffer.append(string3);
        for (int i = 0; i < byArray.length; i += 32) {
            if (byArray.length - i > 32) {
                stringBuffer.append(string2);
                stringBuffer.append(Strings.fromByteArray(Hex.encode(byArray, i, 32)));
                stringBuffer.append(TAB);
                stringBuffer.append(ASN1Dump.calculateAscString(byArray, i, 32));
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string2);
            stringBuffer.append(Strings.fromByteArray(Hex.encode(byArray, i, byArray.length - i)));
            for (int j = byArray.length - i; j != 32; ++j) {
                stringBuffer.append("  ");
            }
            stringBuffer.append(TAB);
            stringBuffer.append(ASN1Dump.calculateAscString(byArray, i, byArray.length - i));
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private static String calculateAscString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i != n + n2; ++i) {
            if (byArray[i] < 32 || byArray[i] > 126) continue;
            stringBuffer.append((char)byArray[i]);
        }
        return stringBuffer.toString();
    }
}

