/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.command.Options;
import org.lsst.ccs.command.SupportedOption;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Option;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.subsystem.common.actions.BulkPsPowerAction;
import org.lsst.ccs.subsystem.common.focalplane.data.HasFocalPlaneData;
import org.lsst.ccs.subsystem.power.CornerRaftRebPowerSupplyNode;
import org.lsst.ccs.subsystem.power.EmergencyResponseManager;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.RebPowerSupplyNode;
import org.lsst.ccs.subsystem.power.RebPsDevice;
import org.lsst.ccs.subsystem.power.RebPsHVRegulator;
import org.lsst.ccs.subsystem.power.data.PowerDataGroup;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.states.PowerSupplyState;
import org.lsst.ccs.subsystem.power.states.RebDPhiState;
import org.lsst.ccs.subsystem.power.states.RebHvBiasState;
import org.lsst.ccs.subsystem.power.states.RebHvControlState;
import org.lsst.ccs.subsystem.power.states.RebPowerState;

public class RebPowerSupplyMain
extends Subsystem
implements HasLifecycle,
HasDataProviderInfos {
    private static final Logger LOG = Logger.getLogger(RebPowerSupplyMain.class.getName());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<PowerDevice> mainPsList = new ArrayList<PowerDevice>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<RebPsDevice> psDeviceList = new ArrayList<RebPsDevice>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private RebPsHVRegulator RebPsHvRegulator;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private EmergencyResponseManager emergencyResponseManager;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, RebPowerSupplyNode> rebs = new HashMap<String, RebPowerSupplyNode>();
    @ConfigurationParameter(units="ms", description="During the powerOffAllRebs command this is the sleep time between each node being powered off.")
    private volatile long powerOffSleepMillis = 100L;
    @ConfigurationParameter(name="psDeviceReadTimeout", description="Read Timeout for the underlying PS driver", units="ms")
    private volatile long psDeviceReadTimeout = 1000L;
    @ConfigurationParameter(category="General", description="Number of consecutive read failures (exceptions) before gonig Offline. Must be a positive number greater than zero.", range="1..5", units="unitless")
    private volatile int psDeviceExcepNumToOffline = 1;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    private final SupportedOption dryRunOption = SupportedOption.getSupportedOption((String)"dryRun");

    public RebPowerSupplyMain() {
        super("rebps", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        if (this.emergencyResponseManager == null) {
            throw new RuntimeException("Cannot operate the RebPower subsystem without an EmergencyResponseManager");
        }
        this.agentPropertiesService.setAgentProperty(BulkPsPowerAction.class.getCanonicalName(), "uses");
        this.agentPropertiesService.setAgentProperty("agentCategory", AgentCategory.POWER.name());
        this.agentPropertiesService.setAgentProperty(HasFocalPlaneData.AGENT_PROPERTY, HasFocalPlaneData.generatePropertyValue(PowerDataGroup.class));
    }

    public void init() {
        for (RebPowerSupplyNode reb : this.rebs.values()) {
            this.agentStateService.registerState(RebPowerState.class, "REB power state", (Object)reb);
            this.agentStateService.registerState(RebHvControlState.class, "REB HV control permit", (Object)reb);
            this.agentStateService.registerState(RebHvBiasState.class, "REB HV bias state", (Object)reb);
            if (!(reb instanceof CornerRaftRebPowerSupplyNode)) continue;
            this.agentStateService.registerState(RebDPhiState.class, "REB Dphi state", (Object)reb);
        }
        for (RebPsDevice powerSupplyDevice : this.psDeviceList) {
            this.agentStateService.registerState(PowerSupplyState.class, "Power Supply state", (Object)powerSupplyDevice);
        }
        this.setPsDeviceReadTimeout(this.psDeviceReadTimeout);
        this.setPsDeviceConsecutiveExceptionsToOffline(this.psDeviceExcepNumToOffline);
    }

    @ConfigurationParameterChanger(propertyName="psDeviceExcepNumToOffline")
    public void setPsDeviceConsecutiveExceptionsToOffline(int value) {
        this.psDeviceExcepNumToOffline = value;
        for (RebPsDevice powerSupplyDevice : this.psDeviceList) {
            powerSupplyDevice.setConsecutiveExceptiionsToOffline(this.psDeviceExcepNumToOffline);
        }
    }

    @ConfigurationParameterChanger(propertyName="psDeviceReadTimeout")
    public void setPsDeviceReadTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Negative timeouts are not allowd");
        }
        this.psDeviceReadTimeout = timeout;
        for (RebPsDevice powerSupplyDevice : this.psDeviceList) {
            powerSupplyDevice.setReadTimeout(this.psDeviceReadTimeout);
        }
    }

    public void finalizeDictionary() {
        for (DataProviderInfo data : this.dictionaryService.getDataProviderDictionary().getDataProviderInfos()) {
            PowerDataGroup dataGroup = PowerDataGroup.findPowerDataGroup(data);
            if (dataGroup == null) continue;
            dataGroup.addAttributesToDataInfo(data);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set whether REB HV Control is active")
    public void enableHvControl(boolean on) {
        this.RebPsHvRegulator.enableHvControl(on);
    }

    @Command(type=Command.CommandType.QUERY, description="returns whether REB HV Control is active")
    public boolean isHvControlActive() {
        return this.RebPsHvRegulator.isHvControlActive();
    }

    @Command(description="Emergency power off of all rebs at ~10/s")
    public void powerOffAllRebs() throws InterruptedException {
        Object failedRebs = "";
        int count = this.rebs.size();
        for (RebPowerSupplyNode node : this.rebs.values()) {
            --count;
            if (!this.agentStateService.isComponentInState(node.rebPath, (Enum)RebPowerState.ON)) continue;
            LOG.log(Level.INFO, "Powering off reb: {0}", new Object[]{node.rebPath});
            try {
                node.powerRebOff();
            }
            catch (PowerException ex) {
                LOG.log(Level.WARNING, "Failed to power off reb: " + node.rebPath, ex);
                failedRebs = (String)failedRebs + node.rebPath + " ";
            }
            if (count <= 0) continue;
            Thread.sleep(this.powerOffSleepMillis);
        }
        if (!((String)failedRebs).isEmpty()) {
            throw new RuntimeException("Failed to turn off the following rebs: " + ((String)failedRebs).trim());
        }
    }

    @Command(description="Open and disable all RebPS hvbias switches with no delay")
    public void setAllHvBiasToZero() {
        this.RebPsHvRegulator.enableHvControl(false);
        Object failedRebs = "";
        for (RebPowerSupplyNode node : this.rebs.values()) {
            LOG.log(Level.INFO, "Opening HvBias switch for node: {0}", new Object[]{node.rebPath});
            try {
                node.hvBiasOff(true);
            }
            catch (PowerException ex) {
                LOG.log(Level.WARNING, "Failed to open HvBias switch for node: " + node.rebPath, ex);
                failedRebs = (String)failedRebs + node.rebPath + " ";
            }
        }
        if (!((String)failedRebs).isEmpty()) {
            throw new RuntimeException("Failed to open HvBias switch for rebs: " + ((String)failedRebs).trim());
        }
    }

    @Option(name="dryRun", description="If true, no action occurs on the Rebs")
    @Command(description="Power On matching Rebs", type=Command.CommandType.ACTION, level=2, autoAck=false)
    public void powerOnRebs(Options options, @Argument(description="Regular expression to match the rebs by path.") String regEx, @Argument(description="Number of seconds to wait between rebs [2:30]") double delay) {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean dryRun = options.hasOption(this.dryRunOption);
        ArrayList<String> rebsToTurnOn = new ArrayList<String>();
        ArrayList<String> rebsAlreadyOn = new ArrayList<String>();
        HashMap<String, RebPowerState> otherStatesRebs = new HashMap<String, RebPowerState>();
        for (RebPowerSupplyNode node : this.rebs.values()) {
            String rebPath = node.rebPath;
            if (!rebPattern.matcher(rebPath).matches()) continue;
            RebPowerState rebState = (RebPowerState)this.agentStateService.getComponentState(rebPath, RebPowerState.class);
            if (rebState == RebPowerState.OFF) {
                rebsToTurnOn.add(rebPath);
                continue;
            }
            if (rebState == RebPowerState.ON) {
                rebsAlreadyOn.add(rebPath);
                continue;
            }
            otherStatesRebs.put(rebPath, rebState);
        }
        double rebPowerOnSeconds = 2.5;
        Duration duration = rebsToTurnOn.isEmpty() ? Duration.ofSeconds(1L) : Duration.ofSeconds((long)(1.3 * ((double)rebsToTurnOn.size() * rebPowerOnSeconds + (double)(rebsToTurnOn.size() - 1) * delay)));
        this.helper().precondition(delay >= 2.0 && delay <= 30.0, "Power on delay must be in range [2:30] seconds", new Supplier[0]).precondition(otherStatesRebs.isEmpty(), "Bad RebPowerState detected for the rebs: " + otherStatesRebs, new Supplier[0]).duration(duration).action(() -> {
            if (!rebsAlreadyOn.isEmpty()) {
                LOG.log(Level.INFO, "Skipping Rebs already on: {0}", rebsAlreadyOn);
            }
            if (rebsToTurnOn.isEmpty()) {
                LOG.log(Level.INFO, "There are no Rebs matching {0}", rebPattern);
                return;
            }
            LOG.log(Level.INFO, "Turning on Rebs:\n  {0}\nUsing a {1}s pause.\nDry Run = {2}", new Object[]{rebsToTurnOn, delay, dryRun});
            int count = 0;
            for (String rebPath : rebsToTurnOn) {
                ++count;
                RebPowerSupplyNode node = this.rebs.get(rebPath);
                LOG.log(Level.INFO, "Invoking powerRebOn on Reb: {0}", rebPath);
                if (!dryRun) {
                    node.powerRebOn();
                }
                if (count == rebsToTurnOn.size()) continue;
                LOG.log(Level.INFO, "Sleep for {0} seconds", delay);
                if (dryRun) continue;
                try {
                    Thread.sleep((long)(delay * 1000.0));
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    @Option(name="dryRun", description="If true, no action occurs on the Rebs")
    @Command(description="Power Off matching Rebs", type=Command.CommandType.ACTION, level=1, autoAck=false)
    public void powerOffRebs(Options options, @Argument(description="Regular expression to match the rebs by path.") String regEx, @Argument(description="Number of seconds to wait between rebs [0.5:5]") double delay) {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean dryRun = options.hasOption(this.dryRunOption);
        ArrayList<String> rebsToTurnOff = new ArrayList<String>();
        ArrayList<String> rebsAlreadyOff = new ArrayList<String>();
        HashMap<String, RebPowerState> otherStatesRebs = new HashMap<String, RebPowerState>();
        for (RebPowerSupplyNode node : this.rebs.values()) {
            String rebPath = node.rebPath;
            if (!rebPattern.matcher(rebPath).matches()) continue;
            RebPowerState rebState = (RebPowerState)this.agentStateService.getComponentState(rebPath, RebPowerState.class);
            if (rebState == RebPowerState.ON) {
                rebsToTurnOff.add(rebPath);
                continue;
            }
            if (rebState == RebPowerState.OFF) {
                rebsAlreadyOff.add(rebPath);
                continue;
            }
            otherStatesRebs.put(rebPath, rebState);
        }
        double rebPowerOffSeconds = 0.1;
        Duration duration = rebsToTurnOff.isEmpty() ? Duration.ofSeconds(1L) : Duration.ofSeconds((long)(1.3 * ((double)rebsToTurnOff.size() * rebPowerOffSeconds + (double)(rebsToTurnOff.size() - 1) * delay)));
        this.helper().precondition(delay >= 0.5 && delay <= 5.0, "Power off delay must be in range [0.5:5] seconds", new Supplier[0]).duration(duration).action(() -> {
            if (!otherStatesRebs.isEmpty()) {
                LOG.log(Level.WARNING, "Inconsistent RebPowerState detected for reb nodes: {0}", otherStatesRebs);
            }
            if (!rebsAlreadyOff.isEmpty()) {
                LOG.log(Level.INFO, "Skipping Rebs already off {0}", rebsAlreadyOff);
            }
            if (rebsToTurnOff.isEmpty()) {
                LOG.log(Level.INFO, "There are no matching Rebs to power off for {0}", rebPattern);
                return;
            }
            LOG.log(Level.INFO, "Turning off Rebs:\n  {0}\nUsing a {1}s pause.\nDry Run = {2}", new Object[]{rebsToTurnOff, delay, dryRun});
            int count = 0;
            for (String rebPath : rebsToTurnOff) {
                ++count;
                RebPowerSupplyNode node = this.rebs.get(rebPath);
                LOG.log(Level.INFO, "Invoking powerRebOff on Reb: {0}", rebPath);
                if (!dryRun) {
                    node.powerRebOff();
                }
                if (count == rebsToTurnOff.size()) continue;
                LOG.log(Level.INFO, "Sleep for {0} seconds", delay);
                if (dryRun) continue;
                try {
                    Thread.sleep((long)(delay * 1000.0));
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    @Option(name="dryRun", description="If true, no action occurs on the Rebs")
    @Command(description="Close the HvBias switch on matching rebs", type=Command.CommandType.ACTION, level=2, autoAck=false)
    public void closeHvBiasSwitches(Options options, @Argument(description="Regular expression to match rebs") String regEx, @Argument(description="Number of seconds to wait between rebs [0.3:5]") double delay) {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean dryRun = options.hasOption(this.dryRunOption);
        ArrayList<String> rebsToClose = new ArrayList<String>();
        ArrayList<String> rebsAlreadyClosed = new ArrayList<String>();
        HashMap<String, RebHvBiasState> otherStatesRebs = new HashMap<String, RebHvBiasState>();
        for (RebPowerSupplyNode node : this.rebs.values()) {
            String rebPath = node.rebPath;
            if (!rebPattern.matcher(rebPath).matches()) continue;
            RebHvBiasState rebState = (RebHvBiasState)this.agentStateService.getComponentState(rebPath, RebHvBiasState.class);
            if (rebState == RebHvBiasState.OFF) {
                rebsToClose.add(rebPath);
                continue;
            }
            if (rebState == RebHvBiasState.ON) {
                rebsAlreadyClosed.add(rebPath);
                continue;
            }
            otherStatesRebs.put(rebPath, rebState);
        }
        double rebHvBiasSwitchCloseSeconds = 0.1;
        Duration duration = rebsToClose.isEmpty() ? Duration.ofSeconds(1L) : Duration.ofSeconds((long)(1.3 * ((double)rebsToClose.size() * rebHvBiasSwitchCloseSeconds + (double)(rebsToClose.size() - 1) * delay)));
        this.helper().precondition(delay >= 0.3 && delay <= 5.0, "Delay must be in range [0.3:5] seconds", new Supplier[0]).precondition(otherStatesRebs.isEmpty(), "Bad RebHvBiasState detected for: " + otherStatesRebs, new Supplier[0]).duration(duration).action(() -> {
            if (!rebsAlreadyClosed.isEmpty()) {
                LOG.log(Level.INFO, "Skipping Rebs already closed: {0}", rebsAlreadyClosed);
            }
            if (rebsToClose.isEmpty()) {
                LOG.log(Level.INFO, "There are no Rebs matching {0}", rebPattern);
                return;
            }
            LOG.log(Level.INFO, "Closing the HvBias switch on:\n  {0} with {1}s pause.\nDryRun:{2}\n", new Object[]{rebsToClose, delay, dryRun});
            int count = 0;
            for (String rebPath : rebsToClose) {
                ++count;
                RebPowerSupplyNode node = this.rebs.get(rebPath);
                LOG.log(Level.INFO, "Invoking hvBiasOn() on Reb: {0}", rebPath);
                if (!dryRun) {
                    node.hvBiasOn();
                }
                if (count == rebsToClose.size()) continue;
                LOG.log(Level.INFO, "Sleep for {0} seconds", delay);
                if (dryRun) continue;
                try {
                    Thread.sleep((long)(delay * 1000.0));
                }
                catch (InterruptedException interruptedException) {}
            }
        });
    }

    @Option(name="dryRun", description="If true, no action occurs on the Rebs")
    @Command(description="Open hv switch, set volts=0 and block control on a specified set of Rebs", type=Command.CommandType.ACTION, level=1, autoAck=false)
    public void setHvBiasToZero(Options options, @Argument(description="Regular expression to match rebs") String regEx) {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean dryRun = options.hasOption(this.dryRunOption);
        long delay = 10L;
        for (RebPowerSupplyNode node : this.rebs.values()) {
            String rebPath = node.rebPath;
            if (!rebPattern.matcher(rebPath).matches()) continue;
            if (!dryRun) {
                try {
                    node.hvBiasOff();
                    node.allowHvControl(false);
                    node.setHvBiasDac(0);
                }
                catch (PowerException pe) {
                    LOG.log(Level.SEVERE, "Could not turn HvBias OFF for reb " + rebPath, pe);
                }
            }
            LOG.log(Level.INFO, String.format("%sinvoked setHvBiasToZero on Reb: %s", dryRun ? "would have " : "", rebPath));
            if (dryRun) continue;
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Option(name="dryRun", description="If true, no action occurs on the Rebs")
    @Command(description="Open and (re-)enable the HvBias switch on a specified set of Rebs", type=Command.CommandType.ACTION, level=1, autoAck=false)
    public void openHvBiasSwitches(Options options, @Argument(description="Regular expression to match rebs") String regEx) {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean dryRun = options.hasOption(this.dryRunOption);
        long delay = 10L;
        for (RebPowerSupplyNode node : this.rebs.values()) {
            String rebPath = node.rebPath;
            if (!rebPattern.matcher(rebPath).matches()) continue;
            if (!dryRun) {
                try {
                    node.hvBiasOff();
                }
                catch (PowerException pe) {
                    LOG.log(Level.SEVERE, "Could not turn HvBias OFF for reb " + rebPath, pe);
                }
            }
            LOG.log(Level.INFO, String.format("%sinvoked hvBiasOff on Reb: %s", dryRun ? "would have " : "", rebPath));
            if (dryRun) continue;
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Option(name="dryRun", description="If true, no action occurs on the Rebs")
    @Command(description="Set allowHvControl(true|false) on matching Rebs", type=Command.CommandType.ACTION, level=2, autoAck=false)
    public void allowHvControl(Options options, @Argument(description="Regular expression to match rebs") String regEx, @Argument(description="true|false to allow|disallow HvControl") boolean allow) {
        Pattern rebPattern = Pattern.compile(regEx);
        boolean dryRun = options.hasOption(this.dryRunOption);
        int count = 0;
        ArrayList<String> rebsToCommand = new ArrayList<String>();
        for (RebPowerSupplyNode node : this.rebs.values()) {
            String rebPath = node.rebPath;
            if (!rebPattern.matcher(rebPath).matches()) continue;
            rebsToCommand.add(rebPath);
            ++count;
            if (dryRun) continue;
            node.allowHvControl(allow);
            LOG.log(Level.FINE, "Invoking allowHvControl({0}) on Reb: {1}", new Object[]{allow, rebPath});
        }
        LOG.log(Level.INFO, String.format("allowHvControl() %s called on %d Rebs", dryRun ? "would have been (DRYRUN) " : "", count));
        LOG.log(Level.FINE, "Rebs matched: {0}\n", new Object[]{rebsToCommand});
    }
}

