/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.drivers.auxelex.Bfr;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.power.SwitchControl;

public class BfrDevice
extends Device
implements SwitchControl {
    private static final Logger LOG = Logger.getLogger(BfrDevice.class.getName());
    private static final double MIN_SPECIAL_VALUE = 327.52;
    private static final double LINE_VOLTAGE = 220.0;
    private static final String NODE = "node";
    private static final int TYPE_CURRENT = 0;
    private static final int TYPE_POWER = 1;
    @ConfigurationParameter(name="node", category="Quadbox", isFinal=true, units="unitless", description="The node board id")
    private volatile Integer node;
    private final Bfr bfr = new Bfr();
    private double[] currents = null;
    private double totalPower = 0.0;
    private boolean initError = false;

    protected void initDevice() {
        if (this.node == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)NODE, (String)"is missing");
        }
        this.fullName = "BFR board (" + this.node + ")";
    }

    public void initialize() {
        block2: {
            try {
                this.bfr.open(this.node.intValue());
                this.initSensors();
                LOG.log(Level.INFO, "Connected to {0}", this.fullName);
                this.initError = false;
                this.setOnline(true);
            }
            catch (DriverException e) {
                if (this.initError) break block2;
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.fullName, e});
                this.initError = true;
            }
        }
    }

    protected void close() {
        try {
            this.bfr.close();
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error disconnecting from {0}:{1}", new Object[]{this.fullName, e});
        }
    }

    protected int[] checkChannel(Channel ch) throws Exception {
        int[] types = new int[]{0, 0};
        String typeStr = ch.getTypeStr();
        switch (typeStr.toUpperCase()) {
            case "CURRENT": {
                types[0] = 0;
                break;
            }
            case "POWER": {
                types[0] = 1;
                break;
            }
            default: {
                ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"channel type", (Object)typeStr);
            }
        }
        int hwChan = ch.getHwChan();
        if (hwChan < 0 || hwChan >= 11) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)ch.getPath(), (String)"hw channel number", (Object)hwChan);
        }
        return types;
    }

    protected String getGroupForChannel(Channel ch) {
        return "currents";
    }

    protected void readChannelGroup(String group) {
        this.currents = null;
        this.totalPower = 0.0;
        if (this.isOnline()) {
            try {
                this.currents = this.bfr.readCurrent(Bfr.CurrentType.AC);
                for (int j = 0; j < this.currents.length; ++j) {
                    if (this.currents[j] >= 327.52) {
                        this.currents[j] = Double.NaN;
                        continue;
                    }
                    this.totalPower += this.currents[j];
                }
                this.totalPower *= 220.0;
            }
            catch (DriverException e) {
                LOG.log(Level.SEVERE, "Error reading {0} currents: {1}", new Object[]{this.fullName, e});
                this.setOnline(false);
            }
        }
    }

    protected double readChannel(Channel ch) {
        if (ch.getType() == 0) {
            return this.currents == null ? Double.NaN : this.currents[ch.getHwChan()];
        }
        return this.totalPower;
    }

    @Override
    public int getSwitchDevice() {
        return 0;
    }

    @Override
    public void switchOn(int relay) {
        try {
            this.bfr.setRelayOn(relay);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error setting relay {0} on {1}: {2}", new Object[]{relay, this.fullName, e});
        }
    }

    @Override
    public void switchOff(int relay) {
        try {
            this.bfr.setRelayOff(relay);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error setting relay {0} on {1}: {2}", new Object[]{relay, this.fullName, e});
        }
    }

    @Override
    public Boolean isSwitchOn(int relay) {
        if (!this.isOnline() || relay < 0) {
            return null;
        }
        try {
            return this.bfr.isRelayOn(relay);
        }
        catch (DriverException e) {
            LOG.log(Level.SEVERE, "Error getting state for relay {0} on {1}: {2}", new Object[]{relay, this.fullName, e});
            return null;
        }
    }
}

