/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.power.RebPowerSupplyNode;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.states.HvControlState;
import org.lsst.ccs.subsystem.power.states.RebHvControlState;
import org.lsst.ccs.subsystem.power.states.RebPowerState;

public class RebPsHVRegulator
implements HasLifecycle {
    @LookupPath
    String HvControllerPath;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    private static final Logger LOG = Logger.getLogger(RebPsHVRegulator.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Map<String, RebPowerSupplyNode> rebPowers = new HashMap<String, RebPowerSupplyNode>();
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="(R\\d\\d)/(Reb\\d|Reb[WG])/hvbias/(DAC|[VI]befSwch)")
    private static final Map<String, Channel> rebPowerHvChannelsMap = new HashMap<String, Channel>();
    @ConfigurationParameter(name="minUpdateDelay", category="HVRegulation", units="ms", description="minimum time required before next update")
    protected volatile int minUpdateDelay = 20000;
    @ConfigurationParameter(name="staleMillis", category="HVRegulation", units="ms", description="max time for data freshness in V/step calc")
    protected volatile int staleMillis = 120000;
    @ConfigurationParameter(name="deltaI", category="HVRegulation", units="unitless", description="allowed fractional excess current")
    protected volatile double deltaI = 0.02;
    @ConfigurationParameter(name="maxDeltaVolt", category="HVRegulation", units="Volt", description="maximum voltage step per update")
    protected volatile double maxDeltaVolt = 2.5;
    int maxStep0 = 70;
    double minSetPoint = 20.0;
    private static final Map<String, RebHvBiasInfo> hvBiasInfoMap = new HashMap<String, RebHvBiasInfo>();
    private long loopDelay = 50L;
    private double voltsMax = 52.1;
    private double voltsMin = 20.0;
    private final int dacMaxAllowed = 3200;
    private double currentLimit = 0.115;
    private long updateHvMillis = 10000L;
    private final Object rebInfoLock = new Object();
    List<String> allrebs = new ArrayList<String>(hvBiasInfoMap.keySet());

    @Command(description="Print rebInfo values for a REB", type=Command.CommandType.QUERY)
    public String getRebInfo(@Argument(description="") String rebPath) {
        return String.format("REB: %s\n %s", rebPath, hvBiasInfoMap.get(rebPath));
    }

    void setupRebStates() {
        for (Map.Entry<String, RebPowerSupplyNode> rebNode : this.rebPowers.entrySet()) {
            String rebPath = rebNode.getKey();
            LOG.log(Level.INFO, String.format("rebPath: %s", rebPath));
            this.allrebs.add(rebPath);
            hvBiasInfoMap.put(rebPath, new RebHvBiasInfo(rebNode.getValue(), rebPowerHvChannelsMap.get(rebPath + "/hvbias/VbefSwch"), rebPowerHvChannelsMap.get(rebPath + "/hvbias/IbefSwch"), rebPowerHvChannelsMap.get(rebPath + "/hvbias/DAC")));
        }
        Collections.shuffle(this.allrebs);
    }

    public void build() {
        LOG.log(Level.INFO, String.format("The length of rebPowerHvChannelsMap is %d", rebPowerHvChannelsMap.size()));
        this.setupRebStates();
        AgentPeriodicTask hvControlTask = new AgentPeriodicTask("reb-hv-update", () -> this.updateRebHvSettings()).withPeriod(Duration.ofMillis(this.updateHvMillis));
        this.periodicTaskService.scheduleAgentPeriodicTask(hvControlTask);
    }

    public void init() {
        LOG.log(Level.INFO, String.format("HV Bias Control initalizing for  %d REBs", this.allrebs.size()));
        this.agentStateService.registerState(HvControlState.class, "Hv Control state", (Object)this);
        this.enableHvControl(false);
    }

    protected void enableHvControl(boolean on) {
        this.agentStateService.updateAgentComponentState((Object)this, new Enum[]{on ? HvControlState.ACTIVE : HvControlState.IDLE});
    }

    protected boolean isHvControlActive() {
        return this.agentStateService.isComponentInState(this.HvControllerPath, (Enum)HvControlState.ACTIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateRebHvSettings() {
        long t0 = System.currentTimeMillis();
        int changes = 0;
        long hvControlPeriod = this.periodicTaskService.getPeriodicTaskPeriod("reb-hv-update").toMillis();
        if (!this.isHvControlActive()) {
            return;
        }
        LOG.log(Level.FINE, () -> String.format("hvControlPeriod = %d", hvControlPeriod));
        this.loopDelay = Math.max(40L, (hvControlPeriod - 1000L) / (long)this.allrebs.size());
        for (String reb : this.allrebs) {
            LOG.log(Level.FINEST, () -> String.format("Updating %s", reb));
            RebHvBiasInfo rebInfo = hvBiasInfoMap.get(reb);
            RebPowerSupplyNode rebNode = (RebPowerSupplyNode)rebInfo.target;
            if (this.agentStateService.isComponentInState(reb, (Enum)RebPowerState.ON) && this.agentStateService.isComponentInState(reb, (Enum)RebHvControlState.ALLOWED) && System.currentTimeMillis() - rebInfo.lastMillis > (long)this.minUpdateDelay) {
                Object object = rebInfo.getUpdateLock();
                synchronized (object) {
                    rebInfo.setpt = rebNode.getHvBiasSetPoint();
                    rebInfo.maxDac = rebNode.getMaxDac();
                    rebInfo.firstDac = rebNode.getFirstDac();
                    rebInfo.reff = rebNode.getReff();
                    rebInfo.voltsPerStepCal = rebNode.getVoltsPerStepCal();
                    rebInfo.useVoltsPerStepCal = rebNode.getUseVoltsPerStepCal();
                    rebInfo.dac = (int)rebInfo.chDac.getValue();
                    if (rebInfo.dac == 0) {
                        rebInfo.voltsPerStep = 0.1;
                    }
                    rebInfo.volts = rebInfo.chVbefSwch.getValue();
                    if (rebInfo.volts < 0.0 || rebInfo.volts > this.voltsMax) {
                        LOG.log(Level.SEVERE, () -> String.format("%s hvbias getValue():%s is out of allowed range: 0--%f", reb, rebInfo.volts, this.voltsMax));
                    }
                    rebInfo.current = rebInfo.chIbefSwch.getValue();
                    if (rebInfo.current < 0.0 || rebInfo.current > this.currentLimit) {
                        LOG.log(Level.SEVERE, () -> String.format("%s hvbias current:%s out of allowed range: 0--%f", reb, rebInfo.current, this.currentLimit));
                    }
                    LOG.log(Level.FINE, () -> String.format("%s latest values: dac: %d  volts: %6.3f current: %.3f (mA)", reb, rebInfo.dac, rebInfo.volts, rebInfo.current));
                    double deltaDac = rebInfo.dac - rebInfo.lastDac;
                    if (deltaDac != 0.0 && System.currentTimeMillis() - rebInfo.lastMillis < (long)this.staleMillis) {
                        double deltaVolts = rebInfo.volts - rebInfo.lastVolts;
                        double deltaCurrent = rebInfo.current - rebInfo.lastCurrent;
                        double oldVal = rebInfo.voltsPerStep;
                        double newVal = deltaVolts / deltaDac;
                        if (newVal > 0.025) {
                            rebInfo.voltsPerStep = (2.0 * oldVal + newVal) / 3.0;
                            rebInfo.lastDac = rebInfo.dac;
                            LOG.log(Level.INFO, () -> String.format("%s: Update running voltsPerStep: (%.3f,%.3f) --> %.3f", reb, oldVal, newVal, rebInfo.voltsPerStep));
                        } else if (deltaVolts < -0.1 && deltaCurrent > 0.005) {
                            LOG.log(Level.WARNING, () -> String.format("%s V/step: %.3f, dI: %.3f, dV: %.3f overlight condition?", reb, newVal, deltaCurrent, deltaVolts));
                        }
                    } else {
                        rebInfo.lastDac = rebInfo.dac;
                    }
                    int newDac = 0;
                    if (rebInfo.setpt > this.minSetPoint) {
                        int steps = 0;
                        int maxStep = (int)((double)this.maxStep0 - 1.1 * rebInfo.volts);
                        if (maxStep < 0) {
                            maxStep = 0;
                        }
                        maxStep = Math.min(maxStep, (int)(this.maxDeltaVolt / rebInfo.voltsPerStep));
                        steps = !rebInfo.useVoltsPerStepCal || Math.abs(rebInfo.setpt - rebInfo.volts) > 2.0 ? Math.min(maxStep, (int)Math.round((rebInfo.setpt - rebInfo.volts) / rebInfo.voltsPerStep)) : Math.min(maxStep, (int)Math.round((rebInfo.setpt - rebInfo.volts) / rebInfo.voltsPerStepCal));
                        if (steps != 0) {
                            LOG.log(Level.FINE, String.format("%s: using %d DAC steps of %d maximum", reb, steps, maxStep));
                        }
                        newDac = rebInfo.dac + steps;
                        newDac = Math.max(newDac, 0);
                        if ((newDac = Math.min(newDac, rebInfo.maxDac)) > 0 && newDac < rebInfo.firstDac) {
                            newDac = rebInfo.firstDac;
                            LOG.log(Level.INFO, () -> String.format("%s: start ramp up from Dac: %d", reb, rebInfo.firstDac));
                        } else {
                            LOG.log(Level.FINE, String.format("%s: using %d DAC steps of %d maximum", reb, newDac - rebInfo.dac, maxStep));
                        }
                    } else {
                        if (rebInfo.setpt > 0.0) {
                            LOG.log(Level.WARNING, () -> String.format("%s: setpt(%.3f) < minSetPoint(%.3f), using 0", reb, rebInfo.setpt, this.minSetPoint));
                        }
                        newDac = 0;
                    }
                    if (newDac != rebInfo.dac) {
                        double currentMax = (1.0 + this.deltaI) * (rebInfo.setpt + rebInfo.volts) / 2.0 / rebInfo.reff;
                        if (newDac > rebInfo.dac && rebInfo.current > currentMax) {
                            LOG.log(Level.WARNING, () -> String.format("Skipping update on %s, current: %.3f > %.3f mA limit", reb, rebInfo.current, currentMax));
                        } else {
                            try {
                                LOG.log(Level.FINE, String.format("%s hvBias DAC changing from %d to %d", reb, rebInfo.dac, newDac));
                                rebNode.setHvBiasDac(newDac, true);
                                ++changes;
                                if (newDac > 0) {
                                    rebInfo.lastDac = rebInfo.dac;
                                    rebInfo.dac = newDac;
                                    rebInfo.lastVolts = rebInfo.volts;
                                    rebInfo.lastCurrent = rebInfo.current;
                                } else {
                                    rebInfo.lastDac = 0;
                                    rebInfo.dac = 0;
                                    rebInfo.lastVolts = 0.0;
                                    rebInfo.lastCurrent = 0.0;
                                }
                                rebInfo.lastMillis = System.currentTimeMillis();
                            }
                            catch (PowerException ex) {
                                LOG.log(Level.SEVERE, "Failed to set HV bias dac: " + ex);
                            }
                        }
                    }
                }
            }
            LOG.log(Level.FINEST, () -> String.format("Skipping %s: OFF|BLOCKED|tooEarly", reb));
            try {
                Thread.sleep(this.loopDelay);
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, "Sleep interrupted");
            }
        }
        long t1 = System.currentTimeMillis();
        long deltaTime = t1 - t0;
        if (changes > 0) {
            LOG.log(Level.FINE, String.format("loopTime=%f changeCount=%d loopDelay=%d", (double)deltaTime / 1000.0, changes, this.loopDelay));
        }
    }

    private class RebHvBiasInfo {
        private final Object target;
        private final Channel chVbefSwch;
        private final Channel chIbefSwch;
        private final Channel chDac;
        private final Object updateLock = new Object();
        private double setpt = 0.0;
        private double volts = 0.0;
        private double lastVolts = 0.0;
        private double current = 0.0;
        private double lastCurrent = 0.0;
        private int dac = 0;
        private int lastDac = 0;
        private long lastMillis = 0L;
        private int firstDac = 1200;
        private int maxDac = 3200;
        private double voltsPerStep = 0.1;
        private double voltsPerStepCal = 0.05;
        private double reff = 645.0;
        private boolean useVoltsPerStepCal = false;

        RebHvBiasInfo(Object target, Channel chVbefSwch, Channel chIbefSwch, Channel chDac) {
            this.target = target;
            this.chVbefSwch = chVbefSwch;
            this.chIbefSwch = chIbefSwch;
            this.chDac = chDac;
        }

        public Object getUpdateLock() {
            return this.updateLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.getUpdateLock();
            synchronized (object) {
                String str = String.format("       setpt: %.3f\n", this.setpt) + String.format("       volts: %.3f\n", this.volts) + String.format("       lastVolts: %.3f\n", this.lastVolts) + String.format("       current: %.3f\n", this.current) + String.format("       lastCurrent: %.3f\n", this.lastCurrent) + String.format("       dac: %d\n", this.dac) + String.format("       lastDac: %d\n", this.lastDac) + String.format("       lastMillis: %d\n", this.lastMillis) + String.format("       firstDac: %d\n", this.firstDac) + String.format("       maxDac: %d\n", this.maxDac) + String.format("       voltsPerStep: %.3f\n", this.voltsPerStep) + String.format("       voltsPerStepCal: %.3f\n", this.voltsPerStepCal);
                return str;
            }
        }
    }
}

