/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.MessagingService;
import org.lsst.ccs.subsystem.common.actions.ComCamSharedVacState;
import org.lsst.ccs.subsystem.power.SwitchControl;
import org.lsst.ccs.subsystem.power.constants.ComCamQuadBoxSwitches;
import org.lsst.ccs.subsystem.power.constants.SwitchState;
import org.lsst.ccs.subsystem.power.data.ComCamQuadBoxState;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.utilities.logging.Logger;

public class ComCamQuadBox
extends Subsystem
implements HasLifecycle,
AgentPresenceListener,
StatusMessageListener {
    private static final Map<Integer, String> typeMap = new HashMap<Integer, String>();
    private static final Logger LOG;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService aps;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService apts;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<SwitchControl> swDeviceList = new ArrayList<SwitchControl>();
    private final SwitchControl[] swDevices = new SwitchControl[5];
    private final ComCamQuadBoxState qbState = new ComCamQuadBoxState();
    private ComCamSharedVacState comCamSharedVacState = new ComCamSharedVacState();

    public ComCamQuadBox() {
        super("comcamquadbox", AgentInfo.AgentType.WORKER);
    }

    public void postInit() {
        this.aps.setAgentProperty("comcamQuadBoxAgent", ((Object)((Object)this)).getClass().getCanonicalName());
        ((MessagingService)this.subsys.getAgentService(MessagingService.class)).getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener((AgentPresenceListener)this);
        boolean error = false;
        for (SwitchControl sd : this.swDeviceList) {
            if (sd.getSwitchDevice() == 5) continue;
            this.swDevices[sd.getSwitchDevice()] = sd;
            LOG.info((Object)("sd.getSwitchDevice()= " + sd.getSwitchDevice() + " , sd = " + sd));
        }
        for (int j = 0; j < this.swDevices.length; ++j) {
            if (this.swDevices[j] != null) continue;
            LOG.error((Object)("The " + typeMap.get(j) + " device has not been specified"));
            error = true;
        }
        if (error) {
            throw new RuntimeException("Fatal initialization error");
        }
    }

    public void postStart() {
        this.updateState();
        this.publishState();
        LOG.info((Object)"Quad Box subsystem started");
    }

    public void periodicBroadcast() {
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a switch")
    public void setSwitchOn(@Argument(description="The switch number") int sw, @Argument(description="Whether to turn on") boolean on) throws PowerException {
        int devNum = sw >> 8;
        byte swNum = (byte)sw;
        if (devNum < 0 || devNum >= 5 || swNum >= ComCamQuadBoxSwitches.NUM_SWITCHES[devNum]) {
            throw new PowerException("Invalid switch number: " + sw);
        }
        LOG.info((Object)("Noting request to flip switch = " + sw + " *********************************"));
        if (sw != 2) {
            if (on) {
                this.swDevices[devNum].switchOn(swNum);
            } else {
                this.swDevices[devNum].switchOff(swNum);
            }
        } else {
            Boolean validVacInfo = this.comCamSharedVacState.getVacuumState() != ComCamSharedVacState.VacuumState.UNKNOWN;
            Boolean forceVATclosed = this.comCamSharedVacState.isForceValveClosing();
            Boolean VATStateOpenRequest = this.comCamSharedVacState.isValveOpenStateRequested();
            if (validVacInfo.booleanValue()) {
                if (forceVATclosed.booleanValue()) {
                    LOG.info((Object)"Forcing VAT valve closed!");
                    this.swDevices[devNum].switchOff(swNum);
                } else if (this.comCamSharedVacState.isValveOpenStateRequested() != null) {
                    if (VATStateOpenRequest.booleanValue()) {
                        LOG.info((Object)"Opening of the VAT valve requested.");
                        this.swDevices[devNum].switchOn(swNum);
                    } else if (!VATStateOpenRequest.booleanValue()) {
                        LOG.info((Object)"Closing of the VAT valve requested.");
                        this.swDevices[devNum].switchOff(swNum);
                    }
                } else {
                    LOG.info((Object)"Must be executed through request from comcam-vacuum");
                }
            }
        }
        this.updateState();
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setNamedSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws PowerException {
        Integer sw = (Integer)ComCamQuadBoxSwitches.switchNameToId.get(name);
        if (sw == null) {
            throw new PowerException("Invalid switch name: " + name);
        }
        this.setSwitchOn(sw, on);
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of switch names")
    public List<String> getSwitchNames() {
        return new ArrayList<String>(ComCamQuadBoxSwitches.switchNameToId.keySet());
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update period")
    public void setUpdatePeriod(@Argument(name="period", description="The tick period (msecs)") int period) {
        this.setTickPeriod(period);
        this.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public ComCamQuadBoxState getFullState() throws PowerException {
        this.updateState();
        this.qbState.setTickMillis(this.getTickPeriod());
        return this.qbState;
    }

    private void updateState() {
        for (int devNum = 0; devNum < 5; ++devNum) {
            for (int swNum = -1; swNum < ComCamQuadBoxSwitches.NUM_SWITCHES[devNum]; ++swNum) {
                Boolean st = this.swDevices[devNum].isSwitchOn(swNum);
                SwitchState ss = st == null ? SwitchState.OFFLINE : (st != false ? SwitchState.ON : SwitchState.OFF);
                this.qbState.setSwitchState(devNum, swNum, ss);
            }
        }
    }

    private void setTickPeriod(long period) {
        this.apts.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.apts.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    private void publishState() {
        this.qbState.setTickMillis(this.getTickPeriod());
        KeyValueData kvd = new KeyValueData("ComCamQuadBoxState", (Serializable)this.qbState);
        this.publishSubsystemDataOnStatusBus(kvd);
    }

    public void connected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            LOG.info((Object)("agent = " + agent));
            if (!agent.getName().contains("comcam-vacuum")) continue;
            String agentName = agent.getName();
            ((MessagingService)this.subsys.getAgentService(MessagingService.class)).getMessagingAccess().addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().getName().equals(agentName));
        }
    }

    public void disconnected(AgentInfo ... agents) {
        for (AgentInfo agent : agents) {
            if (!agent.hasAgentProperty(ComCamSharedVacState.class.getCanonicalName())) continue;
            ((MessagingService)this.subsys.getAgentService(MessagingService.class)).getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this);
        }
    }

    public void onStatusMessage(StatusMessage msg) {
        try {
            StatusSubsystemData sd = (StatusSubsystemData)msg;
            if (!sd.getDataKey().equals("ComCamSharedVacState")) {
                return;
            }
            this.comCamSharedVacState = (ComCamSharedVacState)sd.getSubsystemData().getValue();
            LOG.info((Object)("vacuum state = " + this.comCamSharedVacState.getVacuumState() + " | vacuum state OK = " + (this.comCamSharedVacState.getVacuumState() != ComCamSharedVacState.VacuumState.UNKNOWN) + " | forceValveClosing = " + this.comCamSharedVacState.isForceValveClosing() + " | valveOpenStateRequested = " + this.comCamSharedVacState.isValveOpenStateRequested()));
        }
        catch (Exception e) {
            LOG.fine((Object)("not StatusSubsystemData :" + e));
        }
        int sw = 2;
        int devNum = sw >> 8;
        byte swNum = (byte)sw;
        Boolean st = this.swDevices[devNum].isSwitchOn(swNum);
        if (st.booleanValue() && this.comCamSharedVacState.isForceValveClosing()) {
            try {
                this.setSwitchOn(sw, false);
            }
            catch (PowerException e) {
                LOG.error((Object)("Failed to set switch to force the VAT valve closed! - " + e));
            }
        } else if (!this.comCamSharedVacState.isForceValveClosing() && this.comCamSharedVacState.isValveOpenStateRequested() != null) {
            try {
                if (!st.booleanValue() && this.comCamSharedVacState.isValveOpenStateRequested().booleanValue()) {
                    this.setSwitchOn(sw, true);
                }
                if (st.booleanValue() && !this.comCamSharedVacState.isValveOpenStateRequested().booleanValue()) {
                    this.setSwitchOn(sw, false);
                }
            }
            catch (PowerException e) {
                LOG.error((Object)("Failed to set VAT valve switch! - " + e));
            }
        }
    }

    static {
        typeMap.put(0, "BFR");
        typeMap.put(1, "5V PDU");
        typeMap.put(2, "24V clean PDU");
        typeMap.put(3, "24V dirty PDU");
        typeMap.put(4, "48V PDU");
        LOG = Logger.getLogger((String)ComCamQuadBox.class.getName());
    }

    static class DummyDevice
    implements SwitchControl {
        DummyDevice() {
        }

        @Override
        public int getSwitchDevice() {
            return 0;
        }

        @Override
        public Boolean isSwitchOn(int sw) {
            return null;
        }

        @Override
        public void switchOn(int sw) {
        }

        @Override
        public void switchOff(int sw) {
        }
    }
}

