import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.power.EatonPdus
import org.lsst.ccs.subsystem.power.EpduG3Device
import org.lsst.ccs.monitor.Channel

CCSBuilder builder = ["eatonpdus"]

builder.main (EatonPdus) {

    PDU01 (EpduG3Device) {
        
        Input_V (Channel, description: "Input voltage", units: "Volts", format: ".1f",
                 hwChan: 0, type: "VOLTAGE")

        Input_I (Channel, description: "Input current", units: "Amps", format: ".2f",
                 hwChan: 0, type: "CURRENT")

        Input_P (Channel, description: "Input power", units: "Watts", format: ".1f",
                 hwChan: 0, type: "POWER")

        Temperature (Channel, description: "Temperature", units: "\u00b0C", format: ".1f",
                     hwChan: 0, type: "TEMP")

        SS02Disk_2_I (Channel, description: "SS02 disk 2 current", units: "Amps", format: ".2f",
                      hwChan: 1, type: "CURRENT")

        SS02Disk_2_P (Channel, description: "SS02 disk 2 power", units: "Watts", format: ".1f",
                      hwChan: 1, type: "POWER")

        SS02_2_I (Channel, description: "SS02 2 current", units: "Amps", format: ".2f",
                  hwChan: 2, type: "CURRENT")

        SS02_2_P (Channel, description: "SS02 2 power", units: "Watts", format: ".1f",
                  hwChan: 2, type: "POWER")

        FPCrate_3_I (Channel, description: "FP crate 3 current", units: "Amps", format: ".2f",
                     hwChan: 5, type: "CURRENT")

        FPCrate_3_P (Channel, description: "FP crate 3 power", units: "Watts", format: ".1f",
                     hwChan: 5, type: "POWER")

        FPCrate_4_I (Channel, description: "FP crate 4 current", units: "Amps", format: ".2f",
                     hwChan: 6, type: "CURRENT")

        FPCrate_4_P (Channel, description: "FP crate 4 power", units: "Watts", format: ".1f",
                     hwChan: 6, type: "POWER")

    }

    PDU02 (EpduG3Device) {
        
        Input_V (Channel, description: "Input voltage", units: "Volts", format: ".1f",
                 hwChan: 0, type: "VOLTAGE")

        Input_I (Channel, description: "Input current", units: "Amps", format: ".2f",
                 hwChan: 0, type: "CURRENT")

        Input_P (Channel, description: "Input power", units: "Watts", format: ".1f",
                 hwChan: 0, type: "POWER")

        Temperature (Channel, description: "Temperature", units: "\u00b0C", format: ".1f",
                     hwChan: 0, type: "TEMP")

        SS02Disk_1_I (Channel, description: "SS02 disk 1 current", units: "Amps", format: ".2f",
                       hwChan: 1, type: "CURRENT")

        SS02Disk_1_P (Channel, description: "SS02 disk 1 power", units: "Watts", format: ".1f",
                       hwChan: 1, type: "POWER")

        SS02_1_I (Channel, description: "SS02 1 current", units: "Amps", format: ".2f",
                  hwChan: 2, type: "CURRENT")

        SS02_1_P (Channel, description: "SS02 1 power", units: "Watts", format: ".1f",
                  hwChan: 2, type: "POWER")

        FPCrate_1_I (Channel, description: "FP crate 1 current", units: "Amps", format: ".2f",
                     hwChan: 5, type: "CURRENT")

        FPCrate_1_P (Channel, description: "FP crate 1 power", units: "Watts", format: ".1f",
                     hwChan: 5, type: "POWER")

        FPCrate_2_I (Channel, description: "FP crate 2 current", units: "Amps", format: ".2f",
                     hwChan: 6, type: "CURRENT")

        FPCrate_2_P (Channel, description: "FP crate 2 power", units: "Watts", format: ".1f",
                     hwChan: 6, type: "POWER")

        ComcamCrate_1_I (Channel, description: "Comcam crate 1 current", units: "Amps", format: ".2f",
                         hwChan: 19, type: "CURRENT")

        ComcamCrate_1_P (Channel, description: "Comcam crate 1 power", units: "Watts", format: ".1f",
                         hwChan: 19, type: "POWER")

        ComcamCrate_2_I (Channel, description: "Comcam crate 2 current", units: "Amps", format: ".2f",
                         hwChan: 20, type: "CURRENT")

        ComcamCrate_2_P (Channel, description: "Comcam crate 2 power", units: "Watts", format: ".1f",
                         hwChan: 20, type: "POWER")

        TwoRaftCrate_1_I (Channel, description: "Two-raft crate 1 current", units: "Amps", format: ".2f",
                          hwChan: 21, type: "CURRENT")

        TwoRaftCrate_1_P (Channel, description: "Two-raft crate 1 power", units: "Watts", format: ".1f",
                          hwChan: 21, type: "POWER")

        TwoRaftCrate_2_I (Channel, description: "Two-raft crate 2 current", units: "Amps", format: ".2f",
                          hwChan: 22, type: "CURRENT")

        TwoRaftCrate_2_P (Channel, description: "Two-raft crate 2 power", units: "Watts", format: ".1f",
                          hwChan: 22, type: "POWER")

        TSCrate_1_I (Channel, description: "TS crate 1 current", units: "Amps", format: ".2f",
                     hwChan: 23, type: "CURRENT")

        TSCrate_1_P (Channel, description: "TS crate 1 power", units: "Watts", format: ".1f",
                     hwChan: 23, type: "POWER")

    }

    PDU03 (EpduG3Device) {
        
        Input_V (Channel, description: "Input voltage", units: "Volts", format: ".1f",
                 hwChan: 0, type: "VOLTAGE")

        Input_I (Channel, description: "Input current", units: "Amps", format: ".2f",
                 hwChan: 0, type: "CURRENT")

        Input_P (Channel, description: "Input power", units: "Watts", format: ".1f",
                 hwChan: 0, type: "POWER")

        Temperature (Channel, description: "Temperature", units: "\u00b0C", format: ".1f",
                     hwChan: 0, type: "TEMP")

        DC09_1_I (Channel, description: "DC09 1 current", units: "Amps", format: ".2f",
                  hwChan: 1, type: "CURRENT")

        DC09_1_P (Channel, description: "DC09 1 power", units: "Watts", format: ".1f",
                  hwChan: 1, type: "POWER")

        DC09_2_I (Channel, description: "DC09 2 current", units: "Amps", format: ".2f",
                  hwChan: 2, type: "CURRENT")

        DC09_2_P (Channel, description: "DC09 2 power", units: "Watts", format: ".1f",
                  hwChan: 2, type: "POWER")

        DC07_1_I (Channel, description: "DC07 1 current", units: "Amps", format: ".2f",
                  hwChan: 3, type: "CURRENT")

        DC07_1_P (Channel, description: "DC07 1 power", units: "Watts", format: ".1f",
                  hwChan: 3, type: "POWER")

        DC07_2_I (Channel, description: "DC07 2 current", units: "Amps", format: ".2f",
                  hwChan: 4, type: "CURRENT")

        DC07_2_P (Channel, description: "DC07 2 power", units: "Watts", format: ".1f",
                  hwChan: 4, type: "POWER")

        DC05_1_I (Channel, description: "DC05 1 current", units: "Amps", format: ".2f",
                  hwChan: 5, type: "CURRENT")

        DC05_1_P (Channel, description: "DC05 1 power", units: "Watts", format: ".1f",
                  hwChan: 5, type: "POWER")

        DC05_2_I (Channel, description: "DC05 2 current", units: "Amps", format: ".2f",
                  hwChan: 6, type: "CURRENT")

        DC05_2_P (Channel, description: "DC05 2 power", units: "Watts", format: ".1f",
                  hwChan: 6, type: "POWER")

        DC03_1_I (Channel, description: "DC03 1 current", units: "Amps", format: ".2f",
                  hwChan: 7, type: "CURRENT")

        DC03_1_P (Channel, description: "DC03 1 power", units: "Watts", format: ".1f",
                  hwChan: 7, type: "POWER")

        DC03_2_I (Channel, description: "DC03 2 current", units: "Amps", format: ".2f",
                  hwChan: 9, type: "CURRENT")

        DC03_2_P (Channel, description: "DC03 2 power", units: "Watts", format: ".1f",
                  hwChan: 9, type: "POWER")

        DC01_1_I (Channel, description: "DC01 1 current", units: "Amps", format: ".2f",
                  hwChan: 12, type: "CURRENT")

        DC01_1_P (Channel, description: "DC01 1 power", units: "Watts", format: ".1f",
                  hwChan: 12, type: "POWER")

        IR2DAQ01_1_I (Channel, description: "IR2DAQ01 1 current", units: "Amps", format: ".2f",
                      hwChan: 14, type: "CURRENT")

        IR2DAQ01_1_P (Channel, description: "IR2DAQ01 1 power", units: "Watts", format: ".1f",
                      hwChan: 14, type: "POWER")

        IR2DAQ01_2_I (Channel, description: "IR2DAQ01 2 current", units: "Amps", format: ".2f",
                      hwChan: 15, type: "CURRENT")

        IR2DAQ01_2_P (Channel, description: "IR2DAQ01 2 power", units: "Watts", format: ".1f",
                      hwChan: 15, type: "POWER")

        SS01_1_I (Channel, description: "SS01 1 current", units: "Amps", format: ".2f",
                  hwChan: 17, type: "CURRENT")

        SS01_1_P (Channel, description: "SS01 1 power", units: "Watts", format: ".1f",
                  hwChan: 17, type: "POWER")

        SS01_2_I (Channel, description: "SS01 2 current", units: "Amps", format: ".2f",
                  hwChan: 18, type: "CURRENT")

        SS01_2_P (Channel, description: "SS01 2 power", units: "Watts", format: ".1f",
                  hwChan: 18, type: "POWER")

        MCMDisks_1_I (Channel, description: "MCM disks 1 current", units: "Amps", format: ".2f",
                      hwChan: 19, type: "CURRENT")

        MCMDisks_1_P (Channel, description: "MCM disks 1 power", units: "Watts", format: ".1f",
                      hwChan: 19, type: "POWER")

        MCMDisks_2_I (Channel, description: "MCM disks 2 current", units: "Amps", format: ".2f",
                      hwChan: 20, type: "CURRENT")

        MCMDisks_2_P (Channel, description: "MCM disks 2 power", units: "Watts", format: ".1f",
                      hwChan: 20, type: "POWER")

    }

    PDU04 (EpduG3Device) {
        
        Input_V (Channel, description: "Input voltage", units: "Volts", format: ".1f",
                 hwChan: 0, type: "VOLTAGE")

        Input_I (Channel, description: "Input current", units: "Amps", format: ".2f",
                 hwChan: 0, type: "CURRENT")

        Input_P (Channel, description: "Input power", units: "Watts", format: ".1f",
                 hwChan: 0, type: "POWER")

        Temperature (Channel, description: "Temperature", units: "\u00b0C", format: ".1f",
                     hwChan: 0, type: "TEMP")

        DC10_1_I (Channel, description: "DC10 1 current", units: "Amps", format: ".2f",
                  hwChan: 1, type: "CURRENT")

        DC10_1_P (Channel, description: "DC10 1 power", units: "Watts", format: ".1f",
                  hwChan: 1, type: "POWER")

        DC10_2_I (Channel, description: "DC10 2 current", units: "Amps", format: ".2f",
                  hwChan: 2, type: "CURRENT")

        DC10_2_P (Channel, description: "DC10 2 power", units: "Watts", format: ".1f",
                  hwChan: 2, type: "POWER")

        DC08_1_I (Channel, description: "DC08 1 current", units: "Amps", format: ".2f",
                  hwChan: 3, type: "CURRENT")

        DC08_1_P (Channel, description: "DC08 1 power", units: "Watts", format: ".1f",
                  hwChan: 3, type: "POWER")

        DC08_2_I (Channel, description: "DC08 2 current", units: "Amps", format: ".2f",
                  hwChan: 4, type: "CURRENT")

        DC08_2_P (Channel, description: "DC08 2 power", units: "Watts", format: ".1f",
                  hwChan: 4, type: "POWER")

        DC06_1_I (Channel, description: "DC06 1 current", units: "Amps", format: ".2f",
                  hwChan: 5, type: "CURRENT")

        DC06_1_P (Channel, description: "DC06 1 power", units: "Watts", format: ".1f",
                  hwChan: 5, type: "POWER")

        DC06_2_I (Channel, description: "DC06 2 current", units: "Amps", format: ".2f",
                  hwChan: 6, type: "CURRENT")

        DC06_2_P (Channel, description: "DC06 2 power", units: "Watts", format: ".1f",
                  hwChan: 6, type: "POWER")

        DC04_1_I (Channel, description: "DC04 1 current", units: "Amps", format: ".2f",
                  hwChan: 7, type: "CURRENT")

        DC04_1_P (Channel, description: "DC04 1 power", units: "Watts", format: ".1f",
                  hwChan: 7, type: "POWER")

        DC04_2_I (Channel, description: "DC04 2 current", units: "Amps", format: ".2f",
                  hwChan: 9, type: "CURRENT")

        DC04_2_P (Channel, description: "DC04 2 power", units: "Watts", format: ".1f",
                  hwChan: 9, type: "POWER")

        DC01_2_I (Channel, description: "DC01 2 current", units: "Amps", format: ".2f",
                  hwChan: 10, type: "CURRENT")

        DC01_2_P (Channel, description: "DC01 2 power", units: "Watts", format: ".1f",
                  hwChan: 10, type: "POWER")

        DC02_1_I (Channel, description: "DC02 1 current", units: "Amps", format: ".2f",
                  hwChan: 12, type: "CURRENT")

        DC02_1_P (Channel, description: "DC02 1 power", units: "Watts", format: ".1f",
                  hwChan: 12, type: "POWER")

        DC02_2_I (Channel, description: "DC02 2 current", units: "Amps", format: ".2f",
                  hwChan: 13, type: "CURRENT")

        DC02_2_P (Channel, description: "DC02 2 power", units: "Watts", format: ".1f",
                  hwChan: 13, type: "POWER")

        SS01Disks_1_I (Channel, description: "SS01 disks 1 current", units: "Amps", format: ".2f",
                       hwChan: 14, type: "CURRENT")

        SS01Disks_1_P (Channel, description: "SS01 disks 1 power", units: "Watts", format: ".1f",
                       hwChan: 14, type: "POWER")

        SS01Disks_2_I (Channel, description: "SS01 disks 2 current", units: "Amps", format: ".2f",
                       hwChan: 15, type: "CURRENT")

        SS01Disks_2_P (Channel, description: "SS01 disks 2 power", units: "Watts", format: ".1f",
                       hwChan: 15, type: "POWER")

        MCM_1_I (Channel, description: "MCM 1 current", units: "Amps", format: ".2f",
                 hwChan: 17, type: "CURRENT")

        MCM_1_P (Channel, description: "MCM 1 power", units: "Watts", format: ".1f",
                 hwChan: 17, type: "POWER")

        MCM_2_I (Channel, description: "MCM 2 current", units: "Amps", format: ".2f",
                 hwChan: 18, type: "CURRENT")

        MCM_2_P (Channel, description: "MCM 2 power", units: "Watts", format: ".1f",
                 hwChan: 18, type: "POWER")

        VS01_1_I (Channel, description: "VS01 1 current", units: "Amps", format: ".2f",
                  hwChan: 19, type: "CURRENT")

        VS01_1_P (Channel, description: "VS01 1 power", units: "Watts", format: ".1f",
                  hwChan: 19, type: "POWER")

        VS01_2_I (Channel, description: "VS01 2 current", units: "Amps", format: ".2f",
                  hwChan: 20, type: "CURRENT")

        VS01_2_P (Channel, description: "VS01 2 power", units: "Watts", format: ".1f",
                  hwChan: 20, type: "POWER")

    }

}
