/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.subsystem.common.actions.BulkPsPowerAction;
import org.lsst.ccs.subsystem.common.focalplane.data.HasFocalPlaneData;
import org.lsst.ccs.subsystem.power.CornerRaftRebPowerSupplyNode;
import org.lsst.ccs.subsystem.power.EmergencyResponseManager;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.RebPowerSupplyNode;
import org.lsst.ccs.subsystem.power.RebPsDevice;
import org.lsst.ccs.subsystem.power.data.PowerDataGroup;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.states.PowerSupplyState;
import org.lsst.ccs.subsystem.power.states.RebDPhiState;
import org.lsst.ccs.subsystem.power.states.RebHvBiasState;
import org.lsst.ccs.subsystem.power.states.RebPowerState;

public class RebPowerSupplyMain
extends Subsystem
implements HasLifecycle,
HasDataProviderInfos {
    private static final Logger LOG = Logger.getLogger(RebPowerSupplyMain.class.getName());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<PowerDevice> mainPsList = new ArrayList<PowerDevice>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<RebPsDevice> psDeviceList = new ArrayList<RebPsDevice>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private EmergencyResponseManager emergencyResponseManager;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, RebPowerSupplyNode> rebs = new HashMap<String, RebPowerSupplyNode>();
    @ConfigurationParameter(units="ms", description="During the powerOffAllRebs command this is the sleep time between each node being powered off.")
    private volatile long powerOffSleepMillis = 100L;
    @ConfigurationParameter(name="psDeviceReadTimeout", description="Read Timeout for the underlying PS driver", units="ms")
    private volatile long psDeviceReadTimeout = 1000L;
    @ConfigurationParameter(category="General", description="Number of consecutive read failures (exceptions) before gonig Offline. Must be a positive number greater than zero.", range="1..5", units="unitless")
    private volatile int psDeviceExcepNumToOffline = 1;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, Channel> channels = new HashMap<String, Channel>();

    public RebPowerSupplyMain() {
        super("rebps", AgentInfo.AgentType.WORKER);
    }

    public void build() {
        if (this.emergencyResponseManager == null) {
            throw new RuntimeException("Cannot operate the RebPower subsystem without an EmergencyResponseManager");
        }
        this.agentPropertiesService.setAgentProperty(BulkPsPowerAction.class.getCanonicalName(), "uses");
        this.agentPropertiesService.setAgentProperty("agentCategory", AgentCategory.POWER.name());
        this.agentPropertiesService.setAgentProperty(HasFocalPlaneData.AGENT_PROPERTY, HasFocalPlaneData.generatePropertyValue(PowerDataGroup.class));
        AgentPeriodicTask pt = new AgentPeriodicTask("reb-power-state", () -> this.updateRebPowerState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void init() {
        for (RebPowerSupplyNode reb : this.rebs.values()) {
            this.agentStateService.registerState(RebPowerState.class, "REB power state", (Object)reb);
            this.agentStateService.registerState(RebHvBiasState.class, "REB HV bias state", (Object)reb);
            if (!(reb instanceof CornerRaftRebPowerSupplyNode)) continue;
            this.agentStateService.registerState(RebDPhiState.class, "REB Dphi state", (Object)reb);
        }
        for (RebPsDevice powerSupplyDevice : this.psDeviceList) {
            this.agentStateService.registerState(PowerSupplyState.class, "Power Supply state", (Object)powerSupplyDevice);
        }
        this.setPsDeviceReadTimeout(this.psDeviceReadTimeout);
        this.setPsDeviceConsecutiveExceptionsToOffline(this.psDeviceExcepNumToOffline);
    }

    @ConfigurationParameterChanger(propertyName="psDeviceExcepNumToOffline")
    public void setPsDeviceConsecutiveExceptionsToOffline(int value) {
        this.psDeviceExcepNumToOffline = value;
        for (RebPsDevice powerSupplyDevice : this.psDeviceList) {
            powerSupplyDevice.setConsecutiveExceptiionsToOffline(this.psDeviceExcepNumToOffline);
        }
    }

    @ConfigurationParameterChanger(propertyName="psDeviceReadTimeout")
    public void setPsDeviceReadTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("Negative timeouts are not allowd");
        }
        this.psDeviceReadTimeout = timeout;
        for (RebPsDevice powerSupplyDevice : this.psDeviceList) {
            powerSupplyDevice.setReadTimeout(this.psDeviceReadTimeout);
        }
    }

    public void finalizeDictionary() {
        for (DataProviderInfo data : this.dictionaryService.getDataProviderDictionary().getDataProviderInfos()) {
            PowerDataGroup dataGroup = PowerDataGroup.findPowerDataGroup((DataProviderInfo)data);
            if (dataGroup == null) continue;
            dataGroup.addAttributesToDataInfo(data);
        }
    }

    private void updateRebPowerState() {
        StateBundle sb = new StateBundle(new Enum[0]);
        for (RebPsDevice powerSupplyDevice : this.psDeviceList) {
            StateBundle psDeviceState = powerSupplyDevice.getRebPsDeviceState();
            sb = sb.mergeState(psDeviceState);
        }
        this.agentStateService.updateAgentState(sb);
    }

    @Command
    public void powerOffAllRebs() throws InterruptedException {
        String failedRebs = "";
        int count = this.rebs.size();
        for (RebPowerSupplyNode node : this.rebs.values()) {
            --count;
            if (!this.agentStateService.isComponentInState(node.rebPath, (Enum)RebPowerState.ON)) continue;
            LOG.log(Level.INFO, "Powering off reb: {0}", new Object[]{node.rebPath});
            try {
                node.powerRebOff();
            }
            catch (PowerException ex) {
                LOG.log(Level.WARNING, "Failed to power off reb: " + node.rebPath, ex);
                failedRebs = failedRebs + node.rebPath + " ";
            }
            if (count <= 0) continue;
            Thread.sleep(this.powerOffSleepMillis);
        }
        if (!failedRebs.isEmpty()) {
            throw new RuntimeException("Failed to turn off the following rebs: " + failedRebs.trim());
        }
    }
}

