package org.lsst.ccs.subsystem.power;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.common.BasicMain;
import org.lsst.ccs.subsystem.power.constants.PowerAgentProperties;

/**
 *  Implements the Eaton PDU monitoring subsystem.
 *
 *  @author Owen Saxton
 */
public class EatonPdus extends BasicMain {

    private static final Logger LOG = Logger.getLogger(EatonPdus.class.getName());
    

    /**
     *  Constructor.
     */
    public EatonPdus() {
        super("eatonPdus", PowerAgentProperties.EATON_PDU_AGENT);
    }


    /**
     *  Starts the subsystem.
     */
    @Override
    public void postStart()
    {
        LOG.info("Eaton PDU subsystem started");
    }

}
