/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.dataforth;

import java.util.Map;
import java.util.TreeMap;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;

public class SimMaq20Device
extends Maq20Device {
    private final Map<String, Channel> channelMap = new TreeMap<String, Channel>();

    @Override
    protected void initDevice() {
        super.initDevice();
        Maq20.ModuleType[] modTypes = new Maq20.ModuleType[this.getModuleCount()];
        for (int j = 0; j < modTypes.length; ++j) {
            modTypes[j] = this.getModuleData((int)j).modDef.type;
        }
        this.maq.initSimulation(modTypes, this.serials);
        this.fullName = this.path + " (Simulated Maq20 system)";
    }

    public void postStart() {
        for (String chanPath : this.channelMap.keySet()) {
            try {
                this.setChannelValue(chanPath, 20.0 + Math.random());
            }
            catch (DriverException driverException) {}
        }
    }

    @Override
    protected int[] checkChannel(Channel ch) throws Exception {
        int[] result = super.checkChannel(ch);
        this.channelMap.put(ch.getPath(), ch);
        return result;
    }

    @Command(type=Command.CommandType.ACTION, description="Set a channel value")
    public void setChannelValue(@Argument(description="Channel name") String chanName, @Argument(description="Channel value") double value) throws DriverException {
        Channel chan = this.channelMap.get(chanName);
        if (chan == null) {
            throw new DriverException("Invalid channel name: " + chanName);
        }
        double offset = chan.convertRawValue(0.0);
        double scale = chan.convertRawValue(1.0) - offset;
        this.maq.setSimChannelValue(this.getModuleData((int)(chan.getType() & 0xFF)).modId, chan.getHwChan(), (value - offset) / scale);
    }

    @Command(type=Command.CommandType.QUERY, description="Get the list of channel names")
    public String getChannelNames() {
        return this.channelMap.keySet().toString();
    }
}

