package org.lsst.ccs.subsystem.power;

import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Alarm;
import org.lsst.ccs.subsystem.common.actions.BulkPsPowerAction;
import org.lsst.ccs.subsystem.power.alerts.RebPowerAlertType;

/**
 * An Alarm class for raising alerts specific to a given RebPs.
 *
 * @author The LSST CCS Team
 */
public class RebPsBoardAlarm extends Alarm {

    @LookupField(strategy = LookupField.Strategy.ANCESTORS)
    RebPsDevice rebPsDevice;

    RebPowerAlertType alertType = null;
    
    
    @Override
    public void build() {
        if ( rebPsDevice == null ) {
            throw new RuntimeException("A RebPowerAlertType must defined within a RebPsDevice.");
        }
        if ( alertType == null ) {
            throw new RuntimeException("An alert type must be specified.");
        }
        super.build();
        this.description = alertType.getDescription();
    }
    
    RebPsDevice getRebDevice() {
        return rebPsDevice;
    }

    @Override
    public Alert getAlert(AlertState alertState, AlertState previousAlertState) {
        Alert alert = new Alert(alertType.getAlertId()+"/"+rebPsDevice.getPath(),alertType.getDescription());
        //Add a BulkPsPowerAction payload only if in ALARM state and if the temperatures are too high
        if ( alertType == RebPowerAlertType.REB_PS_BOARD_TEMPERATURE_TOO_HIGH ) {
            if (alertState == AlertState.ALARM) {
                BulkPsPowerAction.addBulkPsPowerActionPayloadToAlert(alert, BulkPsPowerAction.Type.TURN_BULK_PS_OFF, rebPsDevice.getBulkPsSwitchName());
            }
        }
        return alert;                
    }
    

}
