/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.keithley;

import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.drivers.scpi.Scpi;

public class N6487
extends Scpi
implements PowerSupplyDriver {
    public static final int MAX_BUFF_SIZE = 3000;
    public static final int DEFAULT_BAUD = 19200;
    @Deprecated
    private static final String DEFAULT_DEV = "/dev/ttyUSB0";
    private static final double MINBIAS = -75.0;
    private static final double MAXBIAS = 5.0;
    private static final double MAXCURRENT = 0.001;
    private boolean debug = true;
    private boolean okToTalk = true;
    private boolean accumInProgress = false;
    private boolean trip = false;
    private boolean abort = false;
    private int lineFreq;
    private boolean singleRead;
    private avg_status do_avg = avg_status.UNSET;
    private int nAvg = 2;

    public N6487() {
        this.setOptions(Ascii.Option.NO_NET);
        this.setDefaultParm(19200);
    }

    public void open(DriverConstants.ConnType connType, String ident, int baudRate, int commParm) throws DriverException {
        super.open(connType, ident, baudRate, commParm);
        try {
            this.setTimeout(10.0);
            this.checkIdentification("KEITHLEY", 1, "MODEL 648", 1);
            this.writeCommand("SYST:LFR:AUTO ON");
            this.lineFreq = this.readInteger("SYST:LFR?");
            this.singleRead = false;
        }
        catch (DriverException e) {
            this.closeSilent();
            throw e;
        }
    }

    public synchronized String printdevid() throws DriverException {
        this.checkOkToTalk();
        String[] id = this.getIdentification();
        return "Successfully connected to:\nManufacturer:   " + id[0] + "\nModel name:     " + id[1] + "\nSerial number:  " + id[2] + "\nF/W version:    " + id[3];
    }

    public void setDebug(boolean setOn) {
        this.debug = setOn;
    }

    public void reset() throws DriverException {
        this.okToTalk = true;
        this.writeCommand("*RST");
        this.setArmCount(1);
        this.writeCommand("TRAC:FEED:CONT NEVER");
        this.writeCommand("SOUR:VOLT:SWE:ABOR");
    }

    public void softReset() throws DriverException {
        this.okToTalk = true;
        this.setTrigCount(1);
        this.setArmCount(1);
        this.writeCommand("TRAC:FEED:CONT NEVER");
        this.writeCommand("SOUR:VOLT:SWE:ABOR");
    }

    public synchronized void clearStat() throws DriverException {
        this.checkOkToTalk();
        this.clearStatus();
    }

    public synchronized void setDisplay(boolean dstate) throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("DISP:ENAB " + (dstate ? "ON" : "OFF"));
    }

    public synchronized void setRate(double value) throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("NPLC " + value);
    }

    public synchronized double getRate() throws DriverException {
        this.checkOkToTalk();
        return this.readDouble("NPLC?");
    }

    public synchronized void setArmCount(int value) throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("ARM:COUN " + value);
        this.singleRead = false;
    }

    public synchronized void setTrigCount(int value) throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("TRIG:COUN " + value);
        this.singleRead = false;
    }

    public synchronized void setTrigDelay(double value) throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("TRIG:DEL " + value);
        this.singleRead = false;
    }

    public synchronized void setBuffSize(int value) throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("TRAC:POIN " + value);
    }

    public synchronized void clrBuff() throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("TRAC:CLE");
    }

    public synchronized void setCurrentRange(double value) throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("FUNC 'CURR'");
        this.writeCommand("RANG " + value);
    }

    public synchronized void zeroCorrectCurrent() throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("SYST:ZCH ON");
        this.writeCommand("FUNC 'CURR'");
        this.writeCommand("INIT");
        this.writeCommand("SYST:ZCOR:ACQ");
        this.writeCommand("SYST:ZCOR ON");
        this.writeCommand("SYST:ZCH OFF");
    }

    public synchronized double[] readPower() throws DriverException {
        this.checkOkToTalk();
        if (!this.singleRead) {
            this.setArmCount(1);
            this.setTrigCount(1);
            this.setTrigDelay(0.0);
            this.writeCommand("SYST:ZCH OFF");
            this.writeCommand("FORM:ELEM VSO,READ");
            this.singleRead = true;
        }
        return this.readDoubleArray("READ?");
    }

    public double readCurrent() throws DriverException {
        return this.readPower()[0];
    }

    public synchronized double[][] readCurrents(int nreads, double intvl) throws DriverException {
        this.checkOkToTalk();
        this.setArmCount(nreads);
        this.setTrigCount(1);
        double nplc = this.getRate();
        double delay = 0.0;
        if (intvl < nplc) {
            this.setRate(intvl);
        } else {
            delay = (intvl - nplc) / (double)this.lineFreq;
        }
        this.setTrigDelay(delay);
        this.writeCommand("FORM:ELEM READ,TIME");
        this.writeCommand("SYST:ZCH OFF");
        this.writeCommand("SYST:AZER:STAT OFF");
        this.writeCommand("SYST:TIME:RESET");
        String[] buff = this.readStringArray("READ?");
        if (buff.length != 2 * nreads) {
            throw new DriverException("Bad data amount: expected " + 2 * nreads + " items, got " + buff.length + ". First item = " + buff[0]);
        }
        return this.getDoublePairArray(buff);
    }

    public synchronized void accumBuffer(int nreads, double intvl) throws DriverException {
        this.checkOkToTalk();
        this.setArmCount(nreads);
        this.setTrigCount(1);
        double nplc = this.getRate();
        double delay = 0.0;
        if (intvl < nplc) {
            this.setRate(intvl);
        } else {
            delay = (intvl - nplc) / (double)this.lineFreq;
        }
        this.setTrigDelay(delay);
        this.setBuffSize(nreads);
        this.writeCommand("SYST:ZCH OFF");
        this.writeCommand("SYST:AZER:STAT OFF");
        this.writeCommand("TRAC:TST:FORM ABS");
        if (this.do_avg == avg_status.ON) {
            this.writeCommand("AVER:COUNT " + this.nAvg);
            this.writeCommand("AVER:TCON REP");
            this.writeCommand("AVER ON");
        } else if (this.do_avg == avg_status.OFF) {
            this.writeCommand("AVER OFF");
        }
        this.writeCommand("TRAC:FEED SENS");
        this.writeCommand("TRAC:FEED:CONT NEXT");
        this.debugPrint(String.format("Sending PD accumulation trigger at %14.3f", (double)System.currentTimeMillis() / 1000.0));
        this.writeCommand("INIT");
        this.write("*OPC?");
        this.okToTalk = false;
        this.accumInProgress = true;
    }

    public synchronized void waitAccum(double timeout) throws DriverException {
        if (!this.accumInProgress) {
            this.debugPrint("No buffer accumulation in progress");
            return;
        }
        long endTime = System.currentTimeMillis() + (long)(1000.0 * timeout);
        DriverTimeoutException te = null;
        while (true) {
            try {
                String resp = this.read();
                if (!resp.equals("1")) {
                    this.debugPrint("Unexpected response while waiting for buffer accumulation: " + resp);
                }
                te = null;
                this.okToTalk = true;
                this.accumInProgress = false;
            }
            catch (DriverTimeoutException e) {
                te = e;
                if (System.currentTimeMillis() <= endTime) continue;
            }
            break;
        }
        if (te != null) {
            throw te;
        }
    }

    public synchronized double[][] readBuffer() throws DriverException {
        this.checkOkToTalk();
        int numread = this.readInteger("TRAC:POIN:ACT?");
        this.debugPrint("Number of elements read = " + numread);
        this.writeCommand("FORM:ELEM READ,TIME");
        String[] buff = this.readStringArray("TRAC:DATA?");
        if (buff.length != 2 * numread) {
            throw new DriverException("Bad data amount: expected " + 2 * numread + " items, got " + buff.length + ". First item = " + buff[0]);
        }
        return this.getDoublePairArray(buff);
    }

    public int getMaxBufferSize() {
        return 3000;
    }

    public String isDo_avg() {
        return this.do_avg.toString();
    }

    public void setDo_avg(boolean do_avg_req) {
        this.do_avg = do_avg_req ? avg_status.ON : avg_status.OFF;
    }

    public int getnAvg() {
        return this.nAvg;
    }

    public void setnAvg(int nAvg) {
        this.nAvg = nAvg;
    }

    public int getLineFreq() throws DriverException {
        return this.lineFreq;
    }

    public boolean isOkToTalk() {
        return this.okToTalk;
    }

    public boolean isDataReady() {
        return !this.accumInProgress;
    }

    public boolean isAccumInProgress() {
        return this.accumInProgress;
    }

    public static double getMinBias() {
        return -75.0;
    }

    public static double getMaxBias() {
        return 5.0;
    }

    public synchronized void setOutput(boolean on) throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("SOUR:VOLT:STAT " + (on ? "ON" : "OFF"));
    }

    public synchronized boolean getOutput() throws DriverException {
        this.checkOkToTalk();
        return this.readInteger("SOUR:VOLT:STAT?") != 0;
    }

    public boolean isTrip() {
        return this.trip;
    }

    public void setTrip(boolean trip) {
        this.trip = trip;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public void setAbort(boolean abort) {
        this.abort = abort;
    }

    public synchronized void setVoltageRange(double value) throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("SOUR:VOLT:RANG " + value);
    }

    public synchronized void setVoltage(double value) throws DriverException {
        double usedvalue = 0.0;
        if (value < -75.0 || value > 5.0) {
            this.debugPrint("Only values between -75.V and 5.V are allowed in order to protect the CCD!");
            throw new DriverException();
        }
        usedvalue = value;
        this.checkOkToTalk();
        this.writeCommand("SOUR:VOLT " + usedvalue);
    }

    public synchronized void rampVoltsSweep(double duration, double value, int nsteps) throws DriverException {
        this.checkOkToTalk();
        double vnow = this.readVoltage();
        double vstep = Math.abs(value - vnow) / (double)nsteps;
        double delta = duration / (double)nsteps;
        this.debugPrint("starting ramp from " + Double.toString(vnow) + " to " + Double.toString(value) + " with vstep = " + Double.toString(vstep) + " with tstep = " + Double.toString(delta));
        this.writeCommand("SOUR:VOLT " + value);
        this.writeCommand("SOUR:VOLT:SWE:STAR " + vnow);
        this.writeCommand("SOUR:VOLT:SWE:STOP " + value);
        this.writeCommand("SOUR:VOLT:SWE:STEP " + vstep);
        this.writeCommand("SOUR:VOLT:SWE:DEL " + delta);
        this.setArmCount(nsteps + 1);
        this.writeCommand("FORM:ELEM READ");
        this.writeCommand("SOUR:VOLT:SWE:INIT");
        this.writeCommand("SYST:ZCH OFF");
        this.debugPrint("started ramp");
        double[] buff = this.readDoubleArray("READ?");
        this.debugPrint("ramp completed");
    }

    public boolean isCurrentOk() throws DriverException {
        return this.readCurrent() < 0.001;
    }

    public synchronized void rampVolts(double duration, double value, int nsteps) throws DriverException {
        this.checkOkToTalk();
        double vnow = this.readVoltage();
        double vstep = (value - vnow) / (double)nsteps;
        int delta = (int)(1000.0 * duration / (double)nsteps);
        this.debugPrint("ramp from " + Double.toString(vnow) + " to " + Double.toString(value) + " with vstep = " + Double.toString(vstep) + " with tstep = " + Integer.toString(delta));
        this.debugPrint("starting ramp");
        double v = vnow;
        boolean trip0 = this.isTrip();
        for (int istep = 0; istep < nsteps + 1; ++istep) {
            this.debugPrint("V = " + v);
            if (!trip0 && this.isTrip() || this.isAbort()) {
                this.debugPrint("STOPPING RAMP!!! IT LOOKS LIKE WE CAUSED A TRIP!");
                break;
            }
            if (this.isCurrentOk()) {
                this.setVoltage(v);
            } else {
                this.debugPrint("driver aborting ramp due to high current!");
                this.setAbort(true);
            }
            try {
                Thread.sleep(delta);
            }
            catch (Exception exception) {
                // empty catch block
            }
            v += vstep;
        }
        this.debugPrint("ramp completed");
    }

    public void rampVolts(double duration, double value) throws DriverException {
        int nsteps = 10;
        this.rampVolts(duration, value, nsteps);
    }

    public synchronized double getVoltage() throws DriverException {
        this.checkOkToTalk();
        return this.readDouble("SOUR:VOLT?");
    }

    public synchronized void zeroCorrectVoltage() throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("SYST:ZCH ON");
        this.writeCommand("SYST:GUAR ON");
        this.writeCommand("FUNC 'VOLT'");
        this.writeCommand("SYST:ZCOR ON");
        this.writeCommand("SYST:ZCH OFF");
    }

    public double readVoltage() throws DriverException {
        return this.readPower()[1];
    }

    public synchronized void setCurrentLimit(double maxima) throws DriverException {
        this.checkOkToTalk();
        this.writeCommand("SOUR:VOLT:ILIM " + maxima);
    }

    public synchronized double getCurrentLimit() throws DriverException {
        this.checkOkToTalk();
        return this.readDouble("SOUR:VOLT:ILIM?");
    }

    private double[][] getDoublePairArray(String[] buff) throws DriverException {
        try {
            double[][] data = new double[2][buff.length / 2];
            int ridx = 0;
            for (int j = 0; j < buff.length; j += 2) {
                data[0][ridx] = Double.valueOf(buff[j]);
                data[1][ridx] = Double.valueOf(buff[j + 1]);
                ++ridx;
            }
            return data;
        }
        catch (NumberFormatException e) {
            throw new DriverException((Throwable)e);
        }
    }

    private void debugPrint(String text) {
        if (this.debug) {
            System.out.println(text);
        }
    }

    private void checkOkToTalk() throws DriverException {
        if (!this.okToTalk) {
            throw new DriverException("Buffered read in progress");
        }
    }

    public synchronized void writeKthly(String instr) throws DriverException {
        this.checkOkToTalk();
        this.writeCommand(instr);
    }

    public synchronized String readStringKthly(String instr) throws DriverException {
        this.checkOkToTalk();
        return this.readString(instr);
    }

    public double readVoltage(int chan) throws DriverException {
        return this.readVoltage();
    }

    public double readCurrent(int chan) throws DriverException {
        return this.readCurrent();
    }

    public void setVoltage(double value, int chan) throws DriverException {
        this.setVoltageRange(value);
        this.setVoltage(value);
    }

    public double getVoltage(int chan) throws DriverException {
        return this.getVoltage();
    }

    public void setCurrent(double value, int chan) throws DriverException {
        this.setCurrentLimit(value);
    }

    public double getCurrent(int chan) throws DriverException {
        return this.getCurrentLimit();
    }

    public void setOutput(boolean on, int chan) throws DriverException {
        this.setOutput(on);
    }

    public boolean getOutput(int chan) throws DriverException {
        return this.getOutput();
    }

    public void setOnDelay(double value, int chan) {
    }

    public void setOffDelay(double value, int chan) {
    }

    @Deprecated
    public void open(String devname) throws DriverException {
        this.openSerial(devname, 0);
    }

    @Deprecated
    public void open() throws DriverException {
        this.open(DEFAULT_DEV, 0);
    }

    @Deprecated
    public void open(String devname, int baud) throws DriverException {
        this.openSerial(devname, baud);
    }

    @Deprecated
    public void openftdi(String serial, int baud) throws DriverException {
        this.openFtdi(serial, baud);
    }

    @Deprecated
    public synchronized void accumBuffer(int nreads, double nplc, boolean wait) throws DriverException {
        this.accumBuffer(nreads, nplc);
    }

    @Deprecated
    public boolean isACCUM_IN_PROGRESS() {
        return this.isAccumInProgress();
    }

    @Deprecated
    public boolean isDATAREADY() {
        return this.isDataReady();
    }

    @Deprecated
    public boolean isOKTOTALK() {
        return this.isOkToTalk();
    }

    @Deprecated
    public void setOKTOTALK(boolean okToTalk) {
        this.okToTalk = okToTalk;
    }

    @Deprecated
    public boolean current_OK() throws DriverException {
        return this.isCurrentOk();
    }

    @Deprecated
    public void rampVolts_sweep(double duration, double value, int nsteps) throws DriverException {
        this.rampVoltsSweep(duration, value, nsteps);
    }

    @Deprecated
    public static double getMINBIAS() {
        return N6487.getMinBias();
    }

    @Deprecated
    public static double getMAXBIAS() {
        return N6487.getMaxBias();
    }

    public static enum avg_status {
        UNSET,
        OFF,
        ON;

    }
}

