package org.lsst.ccs.subsystem.power;

/**
 * A class representing the tripped status for a Reb.
 * 
 * @author The LSST CCS Team
 */
public class RebTrippedState {
    
    private final boolean hasTripped;
    private final String tripReason;
    
    RebTrippedState(boolean hasTripped) {
        this(hasTripped, null);
    }
    
    RebTrippedState(boolean hasTripped, String tripReason) {
        this.hasTripped = hasTripped;
        this.tripReason = tripReason;
    }

    boolean hasTripped() {
        return hasTripped;
    }

    String getTripReason() {
        return tripReason;
    }
    
    
}
