/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

public class PowerSupplyConfiguration {
    private static final Logger LOG = Logger.getLogger(PowerSupplyConfiguration.class.getName());
    private final String name;
    private final String ip;
    private final List<String> rebs;
    private final int bfrRelay;
    private final String bfrName;
    private final int slot;
    private final boolean isCornerRaft;

    PowerSupplyConfiguration(String name, Properties props) {
        this.name = name;
        this.ip = props.getProperty("org.lsst.ccs.power." + name + ".ip");
        this.slot = (Integer)InputConversionEngine.convertArgToType((String)props.getProperty("org.lsst.ccs.power." + name + ".slot"), Integer.class);
        this.bfrRelay = (Integer)InputConversionEngine.convertArgToType((String)props.getProperty("org.lsst.ccs.power." + name + ".bfr.relay"), Integer.class);
        this.bfrName = props.getProperty("org.lsst.ccs.power." + name + ".bfr.name");
        this.isCornerRaft = Boolean.valueOf(props.getProperty("org.lsst.ccs.power." + name + ".isCornerRaft", "false"));
        String rebsBuildProperty = "org.lsst.ccs.power." + name + ".rebs";
        this.rebs = (List)InputConversionEngine.convertArgToType((String)props.getProperty(rebsBuildProperty), List.class);
        if (this.rebs.isEmpty()) {
            LOG.log(Level.WARNING, "No REBs have been provided for Power Supply {0} in build configuration {1}", new Object[]{name, rebsBuildProperty});
        }
    }

    public boolean isCornerRaft() {
        return this.isCornerRaft;
    }

    public String getName() {
        return this.name;
    }

    public String getIp() {
        return this.ip;
    }

    public List<String> getRebs() {
        return this.rebs;
    }

    public int getBfrRelay() {
        return this.bfrRelay;
    }

    public String getBfrName() {
        return this.bfrName;
    }

    public int getSlot() {
        return this.slot;
    }
}

