/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.drivers.auxelex.RebPS;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.power.RebTrippedState;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.utilities.logging.Logger;

public class RebPsDevice
extends Device {
    private static final Logger LOG = Logger.getLogger((String)RebPsDevice.class.getName());
    private static final String UNKN_PSID = "PS-XX";
    private static final int PS_POWER = 255;
    private static final double LIM_LOW_DIGITAL = 4.5;
    private static final double LIM_HIGH_DIGITAL = 6.0;
    private static final double LIM_LOW_ANALOG = 6.5;
    private static final double LIM_HIGH_ANALOG = 8.5;
    private static final double LIM_LOW_CLKL_SR = 12.0;
    private static final double LIM_HIGH_CLKL_SR = 17.0;
    private static final double LIM_LOW_CLKL_CR = 10.0;
    private static final double LIM_HIGH_CLKL_CR = 12.0;
    private static final double LIM_LOW_CLKH_SR = 15.0;
    private static final double LIM_HIGH_CLKH_SR = 17.0;
    private static final double LIM_LOW_CLKH_CR = 10.0;
    private static final double LIM_HIGH_CLKH_CR = 12.0;
    private static final double LIM_LOW_OD_SR = 35.0;
    private static final double LIM_HIGH_OD_SR = 42.0;
    private static final double LIM_LOW_OD_CR = 35.0;
    private static final double LIM_HIGH_OD_CR = 37.0;
    private static final double LIM_LOW_HEATER_SR = 7.0;
    private static final double LIM_HIGH_HEATER_SR = 13.0;
    private static final double LIM_LOW_HEATER_CR = 5.0;
    private static final double LIM_HIGH_HEATER_CR = 7.0;
    private static final double LIM_LOW_DPHI = 4.0;
    private static final double LIM_HIGH_DPHI = 13.0;
    private static final Map<String, Integer> psMap = new HashMap<String, Integer>();
    private static final SeqParams[] onSeqSR02;
    private static final SeqParams[] onSeqSR1;
    private static final SeqParams[] onSeqCR0;
    private static final SeqParams[] onSeqCR1;
    @ConfigurationParameter(name="ipAddr", category="Power", isFinal=true)
    private String ipAddr;
    private int psType = -1;
    private final RebPS ps = new RebPS();
    private int psVersion = 1;
    private Event listener;
    private String psId = "PS-XX";
    private Properties props;
    private boolean isSimulated;
    private double[] power = new double[6];
    private int lastFail = Integer.MIN_VALUE;
    private RebTrippedState[] lastFailArray;
    private int nTimeout = 0;
    @LookupPath
    protected String psPath;

    protected void initDevice() {
        this.isSimulated = RunMode.isSimulation();
        String fileName = "psid.properties";
        if (BootstrapResourceUtils.getBootstrapResource((String)fileName) == null) {
            LOG.warn((Object)("PS ID properties file (" + fileName + ") not found"));
        }
        this.props = BootstrapResourceUtils.getBootstrapProperties((String)fileName);
        if (this.ipAddr == null && !this.isSimulated) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"ipAddr", (String)"is missing");
        }
        this.fullName = "REB PS board (" + (this.isSimulated ? "simulated" : this.ipAddr) + ")";
    }

    protected void initialize() {
        try {
            this.ps.open(this.isSimulated ? "" : this.ipAddr);
            this.ps.configTemperature();
            this.psVersion = this.ps.getVersion();
            this.psType = this.ps.getType();
            this.generatePsId();
            this.setOnline(true);
            this.initSensors();
            if (this.listener != null) {
                this.listener.opened();
            }
            LOG.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        if (this.listener != null) {
            this.listener.closed();
        }
        this.psId = UNKN_PSID;
        try {
            this.ps.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer rebNum = null;
        Integer psNum = null;
        String[] flds = type.split(":");
        if (flds.length == 1) {
            if (flds[0].toUpperCase().equals("TEMP")) {
                psNum = -1;
                rebNum = 0;
            }
        } else if (flds.length == 2) {
            try {
                rebNum = Integer.valueOf(flds[0]);
                psNum = psMap.get(flds[1].toUpperCase());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (psNum == null) {
            String text = rebNum == null ? "type (REB number)" : "type (PS name)";
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)text, (Object)type);
        }
        if (psNum >= 0 && psNum != 255 && !RebPS.testChannelNumber((int)psNum, (int)hwChan)) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"hwChan", (Object)hwChan);
        }
        return new int[]{rebNum << 8 | psNum, 0};
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        try {
            if (type < 0) {
                if (hwChan >= this.ps.getNumTemperatures()) {
                    MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"hwChan", (Object)hwChan);
                }
            } else {
                int rebNum = type >> 8;
                int psNum = type & 0xFF;
                if (psNum != 255 && !this.ps.testRebNumber(rebNum)) {
                    MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"REB number", (Object)rebNum);
                }
            }
        }
        catch (Exception e) {
            this.dropChannel(id);
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            try {
                if (type < 0) {
                    value = this.ps.readTemperature(hwChan);
                } else {
                    int rebNum = type >> 8;
                    int psNum = type & 0xFF;
                    if (psNum == 255) {
                        if (rebNum >= 6) {
                            value = 0.0;
                            for (int j = 0; j < this.ps.getNumRebs(); ++j) {
                                value += this.power[j];
                            }
                        } else {
                            value = 0.0;
                            for (psNum = 0; psNum < 7; ++psNum) {
                                if (psNum == 6 || !this.ps.isPowerOn(rebNum, psNum)) continue;
                                double volts = this.ps.readChannel(rebNum, psNum, 2);
                                if (psNum == 4) {
                                    volts = this.ps.readChannel(rebNum, psNum, 0) - volts;
                                }
                                value += volts * this.ps.readChannel(rebNum, psNum, 1);
                            }
                            this.power[rebNum] = value;
                        }
                    } else if (psNum != 4 || hwChan != 4 || this.ps.isPowerOn(rebNum, psNum)) {
                        value = this.ps.readChannel(rebNum, psNum, hwChan);
                    }
                }
                this.nTimeout = 0;
            }
            catch (DriverTimeoutException e) {
                LOG.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
                if (++this.nTimeout >= 2) {
                    this.setOnline(false);
                }
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
        return value;
    }

    public boolean checkPsTripped() {
        try {
            int nReb = this.ps.getNumRebs();
            int fail = this.ps.getFailureSummary() & (1 << nReb) - 1;
            if (fail == this.lastFail) {
                return false;
            }
            this.lastFail = fail;
            if (fail == 0) {
                return false;
            }
            for (int reb = 0; reb < nReb; ++reb) {
                if ((fail & 1 << reb) == 0) continue;
                LOG.error((Object)String.format("REB PS %s tripped: failure details = 0x%08x", reb, this.ps.getFailureDetail(reb)));
            }
            return true;
        }
        catch (DriverException e) {
            return false;
        }
    }

    public RebTrippedState[] getPsTrippedStatus() {
        try {
            int nReb = this.ps.getNumRebs();
            int fail = this.ps.getFailureSummary() & (1 << nReb) - 1;
            if (fail == this.lastFail) {
                return this.lastFailArray;
            }
            this.lastFail = fail;
            RebTrippedState noTrip = new RebTrippedState(false);
            this.lastFailArray = new RebTrippedState[nReb];
            if (fail == 0) {
                for (int reb = 0; reb < nReb; ++reb) {
                    this.lastFailArray[reb] = noTrip;
                }
            } else {
                for (int reb = 0; reb < nReb; ++reb) {
                    if ((fail & 1 << reb) != 0) {
                        String tripReason = String.format("REB PS %s tripped: failure details = 0x%08x", reb, this.ps.getFailureDetail(reb));
                        LOG.error((Object)tripReason);
                        this.lastFailArray[reb] = new RebTrippedState(true, tripReason);
                        continue;
                    }
                    this.lastFailArray[reb] = noTrip;
                }
            }
            return this.lastFailArray;
        }
        catch (DriverException e) {
            return this.lastFailArray;
        }
    }

    public int[] getState() {
        int[] state = new int[this.ps.getNumRebs()];
        for (int reb = 0; reb < state.length; ++reb) {
            state[reb] = Integer.MIN_VALUE;
            try {
                if (!this.isOnline()) continue;
                state[reb] = this.ps.getPower(reb);
                continue;
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
        return state;
    }

    public double[] getDacs(boolean getHV) {
        double[] dacs = new double[this.ps.getNumRebs()];
        int psNum = getHV ? 6 : 5;
        for (int reb = 0; reb < dacs.length; ++reb) {
            dacs[reb] = Double.NaN;
            try {
                if (!this.isOnline()) continue;
                dacs[reb] = this.ps.readChannel(reb, psNum, -1);
                continue;
            }
            catch (DriverException driverException) {
                // empty catch block
            }
        }
        return dacs;
    }

    public void setBiasDac(int rebNum, double value) throws PowerException {
        try {
            this.ps.writeDac(rebNum, 6, value);
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    public void setDphiDac(int rebNum, double value) throws PowerException {
        try {
            this.ps.writeDac(rebNum, 5, value);
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    public void setPowerOn(int reb, int psNum, boolean on) throws PowerException {
        if (psNum >= 0 && psNum != 6 && (this.psType != 1 || psNum != 5)) {
            return;
        }
        try {
            if (psNum < 0) {
                this.ps.setPower(reb, on ? 1 : 0);
            } else {
                int newValue;
                if (this.psType == 1 && reb % 3 == 2) {
                    return;
                }
                int value = this.ps.getPower(reb);
                if ((value & 1) == 0) {
                    return;
                }
                int mask = 1 << psNum + 1;
                int n = newValue = on ? value | mask : value & ~mask;
                if ((mask & (value ^ newValue)) == 0) {
                    return;
                }
                this.ps.setPower(reb, newValue);
            }
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage(), (Throwable)e);
        }
    }

    public void togglePower(int reb, int psNum) throws PowerException {
        try {
            int psn = psNum < 0 ? 0 : psNum + 1;
            this.setPowerOn(reb, psNum, (this.ps.getPower(reb) >> psn & 1) == 0);
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    public void sequencePower(int reb, boolean on) throws PowerException {
        if (this.psVersion == 1) {
            this.setPowerOn(reb, -1, on);
            return;
        }
        try {
            SeqParams[] onSeq;
            if (this.psType == 1) {
                if (reb == 2) {
                    return;
                }
                onSeq = reb == 0 ? onSeqCR0 : onSeqCR1;
            } else {
                SeqParams[] seqParamsArray = onSeq = reb == 1 ? onSeqSR1 : onSeqSR02;
            }
            if (on) {
                this.ps.writeDac(reb, 6, 0.0);
                if (this.psType == 1) {
                    this.ps.writeDac(reb, 5, 4095.0);
                }
                for (SeqParams parm : onSeq) {
                    int effReb = reb + parm.rebOff;
                    int value = this.ps.getPower(effReb);
                    if ((value & 1) == 0) {
                        this.ps.setPower(effReb, value |= 1);
                    }
                    this.ps.setPower(effReb, value |= 1 << parm.psNum + 1);
                    if (this.checkPower(effReb, parm)) continue;
                    this.ps.setPower(effReb, value &= ~(1 << parm.psNum + 1));
                    throw new PowerException("REB " + effReb + " power supply " + parm.psNum + " failed to stabilize");
                }
            } else {
                this.ps.setPower(reb, this.ps.getPower(reb) & 0xFFFFFF7F & 0xFFFFFFBF);
                for (int j = onSeq.length - 1; j >= 0; --j) {
                    SeqParams parm = onSeq[j];
                    int effReb = reb + parm.rebOff;
                    int value = this.ps.getPower(effReb) & ~(1 << parm.psNum + 1);
                    this.ps.setPower(effReb, value);
                    if (value != 1) continue;
                    this.ps.setPower(effReb, 0);
                }
            }
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    public void sequencePower(boolean on) throws PowerException {
        for (int reb = 0; reb < this.ps.getNumRebs(); ++reb) {
            this.sequencePower(reb, on);
        }
    }

    public double[] readChanExtrema(int reb, PsName psName, ChanName chan) throws PowerException {
        try {
            double[] value = this.ps.readChanExtended(reb, psName.getValue(), chan.getValue());
            return new double[]{value[1], value[2]};
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    public void resetChanExtrema(int reb, PsName psName, ChanName chan) throws PowerException {
        try {
            this.ps.resetChanExtrema(reb, psName.getValue(), chan.getValue());
        }
        catch (DriverException e) {
            throw new PowerException(e.getMessage());
        }
    }

    public void setListener(Event listen) {
        this.listener = listen;
    }

    public void clearListener() {
        this.listener = null;
    }

    public int[] getErrors() {
        return new int[]{this.ps.getNumTimeout(), this.ps.getNumSeqErr()};
    }

    public RebPS getPs() {
        return this.ps;
    }

    public int getPsType() {
        return this.psType;
    }

    public int getPsVersion() {
        return this.psVersion;
    }

    public String getPsId() {
        return this.psId;
    }

    private boolean checkPower(int reb, SeqParams parms) throws PowerException {
        boolean okay = false;
        int nGood = 0;
        for (int count = 0; count < 20 && !okay; ++count) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                double voltage = this.ps.readChannel(reb, parms.psNum, 4);
                nGood = voltage >= parms.minGood && voltage <= parms.maxGood ? nGood + 1 : 0;
                okay = nGood >= 3;
                continue;
            }
            catch (DriverException e) {
                throw new PowerException(e.getMessage());
            }
        }
        return okay;
    }

    private void generatePsId() throws DriverException {
        if (this.isSimulated) {
            this.psId = "PS-SIM";
            this.psType = 0;
            return;
        }
        String serial = String.format("%016x", this.ps.getSerialNo());
        this.psId = this.props.getProperty("org.lsst.ccs.power.psid." + serial);
        if (this.psId == null) {
            if (this.ps.getNumRebs() == 3) {
                LOG.warn((Object)("Unknown PS serial number: " + serial));
                this.psId = serial.substring(5, 10);
            } else {
                this.psId = this.psType == 1 ? "CR-" : "SR-";
                try {
                    int id = Integer.valueOf(this.ipAddr.split("\\.")[3]);
                    this.psId = this.psId + String.format("%03d", id);
                }
                catch (IndexOutOfBoundsException | NumberFormatException e) {
                    this.psId = this.psId + "XXX";
                }
            }
        }
        this.psType = this.psType == -1 ? (this.psId.substring(0, 2).equals("CR") ? 1 : 0) : this.psType;
    }

    static {
        psMap.put("DIGITAL", 0);
        psMap.put("ANALOG", 1);
        psMap.put("CLOCKHI", 3);
        psMap.put("CLOCKLO", 4);
        psMap.put("DPHI", 5);
        psMap.put("HEATER", 5);
        psMap.put("HVBIAS", 6);
        psMap.put("OD", 2);
        psMap.put("POWER", 255);
        onSeqSR02 = new SeqParams[]{new SeqParams(0, 4.5, 6.0), new SeqParams(1, 6.5, 8.5), new SeqParams(4, 12.0, 17.0), new SeqParams(3, 15.0, 17.0), new SeqParams(2, 35.0, 42.0), new SeqParams(5, 7.0, 13.0)};
        onSeqSR1 = new SeqParams[]{new SeqParams(0, 4.5, 6.0), new SeqParams(1, 6.5, 8.5), new SeqParams(4, 12.0, 17.0), new SeqParams(3, 15.0, 17.0), new SeqParams(2, 35.0, 42.0)};
        onSeqCR0 = new SeqParams[]{new SeqParams(0, 4.5, 6.0), new SeqParams(1, 6.5, 8.5), new SeqParams(4, 10.0, 12.0), new SeqParams(3, 10.0, 12.0), new SeqParams(2, 35.0, 37.0), new SeqParams(0, 2, 5.0, 7.0)};
        onSeqCR1 = new SeqParams[]{new SeqParams(0, 4.5, 6.0), new SeqParams(1, 6.5, 8.5), new SeqParams(4, 10.0, 12.0), new SeqParams(3, 10.0, 12.0), new SeqParams(2, 35.0, 37.0)};
    }

    public static enum ChanName {
        VBEFLDO(0),
        VAFTLDO(2),
        IBEFLDO(1);

        int value;

        private ChanName(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static enum PsName {
        DIGITAL(0),
        ANALOG(1),
        CLOCKHI(3),
        CLOCKLO(4),
        OD(2),
        HEATER(5),
        DPHI(5);

        int value;

        private PsName(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    public static interface Event {
        public void opened();

        public void closed();
    }

    static class SeqParams {
        final int psNum;
        final int rebOff;
        final double minGood;
        final double maxGood;

        SeqParams(int psNum, double minGood, double maxGood) {
            this(psNum, 0, minGood, maxGood);
        }

        SeqParams(int psNum, int rebOff, double minGood, double maxGood) {
            this.psNum = psNum;
            this.rebOff = rebOff;
            this.minGood = minGood;
            this.maxGood = maxGood;
        }
    }
}

