/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.WinVersion$PyExposer;
import org.python.expose.ExposedType;

@ExposedType(name="sys.getwindowsversion", isBaseType=false)
class WinVersion
extends PyTuple {
    public PyObject major;
    public PyObject minor;
    public PyObject build;
    public PyObject platform;
    public PyObject service_pack;
    public static final PyType TYPE;

    private WinVersion(PyObject ... vals) {
        super(TYPE, vals);
        this.major = vals[0];
        this.minor = vals[1];
        this.build = vals[2];
        this.platform = vals[3];
        this.service_pack = vals[4];
    }

    public static WinVersion getWinVersion() {
        try {
            String sysver = PySystemState.getSystemVersionString();
            String[] sys_ver = sysver.split("\\.");
            int major = Integer.parseInt(sys_ver[0]);
            int minor = Integer.parseInt(sys_ver[1]);
            int build2 = Integer.parseInt(sys_ver[2]);
            if (major > 6) {
                major = 6;
                minor = 2;
                build2 = 9200;
            } else if (major == 6 && minor > 2) {
                minor = 2;
                build2 = 9200;
            }
            return new WinVersion(Py.newInteger(major), Py.newInteger(minor), Py.newInteger(build2), Py.newInteger(2), Py.EmptyString);
        }
        catch (Exception e) {
            return new WinVersion(Py.EmptyString, Py.EmptyString, Py.EmptyString, Py.EmptyString, Py.EmptyString);
        }
    }

    @Override
    public PyString __repr__() {
        return (PyString)Py.newString(TYPE.fastGetName() + "(major=%r, minor=%r, build=%r, " + "platform=%r, service_pack=%r)").__mod__(this);
    }

    static {
        PyType.addBuilder(WinVersion.class, new WinVersion$PyExposer());
        TYPE = PyType.fromClass(WinVersion.class);
    }
}

