import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.bootstrap.BootstrapResourceUtils
import org.lsst.ccs.subsystem.power.PowerControl
import org.lsst.ccs.subsystem.power.BK1696Device
import org.lsst.ccs.subsystem.power.CpfeDevice
import org.lsst.ccs.subsystem.power.RebPower
import org.lsst.ccs.subsystem.power.SimPowerDevice
import org.lsst.ccs.subsystem.power.RebPsDevice
import org.lsst.ccs.subsystem.power.RebPowerSupplyMain
import org.lsst.ccs.subsystem.power.PowerSupplyConfiguration;
import org.lsst.ccs.subsystem.power.RebPowerSupplyWiring;
import org.lsst.ccs.subsystem.power.RebPowerSupplyNode;
import org.lsst.ccs.subsystem.power.CornerRaftRebPowerSupplyNode;
import org.lsst.ccs.monitor.Channel


RebPowerSupplyWiring wiring = new RebPowerSupplyWiring(buildProperties());

CCSBuilder builder = ["rebpower"]

builder.main(RebPowerSupplyMain) {

    for ( PowerSupplyConfiguration powerSupply : wiring.getRebPowerSuppyConfigurations() ) {
        def psName = powerSupply.getName();
        def psIp = powerSupply.getIp();

        "RebPS/${psName}" (RebPsDevice, ipAddr:"$psIp" ) {
            for (int i = 0; i < 7; i++) {
                "BoardTemp$i" (Channel, description: "Board temperature $i", units: "\u00b0C",
                               hwChan: i, type: "TEMP")
            }  
        }
    }

   for ( String reb : wiring.getRebsList() ) {

        PowerSupplyConfiguration powerSupplyConfig = wiring.getPowerSupplyConfigurationForReb("$reb");

        int i = wiring.getPowerSupplyChannelForReb("$reb");

        boolean isCornerRaft = powerSupplyConfig.isCornerRaft();

        "${reb}" ( isCornerRaft ? CornerRaftRebPowerSupplyNode : RebPowerSupplyNode, powerSupplyConfiguration:powerSupplyConfig, channel:i) {

            def powerSupply = "RebPS/"+powerSupplyConfig.getName();

            def psn = "digital"

            "${psn}/VbefLDO" (Channel, description: "$reb $psn PS\\Voltage before LDO", units: "Volts",
                                     devcName: "$powerSupply", hwChan: 0, type: "$i:$psn")

            "${psn}/IbefLDO" (Channel, description: "Current before LDO", format: ".1f", units: "mA",
                                     devcName: "$powerSupply", hwChan: 1, type: "$i:$psn", scale: 1000)

            "${psn}/VaftLDO" (Channel, description: "Voltage after LDO", units: "Volts",
                                     devcName: "$powerSupply", hwChan: 2, type: "$i:$psn")

            "${psn}/IaftLDO" (Channel, description: "Current after LDO", format: ".1f", units: "mA",
                                     devcName: "$powerSupply", hwChan: 3, type: "$i:$psn", scale: 1000)

            "${psn}/VaftSwch" (Channel, description: "Voltage after switch", units: "Volts",
                                      devcName: "$powerSupply", hwChan: 4, type: "$i:$psn")

            psn = "analog"

            "${psn}/VbefLDO" (Channel, description: "$reb $psn PS\\Voltage before LDO", units: "Volts",
                                     devcName: "$powerSupply", hwChan: 0, type: "$i:$psn")

            "${psn}/IbefLDO" (Channel, description: "Current before LDO", format: ".1f", units: "mA",
                                     devcName: "$powerSupply", hwChan: 1, type: "$i:$psn", scale: 1000)

            "${psn}/VaftLDO" (Channel, description: "Voltage after LDO", units: "Volts",
                                     devcName: "$powerSupply", hwChan: 2, type: "$i:$psn")

            "${psn}/IaftLDO" (Channel, description: "Current after LDO", format: ".1f", units: "mA",
                                     devcName: "$powerSupply", hwChan: 3, type: "$i:$psn", scale: 1000)

            "${psn}/VaftSwch" (Channel, description: "Voltage after switch", units: "Volts",
                                      devcName: "$powerSupply", hwChan: 4, type: "$i:$psn")

            psn = "OD"

            "${psn}/VbefLDO" (Channel, description: "$reb $psn PS\\Voltage before LDO", units: "Volts",
                                     devcName: "$powerSupply", hwChan: 0, type: "$i:$psn")

            "${psn}/IbefLDO" (Channel, description: "Current before LDO", format: ".1f", units: "mA",
                                     devcName: "$powerSupply", hwChan: 1, type: "$i:$psn", scale: 1000)

            "${psn}/VaftLDO" (Channel, description: "Voltage after LDO", units: "Volts",
                                     devcName: "$powerSupply", hwChan: 2, type: "$i:$psn")

            "${psn}/VaftLDO2" (Channel, description: "Voltage after LDO2", units: "Volts",
                                      devcName: "$powerSupply", hwChan: 5, type: "$i:$psn")

            "${psn}/IaftLDO" (Channel, description: "Current after LDO", format: ".1f", units: "mA",
                                     devcName: "$powerSupply", hwChan: 3, type: "$i:$psn", scale: 1000)

            "${psn}/VaftSwch" (Channel, description: "Voltage after switch", units: "Volts",
                                      devcName: "$powerSupply", hwChan: 4, type: "$i:$psn")

            psn = "clockhi"

            "${psn}/VbefLDO" (Channel, description: "$reb $psn PS\\Voltage before LDO", units: "Volts",
                                     devcName: "$powerSupply", hwChan: 0, type: "$i:$psn")

            "${psn}/IbefLDO" (Channel, description: "Current before LDO", format: ".1f", units: "mA",
                                     devcName: "$powerSupply", hwChan: 1, type: "$i:$psn", scale: 1000)

            "${psn}/VaftLDO" (Channel, description: "Voltage after LDO", units: "Volts",
                                     devcName: "$powerSupply", hwChan: 2, type: "$i:$psn")

            "${psn}/IaftLDO" (Channel, description: "Current after LDO", format: ".1f", units: "mA",
                                     devcName: "$powerSupply", hwChan: 3, type: "$i:$psn", scale: 1000)

            "${psn}/VaftSwch" (Channel, description: "Voltage after switch", units: "Volts",
                                      devcName: "$powerSupply", hwChan: 4, type: "$i:$psn")

            psn = "clocklo"

            "${psn}/VbefLDO" (Channel, description: "$reb $psn PS\\Voltage before LDO", units: "Volts",
                                     devcName: "$powerSupply", hwChan: 0, type: "$i:$psn")

            "${psn}/IbefLDO" (Channel, description: "Current before LDO", format: ".1f", units: "mA",
                                     devcName: "$powerSupply", hwChan: 1, type: "$i:$psn", scale: 1000)

            "${psn}/VaftLDO" (Channel, description: "Voltage after LDO", units: "Volts",
                                     devcName: "$powerSupply", hwChan: 2, type: "$i:$psn")

            "${psn}/VaftLDO2" (Channel, description: "Voltage after LDO2", units: "Volts",
                                      devcName: "$powerSupply", hwChan: 5, type: "$i:$psn")

            "${psn}/IaftLDO" (Channel, description: "Current after LDO", format: ".1f", units: "mA",
                                     devcName: "$powerSupply", hwChan: 3, type: "$i:$psn", scale: 1000)

            "${psn}/VaftSwch" (Channel, description: "Voltage after switch", units: "Volts",
                                      devcName: "$powerSupply", hwChan: 4, type: "$i:$psn")




            if ( isCornerRaft ) {
                int heaterChannel = wiring.getPowerSupplyChannelForRebHeater("$reb");

                if ( heaterChannel >= 0 ) {
                    psn = "heater"
                    apsn = "digital"
                    

                    "${psn}/VbefLDO" (Channel, description: "$reb $psn PS\\Voltage before LDO", units: "Volts",
                                             devcName: "$powerSupply", hwChan: 0, type: "$heaterChannel:$apsn")

                    "${psn}/IbefLDO" (Channel, description: "Current before LDO", format: ".1f", units: "mA",
                                             devcName: "$powerSupply", hwChan: 1, type: "$heaterChannel:$apsn", scale: 1000)

                    "${psn}/VaftLDO" (Channel, description: "Voltage after LDO", units: "Volts",
                                             devcName: "$powerSupply", hwChan: 2, type: "$heaterChannel:$apsn")

                    "${psn}/IaftLDO" (Channel, description: "Current after LDO", format: ".1f", units: "mA",
                                             devcName: "$powerSupply", hwChan: 3, type: "$heaterChannel:$apsn", scale: 1000)

                    "${psn}/VaftSwch" (Channel, description: "Voltage after switch", units: "Volts",
                                              devcName: "$powerSupply", hwChan: 4, type: "$heaterChannel:$apsn")
                }


                psn = "dphi"

                "${psn}/VbefLDO" (Channel, description: "$reb $psn PS\\Voltage before LDO", units: "Volts",
                                         devcName: "$powerSupply", hwChan: 0, type: "$i:$psn")

                "${psn}/IbefLDO" (Channel, description: "Current before LDO", format: ".1f", units: "mA",
                                         devcName: "$powerSupply", hwChan: 1, type: "$i:$psn", scale: 1000)

                "${psn}/VaftLDO" (Channel, description: "Voltage after LDO", units: "Volts",
                                         devcName: "$powerSupply", hwChan: 2, type: "$i:$psn")

                "${psn}/IaftLDO" (Channel, description: "Current after LDO", format: ".1f", units: "mA",
                                         devcName: "$powerSupply", hwChan: 3, type: "$i:$psn", scale: 1000)

                "${psn}/VaftSwch" (Channel, description: "Voltage after switch", units: "Volts",
                                          devcName: "$powerSupply", hwChan: 4, type: "$i:$psn")

            } else {

                psn = "heater"

                "${psn}/VbefLDO" (Channel, description: "$reb $psn PS\\Voltage before LDO", units: "Volts",
                                         devcName: "$powerSupply", hwChan: 0, type: "$i:$psn")

                "${psn}/IbefLDO" (Channel, description: "Current before LDO", format: ".1f", units: "mA",
                                         devcName: "$powerSupply", hwChan: 1, type: "$i:$psn", scale: 1000)

                "${psn}/VaftLDO" (Channel, description: "Voltage after LDO", units: "Volts",
                                         devcName: "$powerSupply", hwChan: 2, type: "$i:$psn")

                "${psn}/IaftLDO" (Channel, description: "Current after LDO", format: ".1f", units: "mA",
                                        devcName: "$powerSupply", hwChan: 3, type: "$i:$psn", scale: 1000)

                "${psn}/VaftSwch" (Channel, description: "Voltage after switch", units: "Volts",
                                        devcName: "$powerSupply", hwChan: 4, type: "$i:$psn")
            }

            psn = "hvbias"

            "${psn}/VbefSwch" (Channel, description: "$reb $psn PS\\Voltage before switch", units: "Volts",
                                    devcName: "$powerSupply", hwChan: 0, type: "$i:$psn")

            "${psn}/IbefSwch" (Channel, description: "Current before switch", format: ".3f", units: "mA",
                                    devcName: "$powerSupply", hwChan: 1, type: "$i:$psn", scale: 1000)

            "Power"           (Channel, description: "$reb all PSs\\Total power", units: "Watts",
                                    devcName: "$powerSupply", hwChan: 0, type: "$i:POWER")

        }
    }

 }
