/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.commanddispatcher;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import org.freehep.util.commanddispatcher.BooleanCommandState;
import org.freehep.util.commanddispatcher.BooleanCommandTarget;
import org.freehep.util.commanddispatcher.CommandSource;
import org.freehep.util.commanddispatcher.CommandTarget;
import org.freehep.util.commanddispatcher.SimpleCommandTarget;

public class CommandSourceAdapter
implements CommandSource,
ActionListener,
BooleanCommandState,
Observer {
    private AbstractButton m_button;
    private CommandTarget m_target;
    private boolean m_bool;

    public CommandSourceAdapter(AbstractButton button) {
        this.m_button = button;
        this.m_button.addActionListener(this);
        this.m_button.setEnabled(false);
        this.m_bool = this.m_button instanceof JCheckBoxMenuItem || this.m_button instanceof JRadioButtonMenuItem || this.m_button instanceof JToggleButton;
    }

    @Override
    public String getCommand() {
        return this.m_button.getActionCommand();
    }

    @Override
    public void setEnabled(boolean state) {
        this.m_button.setEnabled(state);
    }

    @Override
    public void setSelected(boolean selected) {
        this.m_button.setSelected(selected);
    }

    @Override
    public boolean setTarget(CommandTarget target) {
        if (this.m_bool && target instanceof SimpleCommandTarget) {
            return false;
        }
        if (!this.m_bool && target instanceof BooleanCommandTarget) {
            return false;
        }
        this.m_target = target;
        this.m_target.enable(this);
        return true;
    }

    @Override
    public CommandTarget getTarget() {
        return this.m_target;
    }

    @Override
    public void setText(String text) {
        if (!this.m_button.getText().equals("")) {
            this.m_button.setText(text);
        }
    }

    @Override
    public void setToolTipText(String text) {
        this.m_button.setToolTipText(text);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.m_bool) {
            ((BooleanCommandTarget)this.m_target).invoke(this.m_button.isSelected());
        } else {
            ((SimpleCommandTarget)this.m_target).invoke();
        }
    }

    @Override
    public void clearTarget() {
        this.m_target = null;
        this.setEnabled(false);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.m_target.enable(this);
    }
}

