/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.power.distribution;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.lsst.ccs.Agent;
import org.lsst.ccs.StateChangeListener;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupPath;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.drivers.apcpdu.APC7900;
import org.lsst.ccs.drivers.apcpdu.APC7900B;
import org.lsst.ccs.drivers.apcpdu.APC7900Series;
import org.lsst.ccs.drivers.apcpdu.APC7900Sim;
import org.lsst.ccs.drivers.ascii.Session;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.devices.power.distribution.PduOutlet;
import org.lsst.ccs.subsystem.common.devices.power.distribution.state.PduOutletState;
import org.lsst.ccs.subsystem.common.devices.power.distribution.state.PduState;
import org.lsst.ccs.utilities.logging.Logger;

public class APC7900Device
extends Device
implements StateChangeListener,
ClearAlertHandler {
    public static final int TYPE_POWER = 1;
    public static final int CHAN_CURRENT = 0;
    public static final int CHAN_POWER = 1;
    static final Map<String, Integer> typeMap = new HashMap<String, Integer>();
    @ConfigurationParameter(isFinal=true)
    private String type = "APC7900";
    @ConfigurationParameter(isFinal=true)
    protected String node;
    @ConfigurationParameter(isFinal=true)
    protected int numberOfOutlets = 8;
    @ConfigurationParameter(isFinal=true)
    protected List<String> outlets = new ArrayList<String>();
    @ConfigurationParameter(isFinal=true)
    protected boolean updateNamesInPDU = false;
    @ConfigurationParameter
    protected int maxReadFailures = 3;
    private int readFailures = 0;
    private final List<PduOutlet> listOfOutlets = new ArrayList<PduOutlet>();
    protected Map<String, PduOutlet> mapOfOutlets = new HashMap<String, PduOutlet>();
    private final Map<PduOutlet, PduOutletState> intendedOutletStates = new ConcurrentHashMap<PduOutlet, PduOutletState>();
    private final Set<PduOutlet> outletsInAlertState = new CopyOnWriteArraySet<PduOutlet>();
    private final Object intendedOutletStateLock = new Object();
    String user = "apc";
    String passwd = "apc";
    private static final Logger LOG;
    @Deprecated
    protected final Logger sLog = LOG;
    private APC7900Series pdu;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Agent a;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    private ComponentLookup componentLookup;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    protected AlertService alertService;
    @LookupPath
    private String path;

    public void build() {
        super.build();
        if (!this.outlets.isEmpty() && this.outlets.size() != this.numberOfOutlets) {
            throw new IllegalArgumentException("The size of the provided outlets (" + this.outlets.size() + ") must match the provided numberOfOutlets " + this.numberOfOutlets);
        }
        this.componentLookup = this.a.getComponentLookup();
        ComponentNode thisNode = this.componentLookup.getComponentNodeForObject((Object)this);
        for (int i = 1; i <= this.numberOfOutlets; ++i) {
            PduOutlet outlet = new PduOutlet(i);
            this.listOfOutlets.add(outlet);
            this.componentLookup.addComponentNodeToLookup(thisNode, new ComponentNode(outlet.getName(), (Object)outlet));
        }
        this.agentPropertiesService.setAgentProperty("HasPdu", "true");
        String components = ((AgentPropertiesService)this.a.getAgentService(AgentPropertiesService.class)).getAgentProperty("Pdu_Components");
        if (components == null) {
            components = "";
        }
        if (!components.isEmpty()) {
            components = components + ",";
        }
        components = components + this.path;
        this.agentPropertiesService.setAgentProperty("Pdu_Components", components);
    }

    public void init() {
        if (null != this.type) {
            switch (this.type) {
                case "APC7900": {
                    this.pdu = new APC7900();
                    break;
                }
                case "APC7900B": {
                    this.pdu = new APC7900B();
                    break;
                }
                case "APC7900Sim": {
                    this.pdu = new APC7900Sim(this.outlets);
                    break;
                }
            }
        }
        if (this.outlets.isEmpty() || this.outlets.size() != this.numberOfOutlets) {
            throw new RuntimeException("Configuration parameter \"outlets\" must be specified");
        }
        for (int i = 0; i < this.numberOfOutlets; ++i) {
            PduOutlet outlet = this.listOfOutlets.get(i);
            outlet.setName(this.outlets.get(i));
            this.mapOfOutlets.put(outlet.getName(), outlet);
            ComponentNode n = this.componentLookup.getComponentNodeForObject((Object)outlet);
            this.componentLookup.setComponentNodeName(n, outlet.getName());
        }
        this.stateService.registerState(PduState.class, "The state of the Pdu", (Object)this);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{PduState.NOTCONFIGURED});
        for (PduOutlet outlet : this.mapOfOutlets.values()) {
            this.stateService.registerState(PduOutletState.class, "The state of a Pdu Outlet: ON/OFF", (Object)outlet);
        }
        super.init();
    }

    public void start() {
        this.stateService.addStateChangeListener((StateChangeListener)this, new Class[]{PduOutletState.class, PduState.class});
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        if (alert.getAlertId().equals("Pdu_Alert") || alert.getAlertId().equals("Pdu_Outlet_Alert")) {
            return alertState != AlertState.NOMINAL ? ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT : ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    protected void initDevice() {
        if (this.node == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"node", (String)"is not specified");
        }
        this.fullName = "APC7900 PDU (" + this.node + ")";
    }

    protected void initialize() {
        try {
            this.pdu.open(Session.ConnType.TELNET, this.node, this.user, this.passwd);
            Map outNumMap = this.pdu.getOutletNumberMap();
            if (outNumMap.size() != this.numberOfOutlets) {
                throw new RuntimeException("Unexpected number of outlets: " + outNumMap.size() + " it should have been " + this.numberOfOutlets + ".");
            }
            StringBuilder sb = new StringBuilder("Name mismatch detected for outlets: ");
            boolean nameMismatchDetected = false;
            for (String outletName : outNumMap.keySet()) {
                int index;
                PduOutlet outlet;
                String providedOutletName;
                if (outletName.equals(providedOutletName = (outlet = this.listOfOutlets.get((index = ((Integer)outNumMap.get(outletName)).intValue()) - 1)).getName())) continue;
                if (this.updateNamesInPDU) {
                    LOG.warning((Object)("Updated the name of outlet " + index + " to " + providedOutletName + " (was " + outletName + ")"));
                    this.pdu.setOutletName(index, providedOutletName);
                    continue;
                }
                nameMismatchDetected = true;
                sb.append(index).append(") PDU name: ").append(outletName).append(" from configuration: ").append(providedOutletName);
            }
            if (nameMismatchDetected) {
                throw new RuntimeException(sb.toString());
            }
            this.initSensors();
            this.setOnline(true);
            this.stateService.updateAgentComponentState((Object)this, new Enum[]{PduState.OK});
            LOG.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.pdu.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{PduState.NOTCONFIGURED});
    }

    public void stateChanged(Object changedObj, Enum newState, Enum oldState) {
        if (changedObj == this) {
            this.alertService.raiseAlert(new Alert("Pdu_Alert", "PDU problem"), newState != PduState.OK ? AlertState.ALARM : AlertState.NOMINAL, "PDU " + this.getName() + " is in state " + newState);
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        int index = 0;
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"channel type", (Object)type);
        }
        if (hwChan != 0 && hwChan != 1) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"hardware channel", (Object)hwChan);
        }
        return new int[]{iType | index << 16, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = 0.0;
        switch (type & 0xFFFF) {
            case 1: {
                try {
                    value = hwChan == 1 ? this.pdu.readPower() : this.pdu.readCurrent()[0];
                    this.readFailures = 0;
                    break;
                }
                catch (DriverException e) {
                    ++this.readFailures;
                    if (this.readFailures >= this.maxReadFailures) {
                        LOG.error((Object)("Error reading power/current value: " + (Object)((Object)e)));
                        this.setOnline(false);
                        break;
                    }
                    LOG.fine((Object)("Failed to read APC Device (" + this.readFailures + ")"));
                }
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readChannelGroup() {
        Object object = this.intendedOutletStateLock;
        synchronized (object) {
            try {
                this.verifyOutletsIntendedStates(this.pdu.getOutletOnStateMap());
            }
            catch (DriverException e) {
                LOG.warning((Object)"Exception in readChannelGroup", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOutletsIntendedStates(Map<String, Boolean> states) throws DriverException {
        boolean needsToRaiseAlert = false;
        StateBundle sb = new StateBundle(new Enum[0]);
        Object object = this.intendedOutletStateLock;
        synchronized (object) {
            for (Map.Entry<String, Boolean> e : states.entrySet()) {
                PduOutletState state;
                String outletName = e.getKey();
                PduOutlet outlet = this.mapOfOutlets.get(outletName);
                PduOutletState pduOutletState = state = e.getValue() != false ? PduOutletState.ON : PduOutletState.OFF;
                if (state != this.getIntendedOutletState(outlet, state)) {
                    if (this.outletsInAlertState.add(outlet)) {
                        needsToRaiseAlert = true;
                    }
                } else if (this.outletsInAlertState.remove(outlet)) {
                    needsToRaiseAlert = true;
                }
                sb.setComponentState(this.componentLookup.getComponentNodeForObject((Object)outlet).getPath(), new Enum[]{state});
            }
        }
        this.stateService.updateAgentState(sb);
        if (needsToRaiseAlert) {
            String cause = null;
            AlertState alertState = null;
            if (this.outletsInAlertState.size() > 0) {
                cause = "Outlets in inconsistent states: ";
                for (PduOutlet o : this.outletsInAlertState) {
                    cause = cause + o.getName() + " ";
                }
                alertState = AlertState.ALARM;
            } else {
                cause = "All outlets are in the intended state";
                alertState = AlertState.NOMINAL;
            }
            this.alertService.raiseAlert(new Alert("Pdu_Outlet_Alert", "Outlet inconsistent state"), alertState, cause);
        }
    }

    @Command(name="disable", description="Disable the connection to the PDU")
    public void disable() {
        super.disable();
        this.setOnline(false);
    }

    @Command(name="enable", description="Enable the connection to the PDU")
    public void enable() {
        super.enable();
    }

    @Command(name="getOutletNames", description="Get the list of outlet names")
    public List<String> getOutletNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (PduOutlet outlet : this.listOfOutlets) {
            result.add(outlet.getName());
        }
        return result;
    }

    @Command(name="getOutletOnStateMap", description="Get the map of outlet on states")
    public Map<String, Boolean> getOutletOnStateMap() throws DriverException {
        return this.pdu.getOutletOnStateMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="outletOn", description="Turn outlet on")
    public void outletOn(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        PduOutlet outlet = this.mapOfOutlets.get(name);
        if (outlet == null) {
            throw new IllegalArgumentException("Outlet name: " + name + " is illegal. The chosen outlet does not exist.");
        }
        Object object = this.intendedOutletStateLock;
        synchronized (object) {
            this.pdu.delayedOutletOn(this.getOutletNumber(name));
            this.setIntendedOutletState(outlet, PduOutletState.ON);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="outletOff", description="Turn outlet off")
    public void outletOff(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        PduOutlet outlet = this.mapOfOutlets.get(name);
        if (outlet == null) {
            throw new IllegalArgumentException("Outlet name: " + name + " is illegal. The chosen outlet does not exist.");
        }
        Object object = this.intendedOutletStateLock;
        synchronized (object) {
            this.pdu.delayedOutletOff(this.getOutletNumber(name));
            this.setIntendedOutletState(outlet, PduOutletState.OFF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="forceOutletOn", description="Force outlet to turn on")
    public void forceOutletOn(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        PduOutlet outlet = this.mapOfOutlets.get(name);
        if (outlet == null) {
            throw new IllegalArgumentException("Outlet name: " + name + " is illegal. The chosen outlet does not exist.");
        }
        Object object = this.intendedOutletStateLock;
        synchronized (object) {
            this.pdu.setOutletOn(this.getOutletNumber(name));
            this.setIntendedOutletState(outlet, PduOutletState.ON);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="forceOutletOff", description="Force outlet to turn off")
    public void forceOutletOff(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        PduOutlet outlet = this.mapOfOutlets.get(name);
        if (outlet == null) {
            throw new IllegalArgumentException("Outlet name: " + name + " is illegal. The chosen outlet does not exist.");
        }
        Object object = this.intendedOutletStateLock;
        synchronized (object) {
            this.pdu.setOutletOff(this.getOutletNumber(name));
            this.setIntendedOutletState(outlet, PduOutletState.OFF);
        }
    }

    @Command(name="causeUnintendedOutletFlipOfState", description="Cause an unintended state transition which raises an alert.", simulation=true)
    public void causeUnintendedOutletFlipOfState(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        PduOutlet outlet = this.mapOfOutlets.get(name);
        if (outlet == null) {
            throw new IllegalArgumentException("Outlet name: " + name + " is illegal. The chosen outlet does not exist.");
        }
        if (this.isOutletOn(name)) {
            this.pdu.setOutletOff(outlet.getIndex());
        } else {
            this.pdu.setOutletOn(outlet.getIndex());
        }
    }

    @Command(name="causePDUFailure", description="Cause a PDU failure.", simulation=true)
    public void causePDUFailure() throws DriverException {
        this.setOnline(false);
    }

    @Command(name="isOutletOn", description="Get whether outlet is on")
    public boolean isOutletOn(@Argument(name="name", description="Outlet name") String name) throws DriverException {
        return this.pdu.isOutletOn(this.getOutletNumber(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(name="setOutletState", description="Set the outlet state to a given OutletState")
    public void setOutletState(@Argument(allowedValueProvider="getOutletNames", name="name", description="Outlet name") String name, @Argument(name="state", description="The desired PduOutletState") PduOutletState state, @Argument(name="force", description="true to force the state change", defaultValue="false") boolean force) throws DriverException {
        PduOutlet outlet = this.mapOfOutlets.get(name);
        if (outlet == null) {
            throw new IllegalArgumentException("Outlet name: " + name + " is illegal. The chosen outlet does not exist.");
        }
        Object object = this.intendedOutletStateLock;
        synchronized (object) {
            if (force) {
                if (state == PduOutletState.OFF) {
                    this.pdu.setOutletOff(name);
                } else {
                    this.pdu.setOutletOn(name);
                }
            } else if (state == PduOutletState.OFF) {
                this.pdu.delayedOutletOff(name);
            } else {
                this.pdu.delayedOutletOn(name);
            }
            this.setIntendedOutletState(outlet, state);
        }
    }

    int getOutletNumber(String name) throws DriverException {
        for (PduOutlet outlet : this.listOfOutlets) {
            if (!outlet.getName().equals(name)) continue;
            return outlet.getIndex();
        }
        throw new DriverException("Invalid outlet name " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIntendedOutletState(PduOutlet outlet, PduOutletState intendedState) throws DriverException {
        Object object = this.intendedOutletStateLock;
        synchronized (object) {
            this.intendedOutletStates.put(outlet, intendedState);
            this.stateService.updateAgentComponentState((Object)outlet, new Enum[]{intendedState});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PduOutletState getIntendedOutletState(PduOutlet outlet, PduOutletState currentState) {
        Object object = this.intendedOutletStateLock;
        synchronized (object) {
            PduOutletState intendedState = this.intendedOutletStates.getOrDefault(outlet, currentState);
            this.intendedOutletStates.put(outlet, intendedState);
            return intendedState;
        }
    }

    static {
        typeMap.put("POWER", 1);
        LOG = Logger.getLogger((String)APC7900Device.class.getName());
    }
}

