/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.devices.dataforth;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.commons.annotations.LookupName;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.dataforth.Maq20Discrete;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.common.devices.dataforth.Maq20Device;

public class Maq20DiscControl
implements HasLifecycle {
    @LookupName
    protected String name;
    @LookupField(strategy=LookupField.Strategy.ANCESTORS)
    protected Maq20Device maqDevc;
    private Integer modIndex;
    private static final Logger LOG = Logger.getLogger(Maq20DiscControl.class.getName());
    private Maq20Device.ModuleData modData;
    private boolean haveError = false;

    public void init() {
        if (this.modIndex == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "modIndex", "not specified");
        }
        this.modData = this.maqDevc.getModuleData(this.modIndex);
        if (this.modData == null) {
            ErrorUtils.reportConfigError(LOG, this.name, "modIndex (" + this.modIndex + ")", "specifies non-existent module");
        }
        if (this.modData.modDef.opType != 2) {
            ErrorUtils.reportConfigError(LOG, this.name, "modIndex (" + this.modIndex + ")", "specifies non-discrete module");
        }
    }

    public void setLineOn(int chan, boolean on) throws DriverException {
        this.getDisc().writeDisc(chan, on ? 0 : 1);
    }

    public Boolean isLineOn(int chan) {
        Boolean on;
        block2: {
            on = null;
            try {
                on = this.getDisc().readDiscOut(chan) == 0;
                this.haveError = false;
            }
            catch (DriverException e) {
                if (this.haveError) break block2;
                LOG.log(Level.SEVERE, "Error reading channel {0} state: {1}", new Object[]{chan, e});
                this.haveError = true;
            }
        }
        return on;
    }

    private Maq20Discrete getDisc() throws DriverException {
        if (this.modData.maqDisc == null) {
            throw new DriverException("Connection not open");
        }
        return this.modData.maqDisc;
    }
}

