/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.Visitproc;

public class PyCallIter
extends PyIterator {
    private PyObject callable;
    private PyObject sentinel;

    public PyCallIter(PyObject callable, PyObject sentinel) {
        if (!callable.isCallable()) {
            throw Py.TypeError("iter(v, w): v must be callable");
        }
        this.callable = callable;
        this.sentinel = sentinel;
    }

    @Override
    public PyObject __iternext__() {
        PyObject result2;
        if (this.callable == null) {
            return null;
        }
        try {
            result2 = this.callable.__call__();
        }
        catch (PyException exc) {
            if (exc.match(Py.StopIteration)) {
                this.callable = null;
                this.stopException = exc;
                return null;
            }
            throw exc;
        }
        if (result2._eq(this.sentinel).__nonzero__()) {
            this.callable = null;
            return null;
        }
        return result2;
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retValue = super.traverse(visit, arg);
        if (retValue != 0) {
            return retValue;
        }
        if (this.callable != null && (retValue = visit.visit(this.callable, arg)) != 0) {
            return retValue;
        }
        return this.sentinel != null ? visit.visit(this.sentinel, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.callable || ob == this.sentinel || super.refersDirectlyTo(ob));
    }
}

