/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.logging.Level;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.subsystem.power.PowerSupplyConfiguration;
import org.lsst.ccs.subsystem.power.RebPowerSupplyNode;
import org.lsst.ccs.subsystem.power.constants.RebPsEnum;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.states.RebPowerState;

public class CornerRaftRebPowerSupplyNode
extends RebPowerSupplyNode {
    @ConfigurationParameter
    double dphi;

    public CornerRaftRebPowerSupplyNode(PowerSupplyConfiguration powerSupplyConfiguration, int channel) {
        super(powerSupplyConfiguration, channel);
    }

    @ConfigurationParameterChanger(propertyName="dphi")
    public void setDphi(double dphi) {
        try {
            this.powerSupplyDevice.setDphiDac(this.channel, dphi);
            this.dphi = dphi;
        }
        catch (PowerException ex) {
            LOG.log(Level.WARNING, "Could not set the HVBias DAC value", ex);
            throw new RuntimeException(ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turns on the dphi bias to the configuration value", autoAck=false)
    public void dphiOn() throws PowerException {
        this.agent.helper().precondition(this.agentStateService.isComponentInState(this.rebPath, (Enum)RebPowerState.ON), "The Reb main power must be ON.", new Object[0]).enterFaultOnException(true).action(() -> {
            this.powerSupplyDevice.setPowerOn(this.channel, RebPsEnum.DPHI.getNumber(), true);
            this.powerSupplyDevice.setDphiDac(this.channel, this.dphi);
        });
    }

    @Command(type=Command.CommandType.ACTION, description="Turns off the dphi bias")
    public void dphiOff() throws PowerException {
        this.powerSupplyDevice.setPowerOn(this.channel, RebPsEnum.DPHI.getNumber(), false);
    }
}

