import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.drivers.auxelex.Bfr
import org.lsst.ccs.drivers.auxelex.ComCamPdu24VC
import org.lsst.ccs.drivers.auxelex.ComCamPdu24VD
import org.lsst.ccs.drivers.auxelex.Pdu5V
import org.lsst.ccs.drivers.auxelex.ComCamPdu48V
import org.lsst.ccs.subsystem.power.PathFinderQuadBox
import org.lsst.ccs.subsystem.power.BfrDevice
import org.lsst.ccs.subsystem.power.Pdu5vDevice
import org.lsst.ccs.subsystem.power.ComCamPdu24vcDevice
import org.lsst.ccs.subsystem.power.ComCamPdu24vdDevice
import org.lsst.ccs.subsystem.power.ComCamPdu48vDevice
import org.lsst.ccs.subsystem.power.RebBulkPsDevice
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.monitor.Page

CCSBuilder builder = ["pathfinder-quadbox"]

builder.main (PathFinderQuadBox) {

    BFR (BfrDevice) {

        Protection_I (Channel, description: "Protection system current", units: "mA", format: ".1f",
                      hwChan:Bfr.SENSOR_PROT, scale: 1000.0)

        Clean_5_24V_I (Channel, description: "Clean 5 and 24V current", units: "mA", format: ".1f",
                       hwChan:Bfr.SENSOR_PWS_20_21, scale: 1000.0)

        Dirty_24V_I (Channel, description: "Dirty 24V current", units: "mA", format: ".1f",
                     hwChan:Bfr.SENSOR_PWS_3, scale: 1000.0)

        Dirty_48V_I (Channel, description: "Dirty 48V current", units: "mA", format: ".1f",
                     hwChan:Bfr.SENSOR_PWS_1, scale: 1000.0)

        Dirty_28V_I (Channel, description: "Dirty 28V current", units: "mA", format: ".1f",
                     hwChan:Bfr.SENSOR_PWS_4, scale: 1000.0)

        Heater_I (Channel, description: "Heater current", units: "mA", format: ".1f",
                  hwChan:Bfr.SENSOR_HTRS, scale: 1000.0)

    }

    PDU_5V (Pdu5vDevice) {


    }

    PDU_24VC (ComCamPdu24vcDevice) {
        
        "24VC_Main_V" (Channel, description: "24V Clean PDU main voltage", units: "Volts", format: ".2f",
                       type:"MAINVOLT")

        "24VC_Main_I" (Channel, description: "24V Clean PDU main current", units: "mA", format: ".1f",
                       type:"MAINCURR", scale: 1000.0)

        "24VC_Main_T" (Channel, description: "24V Clean PDU main temperature", units: "\u00b0C", format: ".1f",
                       type:"MAINTEMP")

        "24VC_Board_T" (Channel, description: "24V Clean PDU board temperature", units: "\u00b0C", format: ".1f",
                        type:"BOARDTEMP")

        "24VC_FPGA_T" (Channel, description: "24V Clean PDU FPGA temperature", units: "\u00b0C", format: ".1f",
                       type:"FPGATEMP")

        Body_Purge_V (Channel, description: "Body purge voltage", units: "Volt", format: ".2f",
                      hwChan:ComCamPdu24VC.CHAN_J12, type:"VOLTAGE")

        Body_Purge_I (Channel, description: "Body purge current", units: "mA", format: ".1f",
                      hwChan:ComCamPdu24VC.CHAN_J12, type:"CURRENT", scale: 1000.0)

        Bpu_Maq20_V (Channel, description: "Body purge MAQ20 voltage", units: "Volt", format: ".2f",
                     hwChan:ComCamPdu24VC.CHAN_BPU_MAQ20, type:"VOLTAGE")

        Bpu_Maq20_I (Channel, description: "Body purge MAQ20 current", units: "mA", format: ".1f",
                     hwChan:ComCamPdu24VC.CHAN_BPU_MAQ20, type:"CURRENT", scale: 1000.0)

        Gauges_V (Channel, description: "Gauges voltage", units: "Volt", format: ".2f",
                  hwChan:ComCamPdu24VC.CHAN_J11, type:"VOLTAGE")

        Gauges_I (Channel, description: "Gauges current", units: "mA", format: ".1f",
                  hwChan:ComCamPdu24VC.CHAN_J11, type:"CURRENT", scale: 1000.0)

        Ion_Pumps_V (Channel, description: "Ion pumps voltage", units: "Volt", format: ".2f",
                     hwChan:ComCamPdu24VC.CHAN_J5, type:"VOLTAGE")

        Ion_Pumps_I (Channel, description: "Ion pumps current", units: "mA", format: ".1f",
                     hwChan:ComCamPdu24VC.CHAN_J5, type:"CURRENT", scale: 1000.0)

        FES_Encoder_V (Channel, description: "FES Encoder voltage", units: "Volt", format: ".2f",
                       hwChan:ComCamPdu24VC.CHAN_J15, type:"VOLTAGE")

        FES_Encoder_I (Channel, description: "FES Encoder current", units: "mA", format: ".1f",
                       hwChan:ComCamPdu24VC.CHAN_J15, type:"CURRENT", scale: 1000.0)

        FES_Shu_HCU_V (Channel, description: "FES/shutter HCU voltage", units: "Volt", format: ".2f",
                       hwChan:ComCamPdu24VC.CHAN_J16, type:"VOLTAGE")

        FES_Shu_HCU_I (Channel, description: "FES/shutter HCU current", units: "mA", format: ".1f",
                       hwChan:ComCamPdu24VC.CHAN_J16, type:"CURRENT", scale: 1000.0)



    }

    PDU_24VD (ComCamPdu24vdDevice) {
        
        "24VD_Main_V" (Channel, description: "24V Dirty PDU main voltage", units: "Volts", format: ".2f",
                       type:"MAINVOLT")

        "24VD_Main_I" (Channel, description: "24V Dirty PDU main current", units: "mA", format: ".1f",
                       type:"MAINCURR", scale: 1000.0)

        "24VD_Main_T" (Channel, description: "24V Dirty PDU main temperature", units: "\u00b0C", format: ".1f",
                       type:"MAINTEMP")

        "24VD_Board_T" (Channel, description: "24V Dirty PDU board temperature", units: "\u00b0C", format: ".1f",
                        type:"BOARDTEMP")

        "24VD_FPGA_T" (Channel, description: "24V Dirty PDU FPGA temperature", units: "\u00b0C", format: ".1f",
                       type:"FPGATEMP")
/*
        Cryo_Turbo_V (Channel, description: "Cryo turbo pump voltage", units: "Volts", format: ".2f",
                      hwChan:ComCamPdu24VD.CHAN_CRYO_TURBO, type:"VOLTAGE")

        Cryo_Turbo_I (Channel, description: "Cryo turbo pump current", units: "mA", format: ".1f",
                      hwChan:ComCamPdu24VD.CHAN_CRYO_TURBO, type:"CURRENT", scale: 1000.0)
*/
        PF_Turbo_V (Channel, description: "PF turbo pump voltage", units: "Volts", format: ".2f",
                     hwChan:ComCamPdu24VD.CHAN_PFTURBO, type:"VOLTAGE")

        PF_Turbo_I (Channel, description: "PF turbo pump current", units: "mA", format: ".1f",
                     hwChan:ComCamPdu24VD.CHAN_PFTURBO, type:"CURRENT", scale: 1000.0)

    }

    PDU_48V (ComCamPdu48vDevice) {
        
        "48V_Main_V" (Channel, description: "48V PDU main voltage", units: "Volts", format: ".2f",
                      type:"MAINVOLT")

        "48V_Main_I" (Channel, description: "48V PDU main current", units: "mA", format: ".1f",
                      type:"MAINCURR", scale: 1000.0)

        "48V_Main_T" (Channel, description: "48V PDU main temperature", units: "\u00b0C", format: ".1f",
                      type:"MAINTEMP")

        "48V_Board_T" (Channel, description: "48V PDU board temperature", units: "\u00b0C", format: ".1f",
                       type:"BOARDTEMP")

        "48V_FPGA_T" (Channel, description: "48V PDU FPGA temperature", units: "\u00b0C", format: ".1f",
                      type:"FPGATEMP")

        Purge_Fan_V (Channel, description: "Purge fan voltage", units: "Volts", format: ".2f",
                     hwChan:ComCamPdu48V.CHAN_PURGE_FAN, type:"VOLTAGE")

        Purge_Fan_I (Channel, description: "Purge fan current", units: "mA", format: ".1f",
                     hwChan:ComCamPdu48V.CHAN_PURGE_FAN, type:"CURRENT", scale: 1000.0)

    }

    REB_Bulk_PS (RebBulkPsDevice) {

    }

}
