/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.common.MonitorTaskControl;
import org.lsst.ccs.subsystem.power.SwitchControl;
import org.lsst.ccs.subsystem.power.constants.QuadBoxSwitches;
import org.lsst.ccs.subsystem.power.constants.SwitchState;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.data.QuadBoxState;

public class QuadBox
extends Subsystem
implements HasLifecycle {
    private static final Map<Integer, String> typeMap = new HashMap<Integer, String>();
    private static final Logger LOG;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService aps;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService apts;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final List<SwitchControl> swDeviceList = new ArrayList<SwitchControl>();
    private final SwitchControl[] swDevices = new SwitchControl[7];
    private final QuadBoxState qbState = new QuadBoxState();
    private MonitorTaskControl monitorControl;

    public QuadBox() {
        super("quadbox", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void build() {
        this.monitorControl = MonitorTaskControl.createNode((Subsystem)this, (String)"MonitorControl");
        AgentPeriodicTask pt = new AgentPeriodicTask("quadbox-state", () -> this.updateState()).withPeriod(Duration.ofMillis(1000L));
        this.apts.scheduleAgentPeriodicTask(pt);
    }

    public void postInit() {
        this.aps.setAgentProperty("quadBoxAgent", ((Object)((Object)this)).getClass().getCanonicalName());
        boolean error = false;
        Iterator<SwitchControl> iterator = this.swDeviceList.iterator();
        while (iterator.hasNext()) {
            SwitchControl sd;
            this.swDevices[sd.getSwitchDevice()] = sd = iterator.next();
        }
        for (int j = 0; j < this.swDevices.length; ++j) {
            if (this.swDevices[j] != null) continue;
            LOG.log(Level.SEVERE, "The {0} device has not been specified", typeMap.get(j));
            error = true;
        }
        if (error) {
            throw new RuntimeException("Fatal initialization error");
        }
    }

    public void postStart() {
        this.publishState();
        LOG.info("Quad Box subsystem started");
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on/off a named switch")
    public void setSwitchOn(@Argument(description="The switch name") String name, @Argument(description="Whether to turn on") boolean on) throws PowerException {
        Integer sw = QuadBoxSwitches.getSwitchId(name);
        if (sw == null) {
            throw new PowerException("Invalid switch name: " + name);
        }
        int devNum = sw >> 8;
        byte swNum = (byte)sw.intValue();
        if (devNum < 0 || devNum >= 7 || swNum >= QuadBoxSwitches.NUM_SWITCHES[devNum]) {
            throw new PowerException("Programming error!! Invalid switch number: " + sw);
        }
        if (on) {
            this.swDevices[devNum].switchOn(swNum);
        } else {
            this.swDevices[devNum].switchOff(swNum);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get list of switch names")
    public List<String> getSwitchNames() {
        return QuadBoxSwitches.getSwitchNames();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public QuadBoxState getFullState() {
        this.qbState.setTickMillis(this.monitorControl.getPublishPeriod());
        return this.qbState;
    }

    private void updateState() {
        boolean changed = this.monitorControl.hasPeriodChanged();
        for (int devNum = 0; devNum < 7; ++devNum) {
            for (int swNum = -1; swNum < QuadBoxSwitches.NUM_SWITCHES[devNum]; ++swNum) {
                SwitchState ss;
                Boolean st = this.swDevices[devNum].isSwitchOn(swNum);
                SwitchState switchState = st == null ? SwitchState.OFFLINE : (ss = st != false ? SwitchState.ON : SwitchState.OFF);
                if (ss == this.qbState.getSwitchState(devNum, swNum)) continue;
                this.qbState.setSwitchState(devNum, swNum, ss);
                changed = true;
            }
        }
        if (changed) {
            this.publishState();
        }
    }

    private void publishState() {
        KeyValueData kvd = new KeyValueData("QuadBoxState", (Serializable)this.getFullState());
        this.publishSubsystemDataOnStatusBus(kvd);
    }

    static {
        typeMap.put(0, "BFR");
        typeMap.put(1, "5V PDU");
        typeMap.put(2, "24V clean PDU");
        typeMap.put(3, "24V dirty PDU");
        typeMap.put(4, "48V PDU");
        typeMap.put(5, "REB bulk PS");
        LOG = Logger.getLogger(QuadBox.class.getName());
    }

    static class DummyDevice
    implements SwitchControl {
        DummyDevice() {
        }

        @Override
        public int getSwitchDevice() {
            return 0;
        }

        @Override
        public Boolean isSwitchOn(int sw) {
            return null;
        }

        @Override
        public void switchOn(int sw) {
        }

        @Override
        public void switchOff(int sw) {
        }
    }
}

