/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.power.PowerControl;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.data.PowerException;

public class PowerGroup {
    public static final Logger LOG = Logger.getLogger(PowerGroup.class.getName());
    private final List<PowerControl> controls = new ArrayList<PowerControl>();

    public PowerGroup(PowerControl ... controls) {
        Collections.addAll(this.controls, controls);
    }

    public void addControl(PowerControl control) {
        if (control != null) {
            this.controls.add(control);
        }
    }

    public List<PowerChanState> getPowerState() {
        ArrayList<PowerChanState> pState = new ArrayList<PowerChanState>();
        for (PowerControl ctl : this.controls) {
            pState.add(ctl.getState());
        }
        return pState;
    }

    public void powerOn() throws PowerException {
        for (PowerControl ctl : this.controls) {
            ctl.writeAll();
        }
        for (PowerControl ctl : this.controls) {
            ctl.writeOutput(true);
        }
    }

    public void waitPowerOn(int timeout) throws PowerException {
        this.waitOutputSet(true, timeout);
    }

    public void powerOff() throws PowerException {
        for (PowerControl ctl : this.controls) {
            ctl.writeOutput(false);
        }
    }

    public void waitPowerOff(int timeout) throws PowerException {
        this.waitOutputSet(false, timeout);
    }

    private void waitOutputSet(boolean value, int timeout) throws PowerException {
        if (timeout <= 0) {
            return;
        }
        long maxTime = System.currentTimeMillis() + (long)timeout;
        int numDone = 0;
        block2: for (PowerControl ctl : this.controls) {
            while (System.currentTimeMillis() <= maxTime) {
                if (value == ctl.readOutput()) {
                    ++numDone;
                    continue block2;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (numDone < this.controls.size()) {
            throw new PowerException("Output wait timeout");
        }
    }
}

