/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.conv;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.lsst.ccs.utilities.conv.TypeConversionException;

public class InputConversionEngine {
    public static Object convertArgToType(String arg, Type inputType) throws TypeConversionException {
        if ("_null_".equals(arg)) {
            return null;
        }
        Class type = inputType instanceof Class ? (Class)inputType : null;
        boolean isParameterized = inputType instanceof ParameterizedType;
        if (isParameterized) {
            type = (Class)((ParameterizedType)inputType).getRawType();
        }
        if (type == null) {
            throw new RuntimeException("Error: Could not find type for " + inputType);
        }
        try {
            if (type.equals(String.class) || type.isInstance(arg)) {
                return arg;
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                long value = Long.decode(arg);
                long sign = value >> 32;
                if (sign != 0L && sign != -1L) {
                    throw new NumberFormatException();
                }
                return (int)value;
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return Long.decode(arg);
            }
            if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                return Short.valueOf(arg);
            }
            if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                return Byte.valueOf(arg);
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return Double.valueOf(arg);
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return Float.valueOf(arg);
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                if ("true".equalsIgnoreCase(arg)) {
                    return Boolean.TRUE;
                }
                if ("false".equalsIgnoreCase(arg)) {
                    return Boolean.FALSE;
                }
                throw new TypeConversionException("Error: Can't convert string '%s' to Boolean", arg);
            }
            if (type.isEnum()) {
                try {
                    return Enum.valueOf(type, arg.toUpperCase());
                }
                catch (IllegalArgumentException x) {
                    return Enum.valueOf(type, arg);
                }
            }
            if (type.isArray()) {
                List<String> tokens = InputConversionEngine.splitOnBrackets(arg);
                int n = tokens.size();
                Class<?> arrayType = type.getComponentType();
                Object array = Array.newInstance(arrayType, n);
                int count = 0;
                for (String token : tokens) {
                    Array.set(array, count++, InputConversionEngine.convertArgToType(token, arrayType));
                }
                return array;
            }
            if (List.class.isAssignableFrom(type)) {
                if (arg == null) {
                    return null;
                }
                Class<Object> listType = isParameterized ? ((ParameterizedType)inputType).getActualTypeArguments()[0] : Object.class;
                ArrayList<Object> l = new ArrayList<Object>();
                List<String> tokens = InputConversionEngine.splitOnBrackets(arg);
                for (String token : tokens) {
                    l.add(InputConversionEngine.convertArgToType(token, listType));
                }
                return l;
            }
            if (Set.class.isAssignableFrom(type)) {
                if (arg == null) {
                    return null;
                }
                Class<Object> listType = isParameterized ? ((ParameterizedType)inputType).getActualTypeArguments()[0] : Object.class;
                HashSet<Object> s = new HashSet<Object>();
                List<String> tokens = InputConversionEngine.splitOnBrackets(arg);
                for (String token : tokens) {
                    s.add(InputConversionEngine.convertArgToType(token, listType));
                }
                return s;
            }
            if (Map.class.isAssignableFrom(type)) {
                if (arg == null) {
                    return null;
                }
                Class<Object> keyType = isParameterized ? ((ParameterizedType)inputType).getActualTypeArguments()[0] : Object.class;
                Class<Object> valueType = isParameterized ? ((ParameterizedType)inputType).getActualTypeArguments()[1] : Object.class;
                HashMap<Object, Object> map = new HashMap<Object, Object>();
                List<String> tokens = InputConversionEngine.splitOnBrackets(arg);
                for (String token : tokens) {
                    String keyVal = token;
                    int split = keyVal.indexOf(":");
                    if (split < 0) {
                        if (keyVal.isEmpty()) continue;
                        throw new IllegalArgumentException("Error: cannot parse key-value pair " + keyVal + ". Key and Value must be separated by a column");
                    }
                    map.put(InputConversionEngine.convertArgToType(keyVal.substring(0, split), keyType), InputConversionEngine.convertArgToType(keyVal.substring(split + 1), valueType));
                }
                return map;
            }
            if (type.equals(Instant.class)) {
                return Instant.parse(arg);
            }
            if (type.equals(Duration.class)) {
                return Duration.parse(arg);
            }
            Constructor c = type.getConstructor(String.class);
            return c.newInstance(arg);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new TypeConversionException("Error: Can't instantiate class %s using string '%s'", (Throwable)ex, type.getName(), arg);
        }
        catch (IllegalArgumentException | NoSuchMethodException | DateTimeParseException e) {
            throw new TypeConversionException("Error: Can't convert string '%s' to class %s", (Throwable)e, arg, type.getName());
        }
    }

    static List<String> splitOnBrackets(String input) {
        input = input.trim();
        ArrayList<String> list = new ArrayList<String>();
        if (input.equals("[]")) {
            return list;
        }
        StringBuilder token = new StringBuilder("");
        int nBrackets = 0;
        for (int i = 0; i < input.length(); ++i) {
            boolean newToken;
            char c = input.charAt(i);
            if (c == '[') {
                ++nBrackets;
            } else if (c == ']') {
                --nBrackets;
            }
            boolean bl = newToken = nBrackets == 0;
            if (nBrackets == 1) {
                if (c == '[') continue;
                if (c == ',') {
                    newToken = true;
                }
            }
            if (newToken) {
                list.add(token.toString().trim());
                token.setLength(0);
                continue;
            }
            token.append(c);
        }
        return list;
    }
}

