package org.lsst.ccs.subsystem.power;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.utilities.conv.InputConversionEngine;

/**
 * A class with the configuration for a given Power Supply.
 *
 * @author The LSST CCS Team
 */
public class PowerSupplyConfiguration {

    private static final Logger LOG = Logger.getLogger(PowerSupplyConfiguration.class.getName());

    private final String name;
    private final String ip;
    private final List<String> rebs;
    private final int bfrRelay;
    private final String bfrName;
    private final int slot;
    private final boolean isCornerRaft;

    PowerSupplyConfiguration(String name, Properties props) {
        this.name = name;
        this.ip = props.getProperty(RebPowerSupplyWiring.PROPERTIES_PREFIX + name + ".ip");
        this.slot = (Integer) InputConversionEngine.convertArgToType(props.getProperty(RebPowerSupplyWiring.PROPERTIES_PREFIX + name + ".slot"), Integer.class);
        this.bfrRelay = (Integer) InputConversionEngine.convertArgToType(props.getProperty(RebPowerSupplyWiring.PROPERTIES_PREFIX + name + ".bfr.relay"), Integer.class);
        this.bfrName = props.getProperty(RebPowerSupplyWiring.PROPERTIES_PREFIX + name + ".bfr.name");
        this.isCornerRaft = Boolean.valueOf(props.getProperty(RebPowerSupplyWiring.PROPERTIES_PREFIX + name + ".isCornerRaft","false"));

        String rebsBuildProperty = RebPowerSupplyWiring.PROPERTIES_PREFIX + name + ".rebs";
        rebs = (List) InputConversionEngine.convertArgToType(props.getProperty(rebsBuildProperty), List.class);
        if (rebs.isEmpty()) {
            LOG.log(Level.WARNING, "No REBs have been provided for Power Supply {0} in build configuration {1}", new Object[]{name, rebsBuildProperty});
        }
    }

    public boolean isCornerRaft() {
        return isCornerRaft;
    }

    public String getName() {
        return name;
    }

    public String getIp() {
        return ip;
    }

    public List<String> getRebs() {
        return rebs;
    }

    public int getBfrRelay() {
        return bfrRelay;
    }

    public String getBfrName() {
        return bfrName;
    }

    public int getSlot() {
        return slot;
    }
    
}
