/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.HasDataProviderInfos;
import org.lsst.ccs.subsystem.common.focalplane.data.HasFocalPlaneData;
import org.lsst.ccs.subsystem.power.CornerRaftRebPowerSupplyNode;
import org.lsst.ccs.subsystem.power.EmergencyResponseManager;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.RebPowerSupplyNode;
import org.lsst.ccs.subsystem.power.RebPsDevice;
import org.lsst.ccs.subsystem.power.RebTrippedState;
import org.lsst.ccs.subsystem.power.constants.RebPsEnum;
import org.lsst.ccs.subsystem.power.data.PowerDataGroup;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.states.PowerSupplyState;
import org.lsst.ccs.subsystem.power.states.RebDPhiState;
import org.lsst.ccs.subsystem.power.states.RebHvBiasState;
import org.lsst.ccs.subsystem.power.states.RebPowerState;

public class RebPowerSupplyMain
extends Subsystem
implements HasLifecycle,
HasDataProviderInfos {
    private static final Logger LOG = Logger.getLogger(RebPowerSupplyMain.class.getName());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<PowerDevice> mainPsList = new ArrayList<PowerDevice>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private List<RebPsDevice> psDeviceList = new ArrayList<RebPsDevice>();
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private DataProviderDictionaryService dictionaryService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private EmergencyResponseManager emergencyResponseManager;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, RebPowerSupplyNode> rebs = new HashMap<String, RebPowerSupplyNode>();
    @ConfigurationParameter
    private long powerOffSleepMillis = 100L;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, Channel> channels = new HashMap<String, Channel>();

    public RebPowerSupplyMain() {
        super("rebps", AgentInfo.AgentType.WORKER);
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void build() {
        if (this.emergencyResponseManager == null) {
            throw new RuntimeException("Cannot operate the RebPower subsystem without an EmergencyResponseManager");
        }
        this.agentPropertiesService.setAgentProperty("agentCategory", AgentCategory.POWER.name());
        this.agentPropertiesService.setAgentProperty(HasFocalPlaneData.AGENT_PROPERTY, HasFocalPlaneData.generatePropertyValue(PowerDataGroup.class));
        AgentPeriodicTask pt = new AgentPeriodicTask("reb-power-state", () -> this.updateRebPowerState()).withPeriod(Duration.ofMillis(1000L));
        this.periodicTaskService.scheduleAgentPeriodicTask(pt);
    }

    public void init() {
        for (RebPowerSupplyNode reb : this.rebs.values()) {
            this.stateService.registerState(RebPowerState.class, "REB power state", (Object)reb);
            this.stateService.registerState(RebHvBiasState.class, "REB HV bias state", (Object)reb);
            if (!(reb instanceof CornerRaftRebPowerSupplyNode)) continue;
            this.stateService.registerState(RebDPhiState.class, "REB Dphi state", (Object)reb);
        }
        for (RebPsDevice powerSupplyDevice : this.psDeviceList) {
            this.stateService.registerState(PowerSupplyState.class, "Power Supply state", (Object)powerSupplyDevice);
        }
    }

    public void finalizeDictionary() {
        for (DataProviderInfo data : this.dictionaryService.getDataProviderDictionary().getDataProviderInfos()) {
            PowerDataGroup dataGroup = PowerDataGroup.findPowerDataGroup((DataProviderInfo)data);
            if (dataGroup == null) continue;
            dataGroup.addAttributesToDataInfo(data);
        }
    }

    private void updateRebPowerState() {
        HashMap<RebPsDevice, int[]> powerSupplyStateMap = new HashMap<RebPsDevice, int[]>();
        HashMap<RebPsDevice, RebTrippedState[]> rebTrippedStateMap = new HashMap<RebPsDevice, RebTrippedState[]>();
        StateBundle sb = new StateBundle(new Enum[0]);
        for (RebPsDevice powerSupplyDevice : this.psDeviceList) {
            sb.setComponentState(powerSupplyDevice.psPath, new Enum[]{powerSupplyDevice.isOnline() ? PowerSupplyState.ON : PowerSupplyState.OFF});
        }
        for (RebPowerSupplyNode reb : this.rebs.values()) {
            if (!reb.getRebPsDevice().isOnline()) {
                sb.setComponentState(reb.rebPath, new Enum[]{RebPowerState.UNKNOWN});
                sb.setComponentState(reb.rebPath, new Enum[]{RebHvBiasState.UNKNOWN});
                if (!(reb instanceof CornerRaftRebPowerSupplyNode)) continue;
                sb.setComponentState(reb.rebPath, new Enum[]{RebDPhiState.UNKNOWN});
                continue;
            }
            int[] powerState = powerSupplyStateMap.getOrDefault((Object)reb.getRebPsDevice(), reb.getRebPsDevice().getState());
            powerSupplyStateMap.put(reb.getRebPsDevice(), powerState);
            RebTrippedState[] rebTrippedStateArray = rebTrippedStateMap.getOrDefault((Object)reb.getRebPsDevice(), reb.getRebPsDevice().getPsTrippedStatus());
            rebTrippedStateMap.put(reb.getRebPsDevice(), rebTrippedStateArray);
            if (powerState.length != 6) {
                throw new RuntimeException("This length should have been 6 " + powerState.length);
            }
            int rebPowerState = powerState[reb.channel];
            sb.setComponentState(reb.rebPath, new Enum[]{this.getRebPowerState(rebPowerState, rebTrippedStateArray[reb.channel])});
            sb.setComponentState(reb.rebPath, new Enum[]{this.getRebHvBiasState(rebPowerState)});
            if (!(reb instanceof CornerRaftRebPowerSupplyNode)) continue;
            sb.setComponentState(reb.rebPath, new Enum[]{this.getRebDphiState(rebPowerState)});
        }
        this.stateService.updateAgentState(sb);
    }

    private int decodePowerState(int powerState, RebPsEnum id) {
        if (powerState < 0) {
            return -1;
        }
        int psNum = id.getNumber() + 1;
        int r = powerState >> psNum & 1;
        return r;
    }

    private RebHvBiasState getRebHvBiasState(int powerState) {
        int hvBiasState = this.decodePowerState(powerState, RebPsEnum.HVBIAS);
        if (hvBiasState < 0) {
            return RebHvBiasState.UNKNOWN;
        }
        if (hvBiasState == 0) {
            return RebHvBiasState.OFF;
        }
        if (hvBiasState == 1) {
            return RebHvBiasState.ON;
        }
        throw new RuntimeException("Unknown HVBias state " + hvBiasState);
    }

    private RebDPhiState getRebDphiState(int powerState) {
        int dphiState = this.decodePowerState(powerState, RebPsEnum.DPHI);
        if (dphiState < 0) {
            return RebDPhiState.UNKNOWN;
        }
        if (dphiState == 0) {
            return RebDPhiState.OFF;
        }
        if (dphiState == 1) {
            return RebDPhiState.ON;
        }
        throw new RuntimeException("Unknown Dphi state " + dphiState);
    }

    private RebPowerState getRebPowerState(int powerState, RebTrippedState rebTrippedState) {
        if (rebTrippedState.hasTripped()) {
            return RebPowerState.TRIPPED;
        }
        int pState = this.decodePowerState(powerState, RebPsEnum.MASTER);
        if (pState < 0) {
            return RebPowerState.UNKNOWN;
        }
        if (pState == 0) {
            return RebPowerState.OFF;
        }
        return RebPowerState.ON;
    }

    @Command
    public void powerOffAllRebs() throws InterruptedException {
        String failedRebs = "";
        int count = this.rebs.size();
        for (RebPowerSupplyNode node : this.rebs.values()) {
            --count;
            if (!this.stateService.isComponentInState(node.rebPath, (Enum)RebPowerState.ON)) continue;
            LOG.log(Level.INFO, "Powering off reb: {0}", new Object[]{node.rebPath});
            try {
                node.powerRebOff();
            }
            catch (PowerException ex) {
                LOG.log(Level.WARNING, "Failed to power off reb: " + node.rebPath, ex);
                failedRebs = failedRebs + node.rebPath + " ";
            }
            if (count <= 0) continue;
            Thread.sleep(this.powerOffSleepMillis);
        }
        if (!failedRebs.isEmpty()) {
            throw new RuntimeException("Failed to turn off the following rebs: " + failedRebs.trim());
        }
    }
}

