import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystem.power.ATSPowerMain
import org.lsst.ccs.subsystem.power.SimPowerDevice;
import org.lsst.ccs.subsystem.power.PowerControl
import org.lsst.ccs.monitor.Channel

CCSBuilder builder = ["ats-power-sim"]

builder.main (ATSPowerMain) {

    def sim = "Sim"

    "$sim" (SimPowerDevice, loads: [1000, 600, 10, 240, 240, 20, 15, 100, 20, 50000] as double[]) {

        DPHI      (PowerControl, description:"DPHI voltage", hwChan:0)

        OD        (PowerControl, description:"OD voltage", hwChan:1)

        Digital   (PowerControl, description:"Digital voltage", hwChan:2)

        ClockLow  (PowerControl, description:"Clock low voltage", hwChan:3)

        ClockHigh (PowerControl, description:"Clock high voltage", hwChan:4)

        Analog    (PowerControl, description:"Analog voltage", hwChan:5)

        OTM       (PowerControl, description:"OTM voltage", hwChan:6)

        Fan       (PowerControl, description:"Fan voltage", hwChan:7)

        Aux       (PowerControl, description:"Aux voltage", hwChan:8)

        HVBias    (PowerControl, description:"HV bias voltage", hwChan:9)
    }

    Digital_V (Channel, description: "Digital voltage", units: "Volts",
               devcName: sim,  hwChan:2, type: "VOLTAGE")
                          
    Digital_I (Channel, description: "Digital current", units: "mA", format: ".1f",
               devcName: sim,  hwChan:2, type: "CURRENT", scale: 1000.0)
                          
    Analog_V  (Channel, description: "Analog voltage", units: "Volts",
               devcName: sim,  hwChan:5, type: "VOLTAGE")
                          
    Analog_I  (Channel, description: "Analog current", units: "mA", format: ".1f",
               devcName: sim,  hwChan:5, type: "CURRENT", scale: 1000.0)

    ClkHigh_V (Channel, description: "Clock high voltage", units: "Volts",
               devcName: sim,  hwChan:4, type: "VOLTAGE")
                          
    ClkHigh_I (Channel, description: "Clock high current", units: "mA", format: ".1f",
               devcName: sim,  hwChan:4, type: "CURRENT", scale: 1000.0)
                          
    ClkLow_V  (Channel, description: "Clock low voltage", units: "Volts",
               devcName: sim,  hwChan:3, type: "VOLTAGE")
                          
    ClkLow_I  (Channel, description: "Clock low current", units: "mA", format: ".1f",
               devcName: sim,  hwChan:3, type: "CURRENT", scale: 1000.0)
                          
    OD_V      (Channel, description: "OD voltage", units: "Volts",
               devcName: sim,  hwChan:1, type: "VOLTAGE")
                          
    OD_I      (Channel, description: "OD current", units: "mA", format: ".1f",
               devcName: sim,  hwChan:1, type: "CURRENT", scale: 1000.0)
                          
    DPHI_V    (Channel, description: "DPHI voltage", units: "Volts",
               devcName: sim,  hwChan:0, type: "VOLTAGE")
                          
    DPHI_I    (Channel, description: "DPHI current", units: "mA", format: ".1f",
               devcName: sim,  hwChan:0, type: "CURRENT", scale: 1000.0)
     
    HVBias_V  (Channel, description: "HV bias voltage", units: "Volts",
               devcName: sim,  hwChan:9, type: "VOLTAGE")
                          
    HVBias_I  (Channel, description: "HV bias current", units: "mA", format: ".1f",
               devcName: sim,  hwChan:9, type: "CURRENT", scale: 1000.0)
     
    OTM_V     (Channel, description: "OTM voltage", units: "Volts",
               devcName: sim,  hwChan:6, type: "VOLTAGE")
                          
    OTM_I     (Channel, description: "OTM current", units: "mA", format: ".1f",
               devcName: sim,  hwChan:6, type: "CURRENT", scale: 1000.0)
                          
    Fan_V     (Channel, description: "Fan voltage", units: "Volts",
               devcName: sim,  hwChan:7, type: "VOLTAGE")
                          
    Fan_I     (Channel, description: "Fan current", units: "mA", format: ".1f",
               devcName: sim,  hwChan:7, type: "CURRENT", scale: 1000.0)
                          
    Aux_V     (Channel, description: "Aux voltage", units: "Volts",
               devcName: sim,  hwChan:8, type: "VOLTAGE")
                          
    Aux_I     (Channel, description: "Aux current", units: "mA", format: ".1f",
               devcName: sim,  hwChan:8, type: "CURRENT", scale: 1000.0)
                          
}
