package org.lsst.ccs.subsystem.power;

import java.util.logging.Level;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.subsystem.power.constants.RebPsEnum;
import org.lsst.ccs.subsystem.power.data.PowerException;

/**
 * A class representing an individual Reb for a Corner Rat.
 * It contains the information regarding the power supply powering this reb.
 * It provides commands to control the power to this reb.
 * 
 * @author The LSST CCS Team
 */
public class CornerRaftRebPowerSupplyNode extends RebPowerSupplyNode {
    
    @ConfigurationParameter
    double dphi;
    
    public CornerRaftRebPowerSupplyNode(PowerSupplyConfiguration powerSupplyConfiguration, int channel) {
        super(powerSupplyConfiguration, channel);
    }
    
    @ConfigurationParameterChanger(propertyName = "dphi")
    public void setDphi(double dphi) {
        try {
            powerSupplyDevice.setDphiDac(channel, dphi);        
            this.dphi = dphi;
        } catch (PowerException ex) {
            LOG.log(Level.WARNING,"Could not set the HVBias DAC value",ex);
            throw new RuntimeException(ex);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turns on the dphi bias to the configuration value")
    public void dphiOn() throws PowerException {
        powerSupplyDevice.setPowerOn(channel, RebPsEnum.DPHI.getNumber(), true);
        powerSupplyDevice.setDphiDac(channel, dphi);
    }
    
    @Command(type=Command.CommandType.ACTION, description="Turns off the dphi bias")
    public void dphiOff() throws PowerException {
        powerSupplyDevice.setPowerOn(channel, RebPsEnum.DPHI.getNumber(), false);
    }
}
