/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.config.Power;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.data.PowerState;
import org.lsst.ccs.utilities.logging.Logger;

public class MainPower
implements HasLifecycle {
    private static final Logger LOG = Logger.getLogger((String)MainPower.class.getName());
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private Map<String, PowerDevice> pwrDevices = new LinkedHashMap<String, PowerDevice>();
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService agentConfigurationService;
    public static final String BROADCAST_TASK = "publish-data";
    private long broadcastMillis = 10000L;

    public void build() {
        AgentPeriodicTask periodicTask = new AgentPeriodicTask(BROADCAST_TASK, () -> this.periodicBroadcast()).withPeriod(Duration.ofMillis(this.broadcastMillis));
        this.periodicTaskService.scheduleAgentPeriodicTask(periodicTask);
    }

    public void postInit() {
        this.agentPropertiesService.setAgentProperty("powerAgent", this.getClass().getCanonicalName());
        if (this.pwrDevices.isEmpty()) {
            LOG.error((Object)"No power devices specified");
        }
    }

    public void postStart() {
        LOG.info((Object)"Power subsystem started");
        this.publishState();
    }

    public void periodicBroadcast() {
        if (this.pwrDevices.isEmpty()) {
            return;
        }
        ArrayList<PowerChanState> pState = new ArrayList<PowerChanState>();
        for (PowerDevice pDevc : this.pwrDevices.values()) {
            try {
                pState.addAll(pDevc.getPowerState());
            }
            catch (Exception exception) {}
        }
        KeyValueData kvd = new KeyValueData("PowerChanState", pState);
        this.subsys.publishSubsystemDataOnStatusBus(kvd);
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod(BROADCAST_TASK, Duration.ofMillis(period));
    }

    private long getTickPeriod() {
        return this.periodicTaskService.getPeriodicTaskPeriod(BROADCAST_TASK).toMillis();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update period")
    public void setUpdatePeriod(int period) {
        this.setTickPeriod(period);
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Save the current configuration")
    public void saveNamedConfig(String name) throws IOException {
        this.agentConfigurationService.saveChangesForCategoriesAs(new String[]{"Power:" + name});
    }

    @Command(type=Command.CommandType.QUERY, description="Get the configuration data")
    public Power[] getPowerConfig() {
        Power[] power = new Power[this.pwrDevices.size()];
        int j = 0;
        for (PowerDevice pDevc : this.pwrDevices.values()) {
            power[j++] = pDevc.getPowerConfig();
        }
        return power;
    }

    @Command(type=Command.CommandType.ACTION, description="Set the configuration data")
    public void setPowerConfig(Power[] power) throws Exception {
        for (Power pConf : power) {
            PowerDevice pDevc = this.pwrDevices.get(pConf.getName());
            pDevc.setPowerConfig(pConf);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the power state")
    public List<PowerChanState> getPowerState() throws Exception {
        ArrayList<PowerChanState> pState = new ArrayList<PowerChanState>();
        for (PowerDevice pDevc : this.pwrDevices.values()) {
            pState.addAll(pDevc.getPowerState());
        }
        return pState;
    }

    @Command(type=Command.CommandType.ACTION, description="Turn on the power")
    public void powerOn() throws Exception {
        for (PowerDevice pDevc : this.pwrDevices.values()) {
            pDevc.powerOn();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn off the power")
    public void powerOff() throws Exception {
        for (PowerDevice pDevc : this.pwrDevices.values()) {
            pDevc.powerOff();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public PowerState getFullState() throws Exception {
        return new PowerState((int)this.getTickPeriod());
    }

    void publishState() {
        KeyValueData kvd = new KeyValueData("PowerState", (Serializable)new PowerState((int)this.getTickPeriod()));
        this.subsys.publishSubsystemDataOnStatusBus(kvd);
    }
}

