package org.lsst.ccs.subsystem.power;

import java.util.Properties;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.command.annotations.Command.CommandType;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
//import org.lsst.ccs.drivers.eaton.EpduG3;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.subsystem.power.config.Power;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.utilities.logging.Logger;

/**
 *  Interface to an Eaton PDU.
 * 
 *  ***** Just a placeholder for now
 *
 *  @author Owen Saxton
 */
public class EpduG3Device extends Device {

    /**
     *  Interface for open/close event listener.
     */
    public interface Event {

        public void opened();

        public void closed();

    }

    /**
     *  Constants.
     */
    private static final Logger LOG = Logger.getLogger(EpduG3Device.class.getName());

    private static final String
        DEVC_ID   = "devcId",
        DEVC_PARM = "devcParm",
        UNKN_PSID = "PS-XX";


    /**
     *  Data fields.
     */
    @ConfigurationParameter(name=DEVC_ID, category=Power.POWER)
    private String devcId;
    @ConfigurationParameter(name=DEVC_PARM, category=Power.POWER)
    private int devcParm;

    private Event listener;
    private String psId = UNKN_PSID;
    private Properties props;
    private int[] offSeq;


    /**
     *  Constructor.
     *
     *  @param  devcId    The host name
     *  @param  devcParm  The port number
     */
    public EpduG3Device(String devcId, int devcParm)
    {
        super();
        this.devcId = devcId;
        this.devcParm = devcParm;
    }


    /**
     *  Performs configuration.
     */
    @Override
    protected void initDevice() {
        String fileName = "psid.properties";
        if (BootstrapResourceUtils.getBootstrapResource(fileName) == null) {
            LOG.warn("PS ID properties file (" + fileName + ") not found");
        }
        props = BootstrapResourceUtils.getBootstrapProperties(fileName);
    }


    /**
     *  Sets the device ID.
     *
     *  @param  devcId  The device identification string
     */
    @ConfigurationParameterChanger
    public void setDevcId(String devcId)
    {
        if (devcId.equals(this.devcId)) return;
        this.devcId = devcId;
        close();
        inited = false;
        initialize();
    }


    /**
     *  Gets the device ID.
     *
     *  @return  The device identification string
     */
    @Command(type=CommandType.QUERY, description="Gets the device ID")
    public String getDevcId()
    {
        return devcId;
    }


    /**
     *  Sets the device parameter.
     *
     *  @param  devcParm  The device parameter
     */
    @ConfigurationParameterChanger
    public void setDevcParm(int devcParm)
    {
        if (devcParm == this.devcParm) return;
        this.devcParm = devcParm;
        close();
        inited = false;
        initialize();
    }


    /**
     *  Gets the device parameter.
     *
     *  @return  The device parameter
     */
    @Command(type=CommandType.QUERY, description="Gets the device parameter")
    public int getDevcParm()
    {
        return devcParm;
    }


    /**
     *  Performs full initialization.
     */
    @Override
    protected void initialize()
    {
        if (!inited) {
            fullName = "REB PS board (" + devcId + ")";
        }
        try {
            if (!inited) {
                //ps = new RebPs();
            }
            if (devcParm == 0) {
                //ps.open(devcId);
            }
            else {
                //ps.open(devcId, devcParm);
            }
            setOnline(true);
            if (listener != null) {
                listener.opened();
            }
            LOG.info("Connected to " + fullName);
        }
        catch (Exception e) {
            if (!inited) {
                LOG.error("Error connecting to " + fullName + ": " + e);
            }
            close();
        }
        inited = true;
    }


    /**
     *  Closes the connection.
     */
    @Override
    protected void close()
    {
        try {
            //ps.close();
        }
        //catch (DriverException e) {
        //}
        finally {
            if (listener != null) {
                listener.closed();
            }
            psId = UNKN_PSID;
        }
    }


    /**
     *  Checks a monitoring channel's parameters for validity.
     *
     *  @param  name     The channel name
     *  @param  hwChan   The hardware channel
     *  @param  type     The channel type string
     *  @param  subtype  The channel subtype string
     *  @return  Two-element array containg the encoded type [0] and subtype [1] 
     *  @throws  Exception  If parameters are invalid
     */
    @Override
    protected int[] checkChannel(String name, int hwChan, String type,
                                 String subtype) throws Exception
    {
        int rebNum = 0;
        Integer psNum = null;
        String[] flds = type.split(":");
        
        return new int[]{(rebNum << 8) | psNum, 0};
    }


    /**
     *  Reads a monitoring channel.
     *
     *  @param  hwChan  The hardware channel number
     *  @param  type    The encoded channel type
     *  @return  The read value
     */
    @Override
    protected double readChannel(int hwChan, int type)
    {
        double value = super.readChannel(hwChan, type);
        if (online) {
        }

        return value;
    }


    /**
     *  Gets the power state data.
     *
     *  @return  A list of power state data
     *  @throws  PowerException
     */
    protected int[] getState() throws PowerException
    {
        return null;
    }


    /**
     *  Turns a power supply on or off.
     *
     *  @param  reb    The REB number
     *  @param  psNum  The power supply number, or -1 for master switch
     *  @param  on     Turn on if true, off if false
     *  @throws  PowerException
     */
    protected void setPowerOn(int reb, int psNum, boolean on) throws PowerException
    {
    }


    /**
     *  Toggles the on/off state of a power supply.
     *
     *  @param  reb    The REB number
     *  @param  psNum  The power supply number, or -1 for master switch
     *  @throws  PowerException
     */
    protected void togglePower(int reb, int psNum) throws PowerException
    {
    }


    /**
     *  Sets an event listener.
     *
     *  @param  listen  The listener object
     */
    protected void setListener(Event listen)
    {
        listener = listen;
    }


    /**
     *  Clears the event listener.
     */
    protected void clearListener()
    {
        listener = null;
    }


    /**
     *  Gets the power supply ID.
     *
     *  @return  The ID
     */
    protected String getPsId()
    {
        return psId;
    }

}
