/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.DriverTimeoutException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.subsystem.power.PowerControl;
import org.lsst.ccs.subsystem.power.config.Power;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.utilities.logging.Logger;

public abstract class PowerDevice
extends Device {
    protected static final Logger LOG = Logger.getLogger((String)PowerDevice.class.getName());
    protected static final int NETWORK_CONN_INVALID = 1;
    protected static final int CONN_TYPE_NOT_CONFIG = 2;
    protected static final int DEVC_ID_NOT_CONFIG = 4;
    protected static final int DEVC_PARM_NOT_CONFIG = 8;
    private static final int MON_TYPE_VOLTAGE = 0;
    private static final int MON_TYPE_CURRENT = 1;
    private static final String CONN_TYPE = "connType";
    private static final String DEVC_ID = "devcId";
    private static final String DEVC_PARM = "devcParm";
    private static final Map<String, DriverConstants.ConnType> cTypeMap = new HashMap<String, DriverConstants.ConnType>();
    private static final Map<DriverConstants.ConnType, Power.ConnType> cTypeEMap;
    private static final Map<String, Integer> mTypeMap;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @ConfigurationParameter(name="devcId", category="Power", isFinal=true)
    protected String devcId;
    @ConfigurationParameter(name="devcParm", category="Power", isFinal=true)
    protected int devcParm;
    @ConfigurationParameter(name="connType", category="Power", isFinal=true)
    protected String connType;
    private final String devcName;
    protected PowerSupplyDriver psd;
    private DriverConstants.ConnType connTypeE;
    private final int options;
    private final int minChan;
    private final int maxChan;

    public PowerDevice(String name, PowerSupplyDriver psd, int options, int minChan, int maxChan) {
        this.devcName = name;
        this.psd = psd;
        this.options = options;
        this.minChan = minChan;
        this.maxChan = maxChan;
    }

    @Deprecated
    public PowerDevice(String name, PowerSupplyDriver psd, String connType, String devcId, int devcParm, int options, int minChan, int maxChan) {
        this.devcName = name;
        this.psd = psd;
        this.connType = connType;
        this.devcId = devcId;
        this.devcParm = devcParm;
        this.options = options;
        this.minChan = minChan;
        this.maxChan = maxChan;
    }

    public int getMinChannel() {
        return this.minChan;
    }

    public int getMaxChannel() {
        return this.maxChan;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the connection type")
    public String getConnType() {
        return this.connType;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device ID")
    public String getDevcId() {
        return this.devcId;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the device parameter")
    public int getDevcParm() {
        return this.devcParm;
    }

    protected void initDevice() {
        DriverConstants.ConnType cType;
        if (this.connType == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)CONN_TYPE, (String)"is missing");
        }
        if ((cType = cTypeMap.get(this.connType.toLowerCase())) == null || cType == DriverConstants.ConnType.NET && (this.options & 1) != 0) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)CONN_TYPE, (String)"is invalid");
        }
        this.connTypeE = cType;
        if (this.devcId == null) {
            MonitorLogUtils.reportConfigError((Logger)LOG, (String)this.name, (String)DEVC_ID, (String)"is missing");
        }
        this.fullName = this.devcName + (this.devcId.isEmpty() ? "" : " (" + this.devcId + ")");
    }

    protected void initialize() {
        try {
            this.psd.open(this.connTypeE, this.devcId, this.devcParm);
            this.setOnline(true);
            this.initSensors();
            LOG.info((Object)("Connected to " + this.fullName));
        }
        catch (DriverException e) {
            if (!this.inited) {
                LOG.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
            }
            this.close();
        }
        this.inited = true;
    }

    protected void close() {
        try {
            this.psd.close();
        }
        catch (DriverException driverException) {
            // empty catch block
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer mType = mTypeMap.get(type.toUpperCase());
        if (mType == null) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"type", (Object)type);
        }
        if (hwChan < this.minChan || hwChan > this.maxChan) {
            MonitorLogUtils.reportError((Logger)LOG, (String)name, (String)"hw channel number", (Object)hwChan);
        }
        return new int[]{mType, 0};
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        if (this.online) {
            try {
                value = type == 0 ? this.psd.readVoltage(hwChan) : this.psd.readCurrent(hwChan);
            }
            catch (DriverException e) {
                LOG.error((Object)("Error reading from " + this.fullName + ": " + (Object)((Object)e)));
                this.setOnline(false);
            }
        }
        return value;
    }

    public Power getPowerConfig() {
        Power power = new Power();
        power.setName(this.name);
        power.setConnType(cTypeEMap.get(this.connType));
        power.setDevcId(this.devcId);
        power.setDevcParm(this.devcParm);
        Power.Channel[] chans = new Power.Channel[this.ctlChans.size()];
        int j = 0;
        for (Control ctl : this.ctlChans.values()) {
            chans[j++] = ((PowerControl)ctl).getConfig();
        }
        power.setChannels(chans);
        return power;
    }

    public void setPowerConfig(Power power) throws PowerException {
        for (Power.Channel chan : power.getChannels()) {
            String cName = this.name + "." + chan.getName();
            ((PowerControl)((Object)this.ctlChans.get(cName))).setConfig(chan);
        }
    }

    protected List<PowerChanState> getPowerState() {
        this.readVoltageGroup();
        this.readCurrentGroup();
        this.readOutputGroup();
        ArrayList<PowerChanState> pState = new ArrayList<PowerChanState>();
        for (Control ctl : this.ctlChans.values()) {
            pState.add(((PowerControl)ctl).getState());
        }
        return pState;
    }

    protected void powerOn() throws PowerException {
        for (Control ctl : this.ctlChans.values()) {
            ((PowerControl)ctl).writeAll();
        }
        try {
            this.writeVoltageGroup();
            this.writeCurrentGroup();
            this.writeOnDelayGroup();
            this.writeOffDelayGroup();
        }
        catch (DriverException e) {
            this.handleException(e);
        }
        this.setOutput(true);
    }

    protected void waitPowerOn(int timeout) throws PowerException {
        this.waitOutputSet(true, timeout);
    }

    protected void powerOff() throws PowerException {
        this.setOutput(false);
    }

    protected void waitPowerOff(int timeout) throws PowerException {
        this.waitOutputSet(false, timeout);
    }

    protected void writeVoltage(double voltage, int hwChan) throws PowerException {
        try {
            this.psd.setVoltage(voltage, hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
        }
    }

    protected double readVoltage(int hwChan) throws PowerException {
        try {
            return this.psd.readVoltage(hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
            return 0.0;
        }
    }

    protected void writeCurrent(double current, int hwChan) throws PowerException {
        try {
            this.psd.setCurrent(current, hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
        }
    }

    protected double readCurrent(int hwChan) throws PowerException {
        try {
            return this.psd.readCurrent(hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
            return 0.0;
        }
    }

    protected void writeOnDelay(double onDelay, int hwChan) throws PowerException {
        try {
            this.psd.setOnDelay(onDelay, hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
        }
    }

    protected void writeOffDelay(double offDelay, int hwChan) throws PowerException {
        try {
            this.psd.setOffDelay(offDelay, hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
        }
    }

    protected void writeOutput(boolean value, int hwChan) throws PowerException {
        try {
            this.psd.setOutput(value, hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
        }
    }

    protected boolean readOutput(int hwChan) throws PowerException {
        try {
            return this.psd.getOutput(hwChan);
        }
        catch (DriverException e) {
            this.handleException(e);
            return false;
        }
    }

    private void setOutput(boolean value) throws PowerException {
        try {
            for (Control ctl : this.ctlChans.values()) {
                this.psd.setOutput(value, ctl.getHwChan());
            }
            this.writeOutputGroup();
        }
        catch (DriverException e) {
            this.handleException(e);
        }
    }

    private void waitOutputSet(boolean value, int timeout) throws PowerException {
        if (timeout <= 0) {
            return;
        }
        long maxTime = System.currentTimeMillis() + (long)timeout;
        try {
            this.readOutputGroup();
            for (Control ctl : this.ctlChans.values()) {
                while (System.currentTimeMillis() <= maxTime) {
                    if (value == this.psd.getOutput(ctl.getHwChan())) {
                        return;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            throw new DriverTimeoutException("Output wait timeout");
        }
        catch (DriverException e) {
            this.handleException(e);
            return;
        }
    }

    protected void writeVoltageGroup() throws DriverException {
    }

    protected void readVoltageGroup() {
    }

    protected void writeCurrentGroup() throws DriverException {
    }

    protected void readCurrentGroup() {
    }

    protected void writeOnDelayGroup() throws DriverException {
    }

    protected void writeOffDelayGroup() throws DriverException {
    }

    protected void writeOutputGroup() throws DriverException {
    }

    protected void readOutputGroup() {
    }

    protected void handleException(DriverException e) throws PowerException {
        if (e instanceof DriverTimeoutException) {
            LOG.error((Object)"Timeout while accessing the power supply");
            this.setOnline(false);
        }
        throw new PowerException(e.toString());
    }

    static {
        cTypeMap.put(Power.ConnType.Network.name().toLowerCase(), DriverConstants.ConnType.NET);
        cTypeMap.put(Power.ConnType.Ftdi.name().toLowerCase(), DriverConstants.ConnType.FTDI);
        cTypeMap.put(Power.ConnType.Serial.name().toLowerCase(), DriverConstants.ConnType.SERIAL);
        cTypeEMap = new HashMap<DriverConstants.ConnType, Power.ConnType>();
        cTypeEMap.put(DriverConstants.ConnType.NET, Power.ConnType.Network);
        cTypeEMap.put(DriverConstants.ConnType.FTDI, Power.ConnType.Ftdi);
        cTypeEMap.put(DriverConstants.ConnType.SERIAL, Power.ConnType.Serial);
        mTypeMap = new HashMap<String, Integer>();
        mTypeMap.put("VOLTAGE", 0);
        mTypeMap.put("CURRENT", 1);
    }
}

