/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.power;

import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.subsystem.power.PowerDevice;
import org.lsst.ccs.subsystem.power.RebPsDevice;
import org.lsst.ccs.subsystem.power.constants.RebPsEnum;
import org.lsst.ccs.subsystem.power.data.PowerChanState;
import org.lsst.ccs.subsystem.power.data.PowerException;
import org.lsst.ccs.subsystem.power.data.RebPsState;
import org.lsst.ccs.subsystem.power.states.RebPowerState;
import org.lsst.ccs.utilities.logging.Logger;

public class RebPower
implements HasLifecycle,
RebPsDevice.Event {
    private static final Logger LOG = Logger.getLogger((String)RebPower.class.getName());
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private PowerDevice mainPs;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private RebPsDevice psDevice;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    private final List<Channel> rebPowerChannels = new ArrayList<Channel>();
    @ConfigurationParameter
    private double[] powerStateTransitionLimits = new double[]{0.2, 8.0, 15.0};
    private long updateStateMillis = 1000L;
    private long checkTrippedMillis = 1000L;
    @ConfigurationParameter
    private double powerStateTransitionHysteresisPercentage = 0.01;
    private Map<String, Double> rebPower = new HashMap<String, Double>();
    private Map<String, Double> rebSimulatedPower = new HashMap<String, Double>();
    private boolean isSimulated;
    private boolean running;

    public void build() {
        AgentPeriodicTask periodicTask = new AgentPeriodicTask("reb-power-state", () -> this.updateRebPowerState()).withPeriod(Duration.ofMillis(this.updateStateMillis));
        this.periodicTaskService.scheduleAgentPeriodicTask(periodicTask);
        periodicTask = new AgentPeriodicTask("reb-power-check", () -> this.checkPsTripped()).withPeriod(Duration.ofMillis(this.checkTrippedMillis));
        this.periodicTaskService.scheduleAgentPeriodicTask(periodicTask);
    }

    public void init() {
        this.isSimulated = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.run.mode", "").equals("simulation");
    }

    public void postInit() {
        this.subsys.setAgentProperty("rebPowerAgent", this.getClass().getCanonicalName());
        if (this.mainPs == null) {
            LOG.warning((Object)"No main power supply device specified");
        }
        if (this.psDevice == null) {
            LOG.error((Object)"No REB power devices specified");
        } else {
            this.psDevice.setListener(this);
        }
        for (Map.Entry<String, Channel> entry : this.channels.entrySet()) {
            String channelName = entry.getKey();
            if (!channelName.endsWith(".Power")) continue;
            LOG.fine((Object)("Adding power channel " + channelName));
            this.rebPowerChannels.add(entry.getValue());
        }
        StateBundle sb = new StateBundle(new Enum[]{RebPowerState.OFF});
        for (Channel ch : this.rebPowerChannels) {
            String rebPath = ch.getPath();
            sb.setComponentState(rebPath, new Enum[]{RebPowerState.OFF});
            if (this.isSimulated) {
                this.rebSimulatedPower.put(rebPath, 0.0);
            }
            this.rebPower.put(rebPath, 0.0);
        }
        this.subsys.updateAgentState(sb);
    }

    public void postStart() {
        LOG.info((Object)"REB PS subsystem started");
        this.running = true;
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Set simulated reb power")
    public void setSimulatedRebPower(@Argument(description="REB name") String rebName, @Argument(description="The simulated Reb Total power") double rebPower) {
        this.rebSimulatedPower.put(rebName, rebPower);
    }

    private void updateRebPowerState() {
        StateBundle sb = new StateBundle(new Enum[0]);
        double totalPower = 0.0;
        double oldTotalPower = 0.0;
        for (Channel ch : this.rebPowerChannels) {
            String rebPath = ch.getPath();
            double rebPowerValue = this.isSimulated ? this.rebSimulatedPower.get(rebPath).doubleValue() : ch.getValue();
            totalPower += rebPowerValue;
            oldTotalPower += this.rebPower.get(rebPath).doubleValue();
            if (!this.isChangeSignificant(rebPowerValue, this.rebPower.get(rebPath))) continue;
            this.rebPower.put(rebPath, rebPowerValue);
            sb.setComponentState(rebPath, new Enum[]{this.getRebPowerState(rebPowerValue)});
        }
        if (this.isChangeSignificant(totalPower, oldTotalPower)) {
            sb.setState(new Enum[]{this.getRebPowerState(totalPower / 3.0)});
        }
        if (!this.subsys.isInState(sb)) {
            LOG.fine((Object)("Changing Rebs Power State to " + sb));
            this.subsys.updateAgentState(sb);
        }
    }

    private void checkPsTripped() {
        if (this.psDevice != null && this.psDevice.checkPsTripped()) {
            this.publishState();
        }
    }

    private RebPowerState getRebPowerState(double value) {
        if (value < this.powerStateTransitionLimits[0]) {
            return RebPowerState.OFF;
        }
        if (value < this.powerStateTransitionLimits[1]) {
            return RebPowerState.ON;
        }
        if (value < this.powerStateTransitionLimits[2]) {
            return RebPowerState.LOW_POWER;
        }
        return RebPowerState.OPERATIONAL;
    }

    private boolean isChangeSignificant(double newValue, double oldValue) {
        return Math.abs(newValue - oldValue) > this.powerStateTransitionHysteresisPercentage * oldValue;
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private long getTickPeriod() {
        return this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update period")
    public void setUpdatePeriod(@Argument(description="The tick period (msecs)") int period) {
        this.setTickPeriod(period);
        this.publishState();
    }

    @Command(type=Command.CommandType.ACTION, description="Turn the main power supply on or off")
    public void setMainPower(@Argument(description="Whether on or off") boolean on) throws Exception {
        block8: {
            try {
                if (this.mainPs == null) break block8;
                if (on) {
                    this.mainPs.powerOn();
                    if (this.psDevice != null) {
                        this.psDevice.enable();
                    }
                    break block8;
                }
                if (this.psDevice == null) break block8;
                try {
                    this.psDevice.sequencePower(false);
                }
                finally {
                    this.psDevice.disable();
                    this.mainPs.powerOff();
                }
            }
            finally {
                this.publishState();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Toggle the main power supply state")
    public void toggleMainPower() throws Exception {
        this.setMainPower(this.getMainState() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Turns a power supply on or off")
    public void setPowerOn(@Argument(description="REB number") int reb, @Argument(description="Power supply number") int ps, @Argument(description="Whether on or off") boolean on) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.setPowerOn(reb, ps, on);
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turns a power supply on or off")
    public void setNamedPowerOn(@Argument(description="REB number") int reb, @Argument(description="Power supply name") RebPsEnum psEnum, @Argument(description="Whether on or off") boolean on) throws PowerException {
        this.setPowerOn(reb, psEnum.getNumber(), on);
    }

    @Command(type=Command.CommandType.ACTION, description="Toggle a power supply")
    public void togglePower(@Argument(description="REB number") int reb, @Argument(description="Power supply number") int ps) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.togglePower(reb, ps);
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Toggle a power supply")
    public void toggleNamedPower(@Argument(description="REB number") int reb, @Argument(name="name", description="Power supply name") RebPsEnum psEnum) throws PowerException {
        this.togglePower(reb, psEnum.getNumber());
    }

    @Command(type=Command.CommandType.ACTION, description="Sequence a power supply")
    public void sequencePower(@Argument(description="REB number") int reb, @Argument(description="Whether to turn on") boolean on) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.sequencePower(reb, on);
            }
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a HV bias DAC")
    public void setBiasDac(@Argument(description="REB number") int reb, @Argument(description="DAC value") double value) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.setBiasDac(reb, value);
            }
        }
        finally {
            this.publishState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(type=Command.CommandType.ACTION, description="Set a DPHI DAC")
    public void setDphiDac(@Argument(description="REB number") int reb, @Argument(description="DAC value") double value) throws PowerException {
        try {
            if (this.psDevice != null) {
                this.psDevice.setDphiDac(reb, value);
            }
        }
        finally {
            this.publishState();
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Read a channel's maximum & minimum values")
    public double[] getChanExtrema(@Argument(description="REB number") int reb, @Argument(description="PS name") RebPsDevice.PsName psName, @Argument(description="Channel name") RebPsDevice.ChanName chan) throws PowerException {
        double[] dArray;
        if (this.psDevice != null) {
            dArray = this.psDevice.readChanExtrema(reb, psName, chan);
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = Double.NaN;
            dArray = dArray2;
            dArray2[1] = Double.NaN;
        }
        return dArray;
    }

    @Command(type=Command.CommandType.ACTION, description="Reset a channel's maximum & minimum values")
    public void resetChanExtrema(@Argument(description="REB number") int reb, @Argument(description="PS name") RebPsDevice.PsName psName, @Argument(description="Channel name") RebPsDevice.ChanName chan) throws PowerException {
        if (this.psDevice != null) {
            this.psDevice.resetChanExtrema(reb, psName, chan);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public RebPsState getFullState() throws Exception {
        return this.getState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the error counters")
    public int[] getErrors() {
        if (this.psDevice != null) {
            return this.psDevice.getErrors();
        }
        return new int[]{0, 0};
    }

    void publishState() {
        if (!this.running) {
            return;
        }
        KeyValueData kvd = new KeyValueData("RebPsState", (Serializable)this.getState());
        this.subsys.publishSubsystemDataOnStatusBus(kvd);
    }

    RebPsState getState() {
        int psType = 0;
        int psVersion = 1;
        String psId = "PS-X";
        int[] psState = new int[]{};
        double[] biasDacs = new double[]{};
        double[] dphiDacs = new double[]{};
        if (this.psDevice != null) {
            psType = this.psDevice.getPsType();
            psVersion = this.psDevice.getPsVersion();
            psId = this.psDevice.getPsId();
            psState = this.psDevice.getState();
            biasDacs = this.psDevice.getDacs(true);
            dphiDacs = this.psDevice.getDacs(false);
        }
        return new RebPsState((int)this.getTickPeriod(), this.getMainState(), psState, biasDacs, dphiDacs, psType, psVersion, psId);
    }

    int getMainState() {
        int state = -1;
        if (this.mainPs != null && this.mainPs.isOnline()) {
            try {
                List<PowerChanState> pcState = this.mainPs.getPowerState();
                if (!pcState.isEmpty()) {
                    state = pcState.get(0).getState();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return state;
    }

    @Override
    public void opened() {
        this.publishState();
    }

    @Override
    public void closed() {
        this.publishState();
    }
}

