import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.drivers.auxelex.Bfr
import org.lsst.ccs.drivers.auxelex.Pdu24VC
import org.lsst.ccs.drivers.auxelex.Pdu24VD
import org.lsst.ccs.drivers.auxelex.Pdu5V
import org.lsst.ccs.drivers.auxelex.Pdu48V
import org.lsst.ccs.subsystem.power.QuadBox
import org.lsst.ccs.subsystem.power.BfrDevice
import org.lsst.ccs.subsystem.power.Pdu5vDevice
import org.lsst.ccs.subsystem.power.Pdu24vcDevice
import org.lsst.ccs.subsystem.power.Pdu24vdDevice
import org.lsst.ccs.subsystem.power.Pdu48vDevice
import org.lsst.ccs.subsystem.power.RebBulkPsDevice
import org.lsst.ccs.monitor.Channel
import org.lsst.ccs.monitor.Page

taskConfig = ["monitor-update/taskPeriodMillis":1000, "monitor-publish/taskPeriodMillis":10000]

CCSBuilder builder = ["quadbox"]

builder.main (QuadBox, nodeTags:taskConfig) {

    Page0 (Page, id:0, label:"BFR")
    Page1 (Page, id:1, label:"PDU-5V")
    Page2 (Page, id:2, label:"PDU-24VC")
    Page3 (Page, id:3, label:"PDU-24VD")
    Page4 (Page, id:4, label:"PDU-48V")
    Page5 (Page, id:5, label:"REB-Bulk")

    BFR (BfrDevice, node:63) {

    }

    PDU_5V (Pdu5vDevice, node:68) {

    }

    PDU_24VC (Pdu24vcDevice, node:79)

    PDU_24VD (Pdu24vdDevice, node:78)

    PDU_48V (Pdu48vDevice, node:77)

    REB_Bulk_PS (RebBulkPsDevice, node:83)

        Protection_I (Channel, description: "Protection system current", units: "mA", format: ".1f",
                      devcName:"BFR", hwChan:Bfr.SENSOR_PROT, scale: 1000.0, pageId:0)

        Clean_5_24V_I (Channel, description: "Clean 5 and 24V current", units: "mA", format: ".1f",
                       devcName:"BFR", hwChan:Bfr.SENSOR_PWS_20_21, scale: 1000.0, pageId:0)

        Dirty_24V_I (Channel, description: "Dirty 24V current", units: "mA", format: ".1f",
                     devcName:"BFR", hwChan:Bfr.SENSOR_PWS_3, scale: 1000.0, pageId:0)

        Dirty_48V_I (Channel, description: "Dirty 48V current", units: "mA", format: ".1f",
                     devcName:"BFR", hwChan:Bfr.SENSOR_PWS_1, scale: 1000.0, pageId:0)

        RebPs_0_2_I (Channel, description: "REB PS 0-2 current", units: "mA", format: ".1f",
                     devcName:"BFR", hwChan:Bfr.SENSOR_PWS_16, scale: 1000.0, pageId:0)

        RebPs_3_5_I (Channel, description: "REB PS 3-5 current", units: "mA", format: ".1f",
                     devcName:"BFR", hwChan:Bfr.SENSOR_PWS_17, scale: 1000.0, pageId:0)

        RebPs_6_8_I (Channel, description: "REB PS 6-8 current", units: "mA", format: ".1f",
                     devcName:"BFR", hwChan:Bfr.SENSOR_PWS_18, scale: 1000.0, pageId:0)

        RebPs_9_12_I (Channel, description: "REB PS 9-12 current", units: "mA", format: ".1f",
                      devcName:"BFR", hwChan:Bfr.SENSOR_PWS_19, scale: 1000.0, pageId:0)

        Dirty_28V_I (Channel, description: "Dirty 28V current", units: "mA", format: ".1f",
                     devcName:"BFR", hwChan:Bfr.SENSOR_PWS_4, scale: 1000.0, pageId:0)

        Heater_I (Channel, description: "Heater current", units: "mA", format: ".1f",
                  devcName:"BFR", hwChan:Bfr.SENSOR_HTRS, scale: 1000.0, pageId:0)

        RebPs_Spr_I (Channel, description: "REB PS spare current", units: "mA", format: ".1f",
                     devcName:"BFR", hwChan:Bfr.SENSOR_PWS_25, scale: 1000.0, pageId:0)

        OTM_0_A_V (Channel, description: "OTM 0-A voltage", units: "Volts", format: ".2f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_0_A, type:"VOLTAGE", pageId:1)

        OTM_0_A_I (Channel, description: "OTM 0-A current", units: "mA", format: ".1f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_0_A, type:"CURRENT", scale: 1000.0, pageId:1)

        OTM_0_B_V (Channel, description: "OTM 0-B voltage", units: "Volts", format: ".2f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_0_B, type:"VOLTAGE", pageId:1)

        OTM_0_B_I (Channel, description: "OTM 0-B current", units: "mA", format: ".1f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_0_B, type:"CURRENT", scale: 1000.0, pageId:1)

        OTM_1_A_V (Channel, description: "OTM 1-A voltage", units: "Volts", format: ".2f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_1_A, type:"VOLTAGE", pageId:1)

        OTM_1_A_I (Channel, description: "OTM 1-A current", units: "mA", format: ".1f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_1_A, type:"CURRENT", scale: 1000.0, pageId:1)

        OTM_1_B_V (Channel, description: "OTM 1-B voltage", units: "Volts", format: ".2f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_1_B, type:"VOLTAGE", pageId:1)

        OTM_1_B_I (Channel, description: "OTM 1-B current", units: "mA", format: ".1f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_1_B, type:"CURRENT", scale: 1000.0, pageId:1)

        OTM_2_A_V (Channel, description: "OTM 2-A voltage", units: "Volts", format: ".2f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_2_A, type:"VOLTAGE", pageId:1)

        OTM_2_A_I (Channel, description: "OTM 2-A current", units: "mA", format: ".1f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_2_A, type:"CURRENT", scale: 1000.0, pageId:1)

        OTM_2_B_V (Channel, description: "OTM 2-B voltage", units: "Volts", format: ".2f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_2_B, type:"VOLTAGE", pageId:1)

        OTM_2_B_I (Channel, description: "OTM 2-B current", units: "mA", format: ".1f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_2_B, type:"CURRENT", scale: 1000.0, pageId:1)

        OTM_3_A_V (Channel, description: "OTM 3-A voltage", units: "Volts", format: ".2f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_3_A, type:"VOLTAGE", pageId:1)

        OTM_3_A_I (Channel, description: "OTM 3-A current", units: "mA", format: ".1f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_3_A, type:"CURRENT", scale: 1000.0, pageId:1)

        OTM_3_B_V (Channel, description: "OTM 3-B voltage", units: "Volts", format: ".2f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_3_B, type:"VOLTAGE", pageId:1)

        OTM_3_B_I (Channel, description: "OTM 3-B current", units: "mA", format: ".1f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_3_B, type:"CURRENT", scale: 1000.0, pageId:1)

        OTM_4_A_V (Channel, description: "OTM 4-A voltage", units: "Volts", format: ".2f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_4_A, type:"VOLTAGE", pageId:1)

        OTM_4_A_I (Channel, description: "OTM 4-A current", units: "mA", format: ".1f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_4_A, type:"CURRENT", scale: 1000.0, pageId:1)

        OTM_4_B_V (Channel, description: "OTM 4-B voltage", units: "Volts", format: ".2f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_4_B, type:"VOLTAGE", pageId:1)

        OTM_4_B_I (Channel, description: "OTM 4-B current", units: "mA", format: ".1f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_4_B, type:"CURRENT", scale: 1000.0, pageId:1)

        OTM_5_A_V (Channel, description: "OTM 5-A voltage", units: "Volts", format: ".2f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_5_A, type:"VOLTAGE", pageId:1)

        OTM_5_A_I (Channel, description: "OTM 5-A current", units: "mA", format: ".1f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_5_A, type:"CURRENT", scale: 1000.0, pageId:1)

        OTM_5_B_V (Channel, description: "OTM 5-B voltage", units: "Volts", format: ".2f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_5_B, type:"VOLTAGE", pageId:1)

        OTM_5_B_I (Channel, description: "OTM 5-B current", units: "mA", format: ".1f",
                   devcName:"PDU_5V", hwChan:Pdu5V.CHAN_OTM_5_B, type:"CURRENT", scale: 1000.0, pageId:1)

        "24VC_Main_V" (Channel, description: "24V Clean PDU main voltage", units: "Volts", format: ".2f",
                     devcName:"PDU_24VC", type:"MAINVOLT", pageId:2)

        "24VC_Main_I" (Channel, description: "24V Clean PDU main current", units: "mA", format: ".1f",
                     devcName:"PDU_24VC", type:"MAINCURR", scale: 1000.0, pageId:2)

        "24VC_Main_T" (Channel, description: "24V Clean PDU main temperature", units: "\u00b0C", format: ".1f",
                     devcName:"PDU_24VC", type:"MAINTEMP", pageId:2)

        "24VC_Board_T" (Channel, description: "24V Clean PDU board temperature", units: "\u00b0C", format: ".1f",
                      devcName:"PDU_24VC", type:"BOARDTEMP", pageId:2)

        "24VC_FPGA_T" (Channel, description: "24V Clean PDU FPGA temperature", units: "\u00b0C", format: ".1f",
                     devcName:"PDU_24VC", type:"FPGATEMP", pageId:2)

        Pwr_Cry_HCU_V (Channel, description: "Power/cryo HCU voltage", units: "Volts", format: ".2f",
                       devcName:"PDU_24VC", hwChan:Pdu24VC.CHAN_HCU_PWR_CRY, type:"VOLTAGE", pageId:2)

        Pwr_Cry_HCU_I (Channel, description: "Power/cryo HCU current", units: "mA", format: ".1f",
                       devcName:"PDU_24VC", hwChan:Pdu24VC.CHAN_HCU_PWR_CRY, type:"CURRENT", scale: 1000.0, pageId:2)

        Fes_Shu_HCU_V (Channel, description: "FES/shutter HCU voltage", units: "Volts", format: ".2f",
                       devcName:"PDU_24VC", hwChan:Pdu24VC.CHAN_HCU_FES_SHU, type:"VOLTAGE", pageId:2)

        Fes_Shu_HCU_I (Channel, description: "FES/shutter HCU current", units: "mA", format: ".1f",
                       devcName:"PDU_24VC", hwChan:Pdu24VC.CHAN_HCU_FES_SHU, type:"CURRENT", scale: 1000.0, pageId:2)

        Ion_Pumps_V (Channel, description: "Ion pumps voltage", units: "Volts", format: ".2f",
                     devcName:"PDU_24VC", hwChan:Pdu24VC.CHAN_ION_PUMPS, type:"VOLTAGE", pageId:2)

        Ion_Pumps_I (Channel, description: "Ion pumps current", units: "mA", format: ".1f",
                     devcName:"PDU_24VC", hwChan:Pdu24VC.CHAN_ION_PUMPS, type:"CURRENT", scale: 1000.0, pageId:2)

        Body_Purge_V (Channel, description: "Body purge voltage", units: "Volts", format: ".2f",
                      devcName:"PDU_24VC", hwChan:Pdu24VC.CHAN_BODY_PURGE, type:"VOLTAGE", pageId:2)

        Body_Purge_I (Channel, description: "Body purge current", units: "mA", format: ".1f",
                      devcName:"PDU_24VC", hwChan:Pdu24VC.CHAN_BODY_PURGE, type:"CURRENT", scale: 1000.0, pageId:2)

        Bpu_Maq20_V (Channel, description: "Body purge MAQ20 voltage", units: "Volts", format: ".2f",
                     devcName:"PDU_24VC", hwChan:Pdu24VC.CHAN_BPU_MAQ20, type:"VOLTAGE", pageId:2)

        Bpu_Maq20_I (Channel, description: "Body purge MAQ20 current", units: "mA", format: ".1f",
                     devcName:"PDU_24VC", hwChan:Pdu24VC.CHAN_BPU_MAQ20, type:"CURRENT", scale: 1000.0, pageId:2)

        Gauges_V (Channel, description: "Gauges voltage", units: "Volts", format: ".2f",
                  devcName:"PDU_24VC", hwChan:Pdu24VC.CHAN_GAUGES, type:"VOLTAGE", pageId:2)

        Gauges_I (Channel, description: "Gauges current", units: "mA", format: ".1f",
                  devcName:"PDU_24VC", hwChan:Pdu24VC.CHAN_GAUGES, type:"CURRENT", scale: 1000.0, pageId:2)

        "24VD_Main_V" (Channel, description: "24V Dirty PDU main voltage", units: "Volts", format: ".2f",
                     devcName:"PDU_24VD", type:"MAINVOLT", pageId:3)

        "24VD_Main_I" (Channel, description: "24V Dirty PDU main current", units: "mA", format: ".1f",
                     devcName:"PDU_24VD", type:"MAINCURR", scale: 1000.0, pageId:3)

        "24VD_Main_T" (Channel, description: "24V Dirty PDU main temperature", units: "\u00b0C", format: ".1f",
                     devcName:"PDU_24VD", type:"MAINTEMP", pageId:3)

        "24VD_Board_T" (Channel, description: "24V Dirty PDU board temperature", units: "\u00b0C", format: ".1f",
                      devcName:"PDU_24VD", type:"BOARDTEMP", pageId:3)

        "24VD_FPGA_T" (Channel, description: "24V Dirty PDU FPGA temperature", units: "\u00b0C", format: ".1f",
                     devcName:"PDU_24VD", type:"FPGATEMP", pageId:3)

        Cryo_Turbo_V (Channel, description: "Cryo turbo pump voltage", units: "Volts", format: ".2f",
                      devcName:"PDU_24VD", hwChan:Pdu24VD.CHAN_CRYO_TURBO, type:"VOLTAGE", pageId:3)

        Cryo_Turbo_I (Channel, description: "Cryo turbo pump current", units: "mA", format: ".1f",
                      devcName:"PDU_24VD", hwChan:Pdu24VD.CHAN_CRYO_TURBO, type:"CURRENT", scale: 1000.0, pageId:3)

        Hex_Turbo_V (Channel, description: "Hex turbo pump voltage", units: "Volts", format: ".2f",
                     devcName:"PDU_24VD", hwChan:Pdu24VD.CHAN_HEX_TURBO, type:"VOLTAGE", pageId:3)

        Hex_Turbo_I (Channel, description: "Hex turbo pump current", units: "mA", format: ".1f",
                     devcName:"PDU_24VD", hwChan:Pdu24VD.CHAN_HEX_TURBO, type:"CURRENT", scale: 1000.0, pageId:3)

        "48V_Main_V" (Channel, description: "48V PDU main voltage", units: "Volts", format: ".2f",
                    devcName:"PDU_48V", type:"MAINVOLT", pageId:4)

        "48V_Main_I" (Channel, description: "48V PDU main current", units: "mA", format: ".1f",
                    devcName:"PDU_48V", type:"MAINCURR", scale: 1000.0, pageId:4)

        "48V_Main_T" (Channel, description: "48V PDU main temperature", units: "\u00b0C", format: ".1f",
                    devcName:"PDU_48V", type:"MAINTEMP", pageId:4)

        "48V_Board_T" (Channel, description: "48V PDU board temperature", units: "\u00b0C", format: ".1f",
                      devcName:"PDU_48V", type:"BOARDTEMP", pageId:4)

        "48V_FPGA_T" (Channel, description: "48V PDU FPGA temperature", units: "\u00b0C", format: ".1f",
                    devcName:"PDU_48V", type:"FPGATEMP", pageId:4)

        Purge_Fan_V (Channel, description: "Purge fan voltage", units: "Volts", format: ".2f",
                     devcName:"PDU_24VC", hwChan:Pdu48V.CHAN_PURGE_FAN, type:"VOLTAGE", pageId:4)

        Purge_Fan_I (Channel, description: "Purge fan current", units: "mA", format: ".1f",
                     devcName:"PDU_24VC", hwChan:Pdu48V.CHAN_PURGE_FAN, type:"CURRENT", scale: 1000.0, pageId:4)

        RebBulkPs_Brd_T (Channel, description: "REB Bulk PS board temperature", units: "\u00b0C", format: ".1f",
                         devcName:"REB_Bulk_PS", type:"BOARDTEMP", pageId:5)

        RebBulkPs_0_2_V (Channel, description: "REB Bulk PS 0-2 voltage", units: "Volts", format: ".1f",
                         devcName:"REB_Bulk_PS", hwChan:0, type:"VOLTAGE", pageId:5)

        RebBulkPs_0_2_I (Channel, description: "REB Bulk PS 0-2 current", units: "mA", format: ".1f",
                         devcName:"REB_Bulk_PS", hwChan:0, type:"CURRENT", scale: 1000.0, pageId:5)

        RebBulkPs_0_2_T (Channel, description: "REB Bulk PS 0-2 temperature", units: "\u00b0C", format: ".1f",
                         devcName:"REB_Bulk_PS", hwChan:0, type:"TEMP", pageId:5)

        RebBulkPs_3_5_V (Channel, description: "REB Bulk PS 3-5 voltage", units: "Volts", format: ".1f",
                         devcName:"REB_Bulk_PS", hwChan:1, type:"VOLTAGE", pageId:5)

        RebBulkPs_3_5_I (Channel, description: "REB Bulk PS 3-5 current", units: "mA", format: ".1f",
                         devcName:"REB_Bulk_PS", hwChan:1, type:"CURRENT", scale: 1000.0, pageId:5)

        RebBulkPs_3_5_T (Channel, description: "REB Bulk PS 3-5 temperature", units: "\u00b0C", format: ".1f",
                         devcName:"REB_Bulk_PS", hwChan:1, type:"TEMP", pageId:5)

        RebBulkPs_6_8_V (Channel, description: "REB Bulk PS 6-8 voltage", units: "Volts", format: ".1f",
                         devcName:"REB_Bulk_PS", hwChan:2, type:"VOLTAGE", pageId:5)

        RebBulkPs_6_8_I (Channel, description: "REB Bulk PS 6-8 current", units: "mA", format: ".1f",
                         devcName:"REB_Bulk_PS", hwChan:2, type:"CURRENT", scale: 1000.0, pageId:5)

        RebBulkPs_6_8_T (Channel, description: "REB Bulk PS 6-8 temperature", units: "\u00b0C", format: ".1f",
                         devcName:"REB_Bulk_PS", hwChan:2, type:"TEMP", pageId:5)

        RebBulkPs_9_12_V (Channel, description: "REB Bulk PS 9-12 voltage", units: "Volts", format: ".1f",
                         devcName:"REB_Bulk_PS", hwChan:3, type:"VOLTAGE", pageId:5)

        RebBulkPs_9_12_I (Channel, description: "REB Bulk PS 9-12 current", units: "mA", format: ".1f",
                         devcName:"REB_Bulk_PS", hwChan:3, type:"CURRENT", scale: 1000.0, pageId:5)

        RebBulkPs_9_12_T (Channel, description: "REB Bulk PS 9-12 temperature", units: "\u00b0C", format: ".1f",
                         devcName:"REB_Bulk_PS", hwChan:3, type:"TEMP", pageId:5)

}
