/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.hameg;

import java.util.Timer;
import java.util.TimerTask;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.commons.PowerSupplyDriver;
import org.lsst.ccs.drivers.scpi.Scpi;

public class HMPSeries
extends Scpi
implements PowerSupplyDriver {
    public static final int DEFAULT_BAUDRATE = 9600;
    public static final int MIN_CHANNEL = 1;
    public static final int MAX_CHANNEL = 4;
    public static final int NUM_CHANNELS = 4;
    public static final double MAX_VALUE = Double.POSITIVE_INFINITY;
    private final Timer timer = new Timer("Timer_HMP", true);
    private final long[] onDelay = new long[4];
    private final long[] offDelay = new long[4];
    private final SetOutput[] outTask = new SetOutput[4];
    private int maxChannel;
    private int numChannels;

    public HMPSeries() {
        this.setOptions(Ascii.Option.NO_NET);
    }

    public void open(DriverConstants.ConnType connType, String ident, int baudRate, int dataChar) throws DriverException {
        super.open(connType, ident, baudRate == 0 ? 9600 : baudRate, dataChar);
        try {
            this.checkIdentification("HAMEG", 0, "HMP", 1);
            String model = this.getIdentification()[1];
            try {
                this.numChannels = Integer.valueOf(model.substring(5, 6));
            }
            catch (NumberFormatException e) {
                throw new DriverException("Unrecognized model: " + model);
            }
            if (this.numChannels > 4) {
                throw new DriverException("Unsupported model: " + model);
            }
            this.maxChannel = 1 + this.numChannels - 1;
        }
        catch (NumberFormatException | DriverException e) {
            this.closeSilent();
            this.maxChannel = 0;
            this.numChannels = 0;
            throw e;
        }
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public void setOutput(boolean on, int chan) throws DriverException {
        this.checkChannel(chan);
        int index = chan - 1;
        long delay = on ? this.onDelay[index] : this.offDelay[index];
        String command = "OUTP " + (on ? "1" : "0");
        SetOutput task = this.outTask[index];
        if (task != null) {
            task.cancel();
            this.outTask[index] = null;
        }
        if (delay == 0L) {
            this.writeChan(command, chan);
        } else {
            this.outTask[index] = new SetOutput(command, chan);
            this.timer.schedule((TimerTask)this.outTask[index], delay);
        }
    }

    public boolean getOutput(int chan) throws DriverException {
        return this.readIntegerChan("OUTP?", chan) != 0;
    }

    public void setOnDelay(double time, int chan) throws DriverException {
        this.checkChannel(chan);
        this.onDelay[chan - 1] = (long)(1000.0 * time);
    }

    public void setOffDelay(double time, int chan) throws DriverException {
        this.checkChannel(chan);
        this.offDelay[chan - 1] = (long)(1000.0 * time);
    }

    public void setVoltage(double value, int chan) throws DriverException {
        this.writeChan("VOLT " + (Double.isFinite(value) ? Double.valueOf(value) : "MAX"), chan);
    }

    public double getVoltage(int chan) throws DriverException {
        return this.readDoubleChan("VOLT?", chan);
    }

    public double getMaximumVoltage(int chan) throws DriverException {
        return this.readDoubleChan("VOLT? MAX", chan);
    }

    public double readVoltage(int chan) throws DriverException {
        return this.readDoubleChan("MEAS:VOLT?", chan);
    }

    public void setCurrent(double value, int chan) throws DriverException {
        this.writeChan("CURR " + (Double.isFinite(value) ? Double.valueOf(value) : "MAX"), chan);
    }

    public double getCurrent(int chan) throws DriverException {
        return this.readDoubleChan("CURR?", chan);
    }

    public double getMaximumCurrent(int chan) throws DriverException {
        return this.readDoubleChan("CURR? MAX", chan);
    }

    public double readCurrent(int chan) throws DriverException {
        return this.readDoubleChan("MEAS:CURR?", chan);
    }

    public void setVoltageLimit(double value, int chan) throws DriverException {
        this.writeChan("VOLT:PROT " + (Double.isFinite(value) ? Double.valueOf(value) : "MAX"), chan);
    }

    public double getVoltageLimit(int chan) throws DriverException {
        return this.readDoubleChan("VOLT:PROT?", chan);
    }

    public boolean isVoltageTripped(int chan) throws DriverException {
        return this.readIntegerChan("VOLT:PROT:TRIP?", chan) != 0;
    }

    public void clearVoltageTrip(int chan) throws DriverException {
        this.writeChan("VOLT:PROT:CLEAR", chan);
    }

    public void lockPanel(boolean lock) throws DriverException {
        this.writeCommand(lock ? "SYST:RWL" : "SYST:LOC");
    }

    public void beep() throws DriverException {
        this.writeCommand("SYST:BEEP");
    }

    private void checkChannel(int chan) throws DriverException {
        if (chan < 1 || chan > this.maxChannel) {
            throw new DriverException("Invalid channel number");
        }
    }

    private void writeSelect(int chan) throws DriverException {
        this.checkChannel(chan);
        this.writeCommand("INST:NSEL " + chan);
    }

    private synchronized void writeChan(String instr, int chan) throws DriverException {
        this.writeSelect(chan);
        this.writeCommand(instr);
    }

    private synchronized double readDoubleChan(String instr, int chan) throws DriverException {
        this.writeSelect(chan);
        return this.readDouble(instr);
    }

    private synchronized int readIntegerChan(String instr, int chan) throws DriverException {
        this.writeSelect(chan);
        return this.readInteger(instr);
    }

    class SetOutput
    extends TimerTask {
        private final int chan;
        private final String command;

        SetOutput(String command, int chan) {
            this.command = command;
            this.chan = chan;
        }

        @Override
        public void run() {
            try {
                HMPSeries.this.writeChan(this.command, this.chan);
            }
            catch (DriverException driverException) {
                // empty catch block
            }
            ((HMPSeries)HMPSeries.this).outTask[this.chan - 1] = null;
        }
    }
}

